package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_3675;

public class OnKeyReleasedListener extends AbstractListener {

    @Nullable
    private String lastKeyName;
    @Nullable
    private Integer lastKeycode;
    @Nullable
    private Integer lastScancode;
    @Nullable
    private Integer lastModifiers;

    public OnKeyReleasedListener() {
        super("keyboard_key_released");
    }

    public void handleKeyReleased(int keycode, int scancode, int modifiers) {
        this.lastKeyName = class_3675.method_15985(keycode, scancode).method_27445().getString();
        this.lastKeycode = keycode;
        this.lastScancode = scancode;
        this.lastModifiers = modifiers;
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<CustomVariable> list) {
        list.add(new CustomVariable("key_name", () -> this.formatString(this.lastKeyName)));
        list.add(new CustomVariable("key_keycode", () -> this.formatInteger(this.lastKeycode)));
        list.add(new CustomVariable("key_scancode", () -> this.formatInteger(this.lastScancode)));
        list.add(new CustomVariable("key_modifiers", () -> this.formatInteger(this.lastModifiers)));
    }

    private String formatString(@Nullable String value) {
        if (value == null || value.isBlank()) return "ERROR";
        return value;
    }

    private String formatInteger(@Nullable Integer value) {
        if (value == null) return "ERROR";
        return Integer.toString(value);
    }

    @Override
    public @NotNull class_2561 getDisplayName() {
        return class_2561.method_43471("fancymenu.listeners.on_key_released");
    }

    @Override
    public @NotNull List<class_2561> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_key_released.desc"));
    }
}