package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public class OnOpenScreenListener extends AbstractListener {

    @Nullable
    private String lastScreenIdentifier;

    public OnOpenScreenListener() {
        super("screen_open");
    }

    public void onScreenOpened(@NotNull class_437 screen) {
        this.lastScreenIdentifier = ScreenIdentifierHandler.getIdentifierOfScreen(screen);
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<CustomVariable> list) {
        list.add(new CustomVariable("screen_identifier", () -> this.lastScreenIdentifier != null ? this.lastScreenIdentifier : "ERROR"));
    }

    @Override
    public @NotNull class_2561 getDisplayName() {
        return class_2561.method_43471("fancymenu.listeners.on_open_screen");
    }

    @Override
    public @NotNull List<class_2561> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_open_screen.desc"));
    }

}