package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2561;

public class OnPositionChangedListener extends AbstractListener {

    private boolean cachedPositionsValid;
    private int cachedOldX;
    private int cachedOldY;
    private int cachedOldZ;
    private int cachedNewX;
    private int cachedNewY;
    private int cachedNewZ;

    public OnPositionChangedListener() {
        super("position_changed");
    }

    public void onPositionChanged(@NotNull class_2338 oldPosition, @NotNull class_2338 newPosition) {
        this.cachedPositionsValid = true;
        this.cachedOldX = oldPosition.method_10263();
        this.cachedOldY = oldPosition.method_10264();
        this.cachedOldZ = oldPosition.method_10260();
        this.cachedNewX = newPosition.method_10263();
        this.cachedNewY = newPosition.method_10264();
        this.cachedNewZ = newPosition.method_10260();
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<CustomVariable> list) {
        list.add(new CustomVariable("old_pos_x", () -> this.cachedPositionsValid ? Integer.toString(this.cachedOldX) : "ERROR"));
        list.add(new CustomVariable("old_pos_y", () -> this.cachedPositionsValid ? Integer.toString(this.cachedOldY) : "ERROR"));
        list.add(new CustomVariable("old_pos_z", () -> this.cachedPositionsValid ? Integer.toString(this.cachedOldZ) : "ERROR"));
        list.add(new CustomVariable("new_pos_x", () -> this.cachedPositionsValid ? Integer.toString(this.cachedNewX) : "ERROR"));
        list.add(new CustomVariable("new_pos_y", () -> this.cachedPositionsValid ? Integer.toString(this.cachedNewY) : "ERROR"));
        list.add(new CustomVariable("new_pos_z", () -> this.cachedPositionsValid ? Integer.toString(this.cachedNewZ) : "ERROR"));
    }

    @Override
    public @NotNull class_2561 getDisplayName() {
        return class_2561.method_43471("fancymenu.listeners.on_position_changed");
    }

    @Override
    public @NotNull List<class_2561> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_position_changed.desc"));
    }
}
