package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class OnSteppingOnBlockListener extends AbstractListener {

    @Nullable
    private class_2338 lastBlockPos;
    @Nullable
    private String cachedBlockKey;

    public OnSteppingOnBlockListener() {
        super("stepping_on_block");
    }

    public void onSteppedOnBlock(@NotNull class_2338 blockPos, @NotNull class_2680 blockState) {
        this.lastBlockPos = blockPos.method_10062();
        class_2960 blockKeyLocation = class_2378.field_11146.method_10221(blockState.method_26204());
        this.cachedBlockKey = (blockKeyLocation != null) ? blockKeyLocation.toString() : null;
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<CustomVariable> list) {
        list.add(new CustomVariable("block_key", () -> this.cachedBlockKey != null ? this.cachedBlockKey : "ERROR"));
        list.add(new CustomVariable("block_pos_x", () -> this.lastBlockPos != null ? Integer.toString(this.lastBlockPos.method_10263()) : "0"));
        list.add(new CustomVariable("block_pos_y", () -> this.lastBlockPos != null ? Integer.toString(this.lastBlockPos.method_10264()) : "0"));
        list.add(new CustomVariable("block_pos_z", () -> this.lastBlockPos != null ? Integer.toString(this.lastBlockPos.method_10260()) : "0"));
    }

    @Override
    public @NotNull class_2561 getDisplayName() {
        return class_2561.method_43471("fancymenu.listeners.on_stepping_on_block");
    }

    @Override
    public @NotNull List<class_2561> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_stepping_on_block.desc"));
    }
}