package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1111;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_746;

public class OnWorldSoundTriggeredListener extends AbstractListener {

    @Nullable
    private String cachedSoundResourceLocation;
    @Nullable
    private String cachedSoundDisplayName;
    @Nullable
    private String cachedSoundOriginPosX;
    @Nullable
    private String cachedSoundOriginPosY;
    @Nullable
    private String cachedSoundOriginPosZ;
    @Nullable
    private String cachedSoundOriginDistanceToPlayer;
    @Nullable
    private String cachedSoundOriginDirectionFromPlayer;

    public OnWorldSoundTriggeredListener() {
        super("world_sound_triggered");
    }

    public void onWorldSoundTriggered(@NotNull class_1113 sound, @Nullable class_2561 subtitle, float audibleRange) {
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        if ((minecraft.field_1687 == null) || (player == null)) {
            return;
        }
        if (sound.method_4787()) {
            return;
        }
        if (!Float.isFinite(audibleRange)) {
            return;
        }

        class_243 soundPosition = new class_243(sound.method_4784(), sound.method_4779(), sound.method_4778());
        class_243 playerPosition = player.method_19538();
        double distanceToPlayer = soundPosition.method_1022(playerPosition);

        this.cachedSoundResourceLocation = this.resolveSoundResourceLocation(sound);
        this.cachedSoundDisplayName = this.resolveDisplayName(subtitle, this.cachedSoundResourceLocation);
        this.cachedSoundOriginPosX = Double.toString(soundPosition.field_1352);
        this.cachedSoundOriginPosY = Double.toString(soundPosition.field_1351);
        this.cachedSoundOriginPosZ = Double.toString(soundPosition.field_1350);
        this.cachedSoundOriginDistanceToPlayer = Double.toString(distanceToPlayer);
        this.cachedSoundOriginDirectionFromPlayer = Double.toString(this.calculateDirectionDegrees(player, soundPosition));

        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<CustomVariable> list) {
        list.add(new CustomVariable("sound_resource_location", () -> this.cachedSoundResourceLocation != null ? this.cachedSoundResourceLocation : "ERROR"));
        list.add(new CustomVariable("sound_display_name", () -> this.cachedSoundDisplayName != null ? this.cachedSoundDisplayName : "UNKNOWN"));
        list.add(new CustomVariable("sound_origin_pos_x", () -> this.cachedSoundOriginPosX != null ? this.cachedSoundOriginPosX : "0"));
        list.add(new CustomVariable("sound_origin_pos_y", () -> this.cachedSoundOriginPosY != null ? this.cachedSoundOriginPosY : "0"));
        list.add(new CustomVariable("sound_origin_pos_z", () -> this.cachedSoundOriginPosZ != null ? this.cachedSoundOriginPosZ : "0"));
        list.add(new CustomVariable("sound_origin_distance_to_player", () -> this.cachedSoundOriginDistanceToPlayer != null ? this.cachedSoundOriginDistanceToPlayer : "0"));
        list.add(new CustomVariable("sound_origin_direction_from_player", () -> this.cachedSoundOriginDirectionFromPlayer != null ? this.cachedSoundOriginDirectionFromPlayer : "0"));
    }

    @Override
    public @NotNull class_2561 getDisplayName() {
        return class_2561.method_43471("fancymenu.listeners.on_world_sound_triggered");
    }

    @Override
    public @NotNull List<class_2561> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_world_sound_triggered.desc"));
    }

    @Nullable
    private String resolveSoundResourceLocation(@NotNull class_1113 sound) {
        class_1111 resolvedSound = sound.method_4776();
        if ((resolvedSound != null) && (resolvedSound != class_1144.field_5592)) {
            class_2960 path = resolvedSound.method_4766();
            if (path != null) {
                return path.toString();
            }
            class_2960 directLocation = resolvedSound.method_4767();
            if (directLocation != null) {
                return directLocation.toString();
            }
        }
        class_2960 fallback = sound.method_4775();
        return (fallback != null) ? fallback.toString() : null;
    }

    @NotNull
    private String resolveDisplayName(@Nullable class_2561 subtitle, @Nullable String fallback) {
        if (subtitle != null) {
            String plain = subtitle.getString();
            if (!plain.isBlank()) {
                return plain;
            }
        }
        if ((fallback != null) && !fallback.isBlank()) {
            return fallback;
        }
        return "UNKNOWN";
    }

    private double calculateDirectionDegrees(@NotNull class_746 player, @NotNull class_243 soundPosition) {
        class_243 playerPosition = player.method_19538();
        double deltaX = soundPosition.field_1352 - playerPosition.field_1352;
        double deltaZ = soundPosition.field_1350 - playerPosition.field_1350;
        if ((Math.abs(deltaX) < 1.0E-6D) && (Math.abs(deltaZ) < 1.0E-6D)) {
            return 0.0D;
        }
        double angleToSound = Math.toDegrees(Math.atan2(deltaZ, deltaX)) - 90.0D;
        double relative = class_3532.method_15338(angleToSound - player.method_36454());
        double normalized = relative % 360.0D;
        if (normalized < 0.0D) {
            normalized += 360.0D;
        }
        return normalized;
    }
}


