package de.keksuccino.fancymenu.customization.loadingrequirement.requirements;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.customization.variables.VariableHandler;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import org.jetbrains.annotations.NotNull;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class IsVariableValueRequirement extends LoadingRequirement {

    public IsVariableValueRequirement() {
        super("fancymenu_visibility_requirement_is_variable_value");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {

        if (value != null) {
            if (value.contains(":")) {
                String name = value.split(":", 2)[0];
                String val = value.split(":", 2)[1];
                if (VariableHandler.variableExists(name)) {
                    String storedVal = Objects.requireNonNull(VariableHandler.getVariable(name)).getValue();
                    return val.equals(storedVal);
                }
            }
        }

        return false;

    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.requirements.is_variable_value");
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.is_variable_value.desc"));
    }

    @Override
    public String getCategory() {
        return null;
    }

    @Override
    public String getValueDisplayName() {
        return class_1074.method_4662("fancymenu.helper.visibilityrequirement.is_variable_value.value.desc");
    }

    @Override
    public String getValuePreset() {
        return "<variable_name>:<value_to_check_for>";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

    @Override
    public void editValue(@NotNull class_437 parentScreen, @NotNull LoadingRequirementInstance requirementInstance) {
        IsVariableValueConfigScreen s = new IsVariableValueConfigScreen(Objects.requireNonNullElse(requirementInstance.value, ""), callback -> {
            if (callback != null) {
                requirementInstance.value = callback;
            }
            class_310.method_1551().method_1507(parentScreen);
        });
        class_310.method_1551().method_1507(s);
    }

    public static class IsVariableValueConfigScreen extends StringBuilderScreen {

        @NotNull
        protected String variableName = "";
        @NotNull
        protected String variableValue = "";

        protected TextInputCell nameCell;
        protected TextInputCell valueCell;
        protected EditBoxSuggestions variableNameSuggestions;

        protected IsVariableValueConfigScreen(String value, @NotNull Consumer<String> callback) {
            super(class_2561.method_43471("fancymenu.requirements.is_variable_value.value.desc"), callback);
            if (value == null) value = "";
            if (value.contains(":")) {
                this.variableName = value.split(":", 2)[0];
                this.variableValue = value.split(":", 2)[1];
            }
        }

        @Override
        protected void initCells() {

            this.addSpacerCell(20);

            String name = this.getVarNameString();
            this.addLabelCell(class_2561.method_43471("fancymenu.requirements.is_variable_value.var_name"));
            this.nameCell = this.addTextInputCell(null, true, true).setText(name);

            this.addCellGroupEndSpacerCell();

            this.variableNameSuggestions = EditBoxSuggestions.createWithCustomSuggestions(this, this.nameCell.editBox, EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, VariableHandler.getVariableNames());
            UIBase.applyDefaultWidgetSkinTo(this.variableNameSuggestions);
            this.nameCell.editBox.method_1863(s -> this.variableNameSuggestions.method_23934());

            this.addCellGroupEndSpacerCell();

            String value = this.getVarValueString();
            this.addLabelCell(class_2561.method_43471("fancymenu.requirements.is_variable_value.var_value"));
            this.valueCell = this.addTextInputCell(null, true, true).setText(value);

            this.addSpacerCell(20);

        }

        @Override
        public void render(GuiGraphics pose, int mouseX, int mouseY, float partial) {
            super.render(pose, mouseX, mouseY, partial);
            this.variableNameSuggestions.method_23923(pose.pose(), mouseX, mouseY);
        }

        @Override
        public boolean method_25404(int $$0, int $$1, int $$2) {
            if (this.variableNameSuggestions.method_23924($$0, $$1, $$2)) return true;
            return super.method_25404($$0, $$1, $$2);
        }

        @Override
        public boolean method_25401(double $$0, double $$1, double $$2) {
            if (this.variableNameSuggestions.method_23921($$2)) return true;
            return super.method_25401($$0, $$1, $$2);
        }

        @Override
        public boolean method_25402(double $$0, double $$1, int $$2) {
            if (this.variableNameSuggestions.method_23922($$0, $$1, $$2)) return true;
            return super.method_25402($$0, $$1, $$2);
        }

        @Override
        public @NotNull String buildString() {
            return this.getVarNameString() + ":" + this.getVarValueString();
        }

        @NotNull
        protected String getVarNameString() {
            if (this.nameCell != null) {
                return this.nameCell.getText();
            }
            return this.variableName;
        }

        @NotNull
        protected String getVarValueString() {
            if (this.valueCell != null) {
                return this.valueCell.getText();
            }
            return this.variableValue;
        }

    }

}
