package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.world.player;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5458;
import net.minecraft.class_638;
import net.minecraft.class_746;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class IsPlayerInDimensionRequirement extends LoadingRequirement {

    private static final Logger LOGGER = LogManager.getLogger();

    public IsPlayerInDimensionRequirement() {
        super("is_player_in_dimension");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        try {
            if ((value == null) || value.trim().isEmpty()) return false;
            class_638 level = class_310.method_1551().field_1687;
            class_746 player = class_310.method_1551().field_1724;
            if ((level != null) && (player != null)) {
                return value.equals(level.method_44013().method_29177().toString());
            }
        } catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to handle '" + this.getIdentifier() + "' loading requirement!", ex);
        }
        return false;
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.requirements.world.is_player_in_dimension");
    }

    @Override
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.world.is_player_in_dimension.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.requirements.categories.world");
    }

    @Override
    public String getValueDisplayName() {
        return class_1074.method_4662("fancymenu.requirements.world.is_player_in_dimension.value");
    }

    @Override
    public String getValuePreset() {
        return "minecraft:overworld";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

    @Override
    public void editValue(@NotNull class_437 parentScreen, @NotNull LoadingRequirementInstance requirementInstance) {
        IsPlayerInDimensionValueConfigScreen s = new IsPlayerInDimensionValueConfigScreen(Objects.requireNonNullElse(requirementInstance.value, this.getValuePreset()), callback -> {
            if (callback != null) {
                requirementInstance.value = callback;
            }
            class_310.method_1551().method_1507(parentScreen);
        });
        class_310.method_1551().method_1507(s);
    }

    private static @NotNull List<class_2960> getDimensionTypes() {
        List<class_2960> types = new ArrayList<>();
        try {
            class_638 level = class_310.method_1551().field_1687;
            if (level != null) {
                class_5458.field_38009.method_40295().forEach(biomeHolder -> biomeHolder.method_40229().map(key -> types.add(key.method_29177()), biome -> ""));
                //level.registryAccess().lookupOrThrow(Registries.DIMENSION_TYPE).listElementIds().forEach(dimensionTypeResourceKey -> types.add(dimensionTypeResourceKey.location()));
            }
        } catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to get dimension types for 'Is Player In Dimension' loading requirement!", ex);
        }
        return types;
    }

    public static class IsPlayerInDimensionValueConfigScreen extends StringBuilderScreen {

        @NotNull
        protected String value;

        protected TextInputCell textInput;
        protected EditBoxSuggestions suggestions;

        protected IsPlayerInDimensionValueConfigScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super(class_2561.method_43471("fancymenu.elements.requirements.edit_value"), callback);
            this.value = value;
        }

        @Override
        protected void initCells() {

            this.addSpacerCell(20);

            String id = this.getValueString();
            this.addLabelCell(class_2561.method_43471("fancymenu.requirements.world.is_player_in_dimension.value"));
            this.textInput = this.addTextInputCell(null, true, true).setText(id);

            this.addCellGroupEndSpacerCell();

            List<String> suggestionValues = new ArrayList<>();
            getDimensionTypes().forEach(location -> suggestionValues.add(location.toString()));
            if (suggestionValues.isEmpty()) {
                suggestionValues.add(class_1074.method_4662("fancymenu.requirements.world.is_player_in_dimension.suggestions.error"));
            }

            this.suggestions = EditBoxSuggestions.createWithCustomSuggestions(this, this.textInput.editBox, EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, suggestionValues);
            UIBase.applyDefaultWidgetSkinTo(this.suggestions);
            this.textInput.editBox.method_1863(s -> this.suggestions.method_23934());

            this.addSpacerCell(20);

        }

        @Override
        public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            super.render(graphics, mouseX, mouseY, partial);
            this.suggestions.method_23923(graphics.pose(), mouseX, mouseY);
        }

        @Override
        public boolean method_25404(int $$0, int $$1, int $$2) {
            if (this.suggestions.method_23924($$0, $$1, $$2)) return true;
            return super.method_25404($$0, $$1, $$2);
        }

        @Override
        public boolean method_25401(double $$0, double $$1, double scrollDeltaY) {
            if (this.suggestions.method_23921(scrollDeltaY)) return true;
            return super.method_25401($$0, $$1, scrollDeltaY);
        }

        @Override
        public boolean method_25402(double $$0, double $$1, int $$2) {
            if (this.suggestions.method_23922($$0, $$1, $$2)) return true;
            return super.method_25402($$0, $$1, $$2);
        }

        @Override
        public @NotNull String buildString() {
            return this.getValueString();
        }

        @NotNull
        protected String getValueString() {
            if (this.textInput != null) {
                return this.textInput.getText();
            }
            return this.value;
        }

    }

}
