package de.keksuccino.fancymenu.customization.loadingrequirement.ui;

import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.ModernScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementGroup;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class BuildRequirementGroupScreen extends ModernScreen {

    protected class_437 parentScreen;
    protected LoadingRequirementContainer parent;
    protected LoadingRequirementGroup group;
    protected boolean isEdit;
    protected Consumer<LoadingRequirementGroup> callback;

    protected ScrollArea requirementsScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedButton groupModeButton;
    protected ExtendedButton addRequirementButton;
    protected ExtendedButton removeRequirementButton;
    protected ExtendedButton editRequirementButton;
    protected ExtendedButton doneButton;
    protected ExtendedButton cancelButton;
    protected AdvancedTextField groupIdentifierTextField;

    public BuildRequirementGroupScreen(@Nullable class_437 parentScreen, @NotNull LoadingRequirementContainer parent, @Nullable LoadingRequirementGroup groupToEdit, @NotNull Consumer<LoadingRequirementGroup> callback) {

        super((groupToEdit != null) ? class_2561.method_43470(class_1074.method_4662("fancymenu.requirements.screens.edit_group")) : class_2561.method_43470(class_1074.method_4662("fancymenu.requirements.screens.add_group")));

        this.parentScreen = parentScreen;
        this.parent = parent;
        this.group = (groupToEdit != null) ? groupToEdit : new LoadingRequirementGroup("group_" + System.currentTimeMillis(), LoadingRequirementGroup.GroupMode.AND, parent);
        this.callback = callback;
        this.isEdit = groupToEdit != null;
        this.updateRequirementsScrollArea();

        this.groupIdentifierTextField = new AdvancedTextField(class_310.method_1551().field_1772, 0, 0, 150, 20, true, CharacterFilter.getBasicFilenameCharacterFilter()) {
            @Override
            public void method_25394(@NotNull class_4587 pose, int mouseX, int mouseY, float partial) {
                super.method_25394(pose, mouseX, mouseY, partial);
                BuildRequirementGroupScreen.this.group.identifier = this.method_1882();
            }
        };
        if (this.group.identifier != null) {
            this.groupIdentifierTextField.method_1852(this.group.identifier);
        }

    }

    @Override
    protected void method_25426() {

        //Reset the GUI scale in case the layout editor changed it
        class_310.method_1551().method_22683().method_15997(class_310.method_1551().method_22683().method_4476(class_310.method_1551().field_1690.method_42474().method_41753(), class_310.method_1551().method_1573()));
		this.field_22790 = class_310.method_1551().method_22683().method_4502();
		this.field_22789 = class_310.method_1551().method_22683().method_4486();

        this.groupModeButton = new ExtendedButton(0, 0, 150, 20, "", (button) -> {
            if (this.group.mode == LoadingRequirementGroup.GroupMode.AND) {
                this.group.mode = LoadingRequirementGroup.GroupMode.OR;
            } else {
                this.group.mode = LoadingRequirementGroup.GroupMode.AND;
            }
        }) {
            @Override
            public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
                if (BuildRequirementGroupScreen.this.group.mode == LoadingRequirementGroup.GroupMode.AND) {
                    this.setLabel(class_1074.method_4662("fancymenu.requirements.screens.build_group_screen.mode.and"));
                } else {
                    this.setLabel(class_1074.method_4662("fancymenu.requirements.screens.build_group_screen.mode.or"));
                }
                super.render(graphics, mouseX, mouseY, partial);
            }
        };
        this.method_25429(this.groupModeButton);
        this.groupModeButton.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.build_group_screen.mode.desc")));
        UIBase.applyDefaultWidgetSkinTo(this.groupModeButton);

        this.addRequirementButton = new ExtendedButton(0, 0, 150, 20, class_1074.method_4662("fancymenu.requirements.screens.add_requirement"), (button) -> {
            BuildRequirementScreen s = new BuildRequirementScreen(this, this.parent, null, (call) -> {
                if (call != null) {
                    this.group.addInstance(call);
                    this.updateRequirementsScrollArea();
                }
            });
            class_310.method_1551().method_1507(s);
        });
        this.method_25429(this.addRequirementButton);
        this.addRequirementButton.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.build_group_screen.add_requirement.desc")));
        UIBase.applyDefaultWidgetSkinTo(this.addRequirementButton);

        this.editRequirementButton = new ExtendedButton(0, 0, 150, 20, class_1074.method_4662("fancymenu.requirements.screens.edit_requirement"), (button) -> {
            LoadingRequirementInstance i = this.getSelectedInstance();
            if (i != null) {
                BuildRequirementScreen s = new BuildRequirementScreen(this, this.parent, i, (call) -> {
                    if (call != null) {
                        this.updateRequirementsScrollArea();
                    }
                });
                class_310.method_1551().method_1507(s);
            }
        }) {
            @Override
            public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
                if (BuildRequirementGroupScreen.this.getSelectedInstance() == null) {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.build_group_screen.no_requirement_selected")));
                    this.field_22763 = false;
                } else {
                    this.setTooltip((Tooltip) null);
                    this.field_22763 = true;
                }
                super.render(graphics, mouseX, mouseY, partial);
            }
        };
        this.method_25429(this.editRequirementButton);
        this.editRequirementButton.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.build_group_screen.edit_requirement.desc")));
        UIBase.applyDefaultWidgetSkinTo(this.editRequirementButton);

        this.removeRequirementButton = new ExtendedButton(0, 0, 150, 20, class_1074.method_4662("fancymenu.requirements.screens.remove_requirement"), (button) -> {
            LoadingRequirementInstance i = this.getSelectedInstance();
            if (i != null) {
                class_310.method_1551().method_1507(ConfirmationScreen.ofStrings((call) -> {
                    if (call) {
                        this.group.removeInstance(i);
                        this.updateRequirementsScrollArea();
                    }
                    class_310.method_1551().method_1507(this);
                }, LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.remove_requirement.confirm")));
            }
        }) {
            @Override
            public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
                if (BuildRequirementGroupScreen.this.getSelectedInstance() == null) {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.build_group_screen.no_requirement_selected")));
                    this.field_22763 = false;
                } else {
                    this.setTooltip((Tooltip) null);
                    this.field_22763 = true;
                }
                super.render(graphics, mouseX, mouseY, partial);
            }
        };
        this.method_25429(this.removeRequirementButton);
        this.removeRequirementButton.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.build_group_screen.remove_requirement.desc")));
        UIBase.applyDefaultWidgetSkinTo(this.removeRequirementButton);

        this.doneButton = new ExtendedButton(0, 0, 150, 20, class_1074.method_4662("fancymenu.common_components.done"), (button) -> {
            class_310.method_1551().method_1507(this.parentScreen);
            this.callback.accept(this.group);
        }) {
            @Override
            public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                BuildRequirementGroupScreen s = BuildRequirementGroupScreen.this;
                if (s.group.getInstances().isEmpty()) {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.build_group_screen.finish.no_requirements_added")));
                    this.field_22763 = false;
                } else if ((s.parent.getGroup(s.group.identifier) != null) && (s.parent.getGroup(s.group.identifier) != s.group)) {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.build_group_screen.finish.identifier_already_used")));
                    this.field_22763 = false;
                } else if ((s.group.identifier == null) || (s.group.identifier.replace(" ", "").length() == 0)) {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.build_group_screen.finish.identifier_too_short")));
                    this.field_22763 = false;
                } else {
                    this.setTooltip((Tooltip) null);
                    this.field_22763 = true;
                }
                super.renderWidget(graphics, mouseX, mouseY, partialTicks);
            }
        };
        this.method_25429(this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);

        this.cancelButton = new ExtendedButton(0, 0, 150, 20, class_1074.method_4662("fancymenu.common_components.cancel"), (button) -> {
            class_310.method_1551().method_1507(this.parentScreen);
            if (this.isEdit) {
                this.callback.accept(this.group);
            } else {
                this.callback.accept(null);
            }
        });
        this.method_25429(this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);

    }

    @Override
    public void method_25419() {
        class_310.method_1551().method_1507(this.parentScreen);
        if (this.isEdit) {
            this.callback.accept(this.group);
        } else {
            this.callback.accept(null);
        }
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {

        graphics.fill(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());

        class_2561 titleComp = this.field_22785.method_27661().method_27696(class_2583.field_24360.method_10982(true));
        graphics.drawString(this.field_22793, titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);

        graphics.drawString(this.field_22793, class_1074.method_4662("fancymenu.requirements.screens.build_group_screen.group_requirements"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);

        this.requirementsScrollArea.setWidth(this.field_22789 - 20 - 150 - 20 - 20, true);
        this.requirementsScrollArea.setHeight(this.field_22790 - 85, true);
        this.requirementsScrollArea.setX(20, true);
        this.requirementsScrollArea.setY(50 + 15, true);
        this.requirementsScrollArea.render(graphics, mouseX, mouseY, partial);

        this.doneButton.setX(this.field_22789 - 20 - this.doneButton.method_25368());
        this.doneButton.setY(this.field_22790 - 20 - 20);
        this.doneButton.render(graphics, mouseX, mouseY, partial);

        if (!this.isEdit) {
            this.cancelButton.setX(this.field_22789 - 20 - this.cancelButton.method_25368());
            this.cancelButton.setY(this.doneButton.getY() - 5 - 20);
            this.cancelButton.render(graphics, mouseX, mouseY, partial);
        } else {
            this.cancelButton.field_22763 = false;
        }

        this.removeRequirementButton.setX(this.field_22789 - 20 - this.removeRequirementButton.method_25368());
        this.removeRequirementButton.setY(((this.isEdit) ? this.doneButton.getY() : this.cancelButton.getY()) - 15 - 20);
        this.removeRequirementButton.render(graphics, mouseX, mouseY, partial);

        this.editRequirementButton.setX(this.field_22789 - 20 - this.editRequirementButton.method_25368());
        this.editRequirementButton.setY(this.removeRequirementButton.getY() - 5 - 20);
        this.editRequirementButton.render(graphics, mouseX, mouseY, partial);

        this.addRequirementButton.setX(this.field_22789 - 20 - this.addRequirementButton.method_25368());
        this.addRequirementButton.setY(this.editRequirementButton.getY() - 5 - 20);
        this.addRequirementButton.render(graphics, mouseX, mouseY, partial);

        this.groupModeButton.setX(this.field_22789 - 20 - this.groupModeButton.method_25368());
        this.groupModeButton.setY(this.addRequirementButton.getY() - 5 - 20);
        this.groupModeButton.render(graphics, mouseX, mouseY, partial);

        this.groupIdentifierTextField.method_16872(this.field_22789 - 20 - this.groupIdentifierTextField.method_25368());
        this.groupIdentifierTextField.setY(this.groupModeButton.getY() - 15 - 20);
        this.groupIdentifierTextField.method_25394(graphics.pose(), mouseX, mouseY, partial);

        String idLabel = class_1074.method_4662("fancymenu.requirements.screens.build_group_screen.group_identifier");
        int idLabelWidth = this.field_22793.method_1727(idLabel);
        graphics.drawString(this.field_22793, idLabel, this.field_22789 - 20 - idLabelWidth, this.groupIdentifierTextField.getY() - 15, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);

        super.render(graphics, mouseX, mouseY, partial);

    }

    @Override
    public void renderBackground(@NotNull GuiGraphics $$0) {
    }

    @Nullable
    protected LoadingRequirementInstance getSelectedInstance() {
        ScrollAreaEntry e = this.requirementsScrollArea.getFocusedEntry();
        if (e instanceof ManageRequirementsScreen.RequirementInstanceEntry) {
            return ((ManageRequirementsScreen.RequirementInstanceEntry) e).instance;
        }
        return null;
    }

    protected void updateRequirementsScrollArea() {

        this.requirementsScrollArea.clearEntries();

        for (LoadingRequirementInstance i : this.group.getInstances()) {
            ManageRequirementsScreen.RequirementInstanceEntry e = new ManageRequirementsScreen.RequirementInstanceEntry(this.requirementsScrollArea, i, 14);
            this.requirementsScrollArea.addEntry(e);
        }

    }

}
