package de.keksuccino.fancymenu.customization.loadingrequirement.ui;

import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.ModernScreen;
import de.keksuccino.fancymenu.util.rendering.text.TextFormattingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirementRegistry;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.*;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class BuildRequirementScreen extends ModernScreen {

    protected class_437 parentScreen;
    protected LoadingRequirementContainer parent;
    protected final LoadingRequirementInstance instance;
    protected boolean isEdit;
    protected Consumer<LoadingRequirementInstance> callback;

    protected ScrollArea requirementsListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ScrollArea descriptionScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedEditBox searchBar;

    private static final Comparator<LoadingRequirement> REQUIREMENT_DISPLAY_NAME_COMPARATOR = Comparator
            .comparing((LoadingRequirement requirement) -> requirement.getDisplayName(), String.CASE_INSENSITIVE_ORDER)
            .thenComparing(LoadingRequirement::getDisplayName)
            .thenComparing(LoadingRequirement::getIdentifier);

    public BuildRequirementScreen(@Nullable class_437 parentScreen, @NotNull LoadingRequirementContainer parent, @Nullable LoadingRequirementInstance instanceToEdit, @NotNull Consumer<LoadingRequirementInstance> callback) {

        super((instanceToEdit != null) ? class_2561.method_43471("fancymenu.requirements.screens.edit_requirement") : class_2561.method_43471("fancymenu.requirements.screens.add_requirement"));

        this.parentScreen = parentScreen;
        this.parent = parent;
        this.instance = (instanceToEdit != null) ? instanceToEdit : new LoadingRequirementInstance(null, null, LoadingRequirementInstance.RequirementMode.IF, parent);
        this.isEdit = instanceToEdit != null;
        this.callback = callback;

    }

    @SuppressWarnings("all")
    @Override
    protected void method_25426() {

        String oldSearchValue = (this.searchBar != null) ? this.searchBar.method_1882() : "";
        this.searchBar = new ExtendedEditBox(class_310.method_1551().field_1772, 20 + 1, 50 + 15 + 1, (this.field_22789 / 2) - 40 - 2, 20 - 2, class_2561.method_43473());
        this.searchBar.setHintFancyMenu(consumes -> class_2561.method_43471("fancymenu.requirements.build_requirement.screen.search_requirement"));
        this.searchBar.method_1852(oldSearchValue);
        this.searchBar.method_1863(s -> this.updateRequirementsList());
        this.method_37063(this.searchBar);
        UIBase.applyDefaultWidgetSkinTo(this.searchBar);
        this.method_20085(this.searchBar);

        // Set positions for scroll areas
        this.requirementsListScrollArea.setWidth((this.field_22789 / 2) - 40, true);
        this.requirementsListScrollArea.setHeight(this.field_22790 - 85 - 25, true);
        this.requirementsListScrollArea.setX(20, true);
        this.requirementsListScrollArea.setY(50 + 15 + 25, true);
        this.method_37063(this.requirementsListScrollArea);

        this.descriptionScrollArea.setWidth((this.field_22789 / 2) - 40, true);
        this.descriptionScrollArea.setHeight(Math.max(40, (this.field_22790 / 2) - 50 - 25), true);
        this.descriptionScrollArea.setX(this.field_22789 - 20 - this.descriptionScrollArea.getWidthWithBorder(), true);
        this.descriptionScrollArea.setY(50 + 15, true);
        this.descriptionScrollArea.horizontalScrollBar.active = false;
        this.method_37063(this.descriptionScrollArea);

        // Calculate button positions
        int doneButtonX = this.field_22789 - 20 - 150; // 150 is button width
        int doneButtonY = this.field_22790 - 20 - 20;
        int cancelButtonX = doneButtonX;
        int cancelButtonY = doneButtonY - 5 - 20;
        int editValueButtonX = doneButtonX;
        int editValueButtonY = (this.isEdit ? doneButtonY : cancelButtonY) - 15 - 20;
        int requirementModeButtonX = doneButtonX;
        int requirementModeButtonY = editValueButtonY - 5 - 20;

        // Create buttons with positions in constructors
        ExtendedButton editValueButton = new ExtendedButton(editValueButtonX, editValueButtonY, 150, 20, class_2561.method_43471("fancymenu.requirements.screens.build_screen.edit_value"), (button) -> {
            if (this.instance.requirement != null) {
                this.instance.requirement.editValue(this, this.instance);
            }
        }).setTooltipSupplier(consumes -> {
            if ((this.instance.requirement != null) && !this.instance.requirement.hasValue()) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.requirements.screens.build_screen.edit_value.desc.no_value"));
            }
            return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.requirements.screens.build_screen.edit_value.desc.normal"));
        }).setIsActiveSupplier(consumes -> (this.instance.requirement != null) && this.instance.requirement.hasValue());
        this.method_37063(editValueButton);
        UIBase.applyDefaultWidgetSkinTo(editValueButton);

        ExtendedButton doneButton = new ExtendedButton(doneButtonX, doneButtonY, 150, 20, class_2561.method_43471("fancymenu.common_components.done"), (button) -> {
            class_310.method_1551().method_1507(this.parentScreen);
            this.callback.accept(this.instance);
        }).setTooltipSupplier(consumes -> {
            if (this.instance.requirement == null) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.requirements.screens.build_screen.finish.desc.no_requirement_selected"));
            } else if ((this.instance.value == null) && this.instance.requirement.hasValue()) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.requirements.screens.build_screen.finish.desc.no_value_set"));
            }
            return null;
        }).setIsActiveSupplier(consumes -> {
            if (this.instance.requirement == null) {
                return false;
            } else if ((this.instance.value == null) && this.instance.requirement.hasValue()) {
                return false;
            }
            return true;
        });
        this.method_37063(doneButton);
        UIBase.applyDefaultWidgetSkinTo(doneButton);

        ExtendedButton cancelButton = new ExtendedButton(cancelButtonX, cancelButtonY, 150, 20, class_2561.method_43471("fancymenu.common_components.cancel"), (button) -> {
            class_310.method_1551().method_1507(this.parentScreen);
            if (this.isEdit) {
                this.callback.accept(this.instance);
            } else {
                this.callback.accept(null);
            }
        }).setIsActiveSupplier(consumes -> !this.isEdit);
        cancelButton.field_22764 = !this.isEdit;
        this.method_37063(cancelButton);
        UIBase.applyDefaultWidgetSkinTo(cancelButton);

        ExtendedButton requirementModeButton = new ExtendedButton(requirementModeButtonX, requirementModeButtonY, 150, 20, class_2561.method_43473(), (button) -> {
            if (this.instance.mode == LoadingRequirementInstance.RequirementMode.IF) {
                this.instance.mode = LoadingRequirementInstance.RequirementMode.IF_NOT;
            } else {
                this.instance.mode = LoadingRequirementInstance.RequirementMode.IF;
            }
        }).setTooltipSupplier(consumes -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.requirements.screens.build_screen.requirement_mode.desc")))
                .setLabelSupplier(consumes -> {
                    if (this.instance.mode == LoadingRequirementInstance.RequirementMode.IF) {
                        return class_2561.method_43471("fancymenu.requirements.screens.build_screen.requirement_mode.normal");
                    }
                    return class_2561.method_43471("fancymenu.requirements.screens.build_screen.requirement_mode.opposite");
                });
        this.method_37063(requirementModeButton);
        UIBase.applyDefaultWidgetSkinTo(requirementModeButton);

        this.updateRequirementsList();
        this.setDescription(this.instance.requirement);

    }

    @Override
    public void method_25419() {
        class_310.method_1551().method_1507(this.parentScreen);
        if (this.isEdit) {
            this.callback.accept(this.instance);
        } else {
            this.callback.accept(null);
        }
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {

        graphics.fill(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());

        class_2561 titleComp = this.field_22785.method_27661().method_27696(class_2583.field_24360.method_10982(true));
        graphics.drawString(this.field_22793, titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);

        graphics.drawString(this.field_22793, class_2561.method_43471("fancymenu.requirements.screens.build_screen.available_requirements"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);

        class_2561 descLabel = class_2561.method_43471("fancymenu.requirements.screens.build_screen.requirement_description");
        int descLabelWidth = this.field_22793.method_27525(descLabel);
        graphics.drawString(this.field_22793, descLabel, this.field_22789 - 20 - descLabelWidth, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);

        super.render(graphics, mouseX, mouseY, partial);

    }

    @Override
    public void renderBackground(@NotNull GuiGraphics graphics) {
    }

    protected void setDescription(@Nullable LoadingRequirement requirement) {

        this.descriptionScrollArea.clearEntries();

        this.descriptionScrollArea.addEntry(new CellScreen.SpacerScrollAreaEntry(this.descriptionScrollArea, 5));

        if ((requirement != null) && (requirement.getDescription() != null)) {
            for (String s : requirement.getDescription()) {
                this.addDescriptionLine(class_2561.method_43470(s));
            }
        }

        this.descriptionScrollArea.addEntry(new CellScreen.SpacerScrollAreaEntry(this.descriptionScrollArea, 5));

    }

    protected void addDescriptionLine(@NotNull class_2561 line) {
        List<class_2561> lines = new ArrayList<>();
        int maxWidth = (int)(this.descriptionScrollArea.getInnerWidth() - 15F);
        if (this.field_22793.method_27525(line) > maxWidth) {
            this.field_22793.method_27527().method_27495(line, maxWidth, class_2583.field_24360).forEach(formatted -> {
                lines.add(TextFormattingUtils.convertFormattedTextToComponent(formatted));
            });
        } else {
            lines.add(line);
        }
        lines.forEach(component -> {
            TextScrollAreaEntry e = new TextScrollAreaEntry(this.descriptionScrollArea, component, (entry) -> {});
            e.setSelectable(false);
            e.setBackgroundColorHover(e.getBackgroundColorNormal());
            e.setPlayClickSound(false);
            e.setTextBaseColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt());
            this.descriptionScrollArea.addEntry(e);
        });
    }

    protected boolean requirementFitsSearchValue(@NotNull LoadingRequirement requirement, @Nullable String s) {
        if ((s == null) || s.isBlank()) return true;
        s = s.toLowerCase();
        if (requirement.getDisplayName().toLowerCase().contains(s)) return true;
        return this.requirementDescriptionContains(requirement, s);
    }

    protected boolean requirementDescriptionContains(@NotNull LoadingRequirement requirement, @NotNull String s) {
        List<String> desc = Objects.requireNonNullElse(requirement.getDescription(), new ArrayList<>());
        for (String line : desc) {
            if (line.toLowerCase().contains(s)) return true;
        }
        return false;
    }

    protected void setContentOfRequirementsList(@Nullable String category) {

        String searchValue = (this.searchBar != null) ? this.searchBar.method_1882() : "";
        if (searchValue.isBlank()) searchValue = null;

        this.requirementsListScrollArea.clearEntries();

        if (searchValue != null) {
            List<LoadingRequirement> requirements = LoadingRequirementRegistry.getRequirements();
            requirements.sort(REQUIREMENT_DISPLAY_NAME_COMPARATOR);
            for (LoadingRequirement r : requirements) {
                if ((LayoutEditorScreen.getCurrentInstance() != null) && !r.shouldShowUpInEditorRequirementMenu(LayoutEditorScreen.getCurrentInstance())) continue;
                if (!this.requirementFitsSearchValue(r, searchValue)) continue;
                class_2561 label = class_2561.method_43470(r.getDisplayName()).method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()));
                RequirementScrollEntry e = new RequirementScrollEntry(this.requirementsListScrollArea, label, UIBase.getUIColorTheme().listing_dot_color_1, (entry) -> {
                    this.instance.requirement = r;
                    this.setDescription(this.instance.requirement);
                });
                e.requirement = r;
                this.requirementsListScrollArea.addEntry(e);
            }
            return;
        }

        LinkedHashMap<String, List<LoadingRequirement>> categories = LoadingRequirementRegistry.getRequirementsOrderedByCategories();
        categories.values().forEach(list -> list.sort(REQUIREMENT_DISPLAY_NAME_COMPARATOR));
        List<Map.Entry<String, List<LoadingRequirement>>> sortedCategories = new ArrayList<>(categories.entrySet());
        sortedCategories.sort(Comparator
                .comparing((Map.Entry<String, List<LoadingRequirement>> entry) -> entry.getKey(), String.CASE_INSENSITIVE_ORDER)
                .thenComparing(Map.Entry::getKey));

        if (category == null) {

            //Add category entries
            for (Map.Entry<String, List<LoadingRequirement>> m : sortedCategories) {
                class_2561 label = class_2561.method_43470(m.getKey()).method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()));
                TextListScrollAreaEntry e = new TextListScrollAreaEntry(this.requirementsListScrollArea, label, UIBase.getUIColorTheme().listing_dot_color_2, (entry) -> {
                    BuildRequirementScreen.this.setContentOfRequirementsList(m.getKey());
                    BuildRequirementScreen.this.instance.requirement = null;
                    this.setDescription(null);
                });
                e.setSelectable(false);
                this.requirementsListScrollArea.addEntry(e);
            }

            //Add requirement entries without category
            List<LoadingRequirement> uncategorized = LoadingRequirementRegistry.getRequirementsWithoutCategory();
            uncategorized.sort(REQUIREMENT_DISPLAY_NAME_COMPARATOR);
            for (LoadingRequirement r : uncategorized) {
                if ((LayoutEditorScreen.getCurrentInstance() != null) && !r.shouldShowUpInEditorRequirementMenu(LayoutEditorScreen.getCurrentInstance())) continue;
                class_2561 label = class_2561.method_43470(r.getDisplayName()).method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()));
                RequirementScrollEntry e = new RequirementScrollEntry(this.requirementsListScrollArea, label, UIBase.getUIColorTheme().listing_dot_color_1, (entry) -> {
                    this.instance.requirement = r;
                    this.setDescription(this.instance.requirement);
                });
                e.requirement = r;
                this.requirementsListScrollArea.addEntry(e);
            }

        } else {

            //Add "Back" button
            class_2561 backLabel = class_2561.method_43471("fancymenu.requirements.screens.lists.back").method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
            TextListScrollAreaEntry backEntry = new TextListScrollAreaEntry(this.requirementsListScrollArea, backLabel, UIBase.getUIColorTheme().listing_dot_color_2, (entry) -> {
                BuildRequirementScreen.this.setContentOfRequirementsList(null);
                BuildRequirementScreen.this.instance.requirement = null;
                this.setDescription(null);
            });
            backEntry.setSelectable(false);
            this.requirementsListScrollArea.addEntry(backEntry);

            //Add requirement entries of given category
            List<LoadingRequirement> l = categories.get(category);
            if (l != null) {
                for (LoadingRequirement r : l) {
                    if ((LayoutEditorScreen.getCurrentInstance() != null) && !r.shouldShowUpInEditorRequirementMenu(LayoutEditorScreen.getCurrentInstance())) continue;
                    class_2561 label = class_2561.method_43470(r.getDisplayName()).method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()));
                    RequirementScrollEntry e = new RequirementScrollEntry(this.requirementsListScrollArea, label, UIBase.getUIColorTheme().listing_dot_color_1, (entry) -> {
                        this.instance.requirement = r;
                        this.setDescription(this.instance.requirement);
                    });
                    e.requirement = r;
                    this.requirementsListScrollArea.addEntry(e);
                }
            }

        }

    }

    protected void updateRequirementsList() {

        this.setContentOfRequirementsList(null);

        //Select correct entry if instance has requirement
        if (this.instance.requirement != null) {
            this.setContentOfRequirementsList(this.instance.requirement.getCategory());
            for (ScrollAreaEntry e : this.requirementsListScrollArea.getEntries()) {
                if ((e instanceof RequirementScrollEntry) && (((RequirementScrollEntry) e).requirement == this.instance.requirement)) {
                    e.setSelected(true);
                    break;
                }
            }
        }

    }

    public class RequirementScrollEntry extends TextListScrollAreaEntry {

        public LoadingRequirement requirement;
        protected long lastClickTime = 0;
        protected static final long DOUBLE_CLICK_TIME = 500; // milliseconds

        public RequirementScrollEntry(ScrollArea parent, @NotNull class_2561 text, @NotNull DrawableColor listDotColor, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, text, listDotColor, onClick);
        }

        @Override
        public void onClick(ScrollAreaEntry entry, double mouseX, double mouseY, int button) {
            long currentTime = System.currentTimeMillis();
            
            // Check if this is a double-click
            if (currentTime - this.lastClickTime < DOUBLE_CLICK_TIME) {
                // Double-click detected
                if ((this.requirement != null) && (BuildRequirementScreen.this.instance.requirement == this.requirement)) {
                    // Check if requirement has value or doesn't need value -> act as "Done"
                    if (this.requirement.hasValue()) {
                        BuildRequirementScreen.this.instance.requirement.editValue(BuildRequirementScreen.this, BuildRequirementScreen.this.instance);
                    } else {
                        class_310.method_1551().method_1507(BuildRequirementScreen.this.parentScreen);
                        BuildRequirementScreen.this.callback.accept(BuildRequirementScreen.this.instance);
                    }
                    this.lastClickTime = 0; // Reset to prevent triple clicks
                    return;
                }
            }
            
            this.lastClickTime = currentTime;
            
            // Normal single click behavior
            super.onClick(entry, mouseX, mouseY, button);
        }

    }

}
