package de.keksuccino.fancymenu.customization.overlay;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.LayoutHandler;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.slideshow.ExternalTextureSlideshowRenderer;
import de.keksuccino.fancymenu.customization.slideshow.SlideshowHandler;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinMinecraft;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.PerformanceUtils;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.menubar.v2.MenuBar;
import org.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4494;
import net.minecraft.class_5250;

public class DebugOverlayBuilder {

    @NotNull
    public static DebugOverlay buildDebugOverlay(@NotNull MenuBar menuBar) {

        DebugOverlay overlay = new DebugOverlay();

        overlay.setLineTextShadow(false);

        int menuBarHeight = (int)((float)menuBar.getHeight() * UIBase.calculateFixedScale(menuBar.getScale()));
        overlay.setTopYOffsetSupplier(() -> menuBarHeight + 10);
        overlay.setBottomYOffsetSupplier(() -> -10);

        class_437 current = class_310.method_1551().field_1755;
        if (current == null) return overlay;
        ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getLayerOfScreen(current);
        if (layer == null) return overlay;

        addScreenCategory(overlay, current, layer);

        addResourcesCategory(overlay);

        addSystemCategory(overlay);

        overlay.addLine("right_click_elements", DebugOverlay.LinePosition.TOP_LEFT, consumes -> Components.translatable("fancymenu.overlay.debug.right_click_elements"));

        return overlay;

    }

    private static void addScreenCategory(@NotNull DebugOverlay overlay, @NotNull class_437 currentScreen, @NotNull ScreenCustomizationLayer currentScreenLayer) {

        if (!FancyMenu.getOptions().debugOverlayShowBasicScreenCategory.getValue() && !FancyMenu.getOptions().debugOverlayShowAdvancedScreenCategory.getValue()) return;

        String currentIdentifier = ScreenIdentifierHandler.getIdentifierOfScreen(currentScreen);
        boolean customizationEnabled = ScreenCustomization.isCustomizationEnabledForScreen(currentScreen);
        List<Layout> allLayoutsCurrent = LayoutHandler.getAllLayoutsForScreenIdentifier(currentIdentifier, false);
        List<Layout> allUniversalLayoutsCurrent = LayoutHandler.getAllLayoutsForScreenIdentifier(Layout.UNIVERSAL_LAYOUT_IDENTIFIER, true);
        List<Layout> enabledUniversalLayoutsCurrent = new ArrayList<>();
        for (Layout l : currentScreenLayer.activeLayouts) {
            if (l.isUniversalLayout()) enabledUniversalLayoutsCurrent.add(l);
        }

        if (FancyMenu.getOptions().debugOverlayShowBasicScreenCategory.getValue()) {

            overlay.addLine("screen_identifier", DebugOverlay.LinePosition.TOP_LEFT,
                            consumes -> {
                                class_5250 c = Components.translatable("fancymenu.overlay.debug.screen_identifier", currentIdentifier);
                                if (consumes.isHovered()) c = c.method_10862(class_2583.field_24360.method_30938(true));
                                if (consumes.recentlyClicked()) c = Components.translatable("fancymenu.overlay.debug.screen_identifier.copied").method_10862(class_2583.field_24360.method_10977(class_124.field_1060));
                                return c;
                            })
                    .setClickAction(line -> class_310.method_1551().field_1774.method_1455(currentIdentifier));
            overlay.addLine("screen_size", DebugOverlay.LinePosition.TOP_LEFT, consumes -> Components.translatable("fancymenu.overlay.debug.screen_size", "" + class_310.method_1551().method_22683().method_4480(), "" + class_310.method_1551().method_22683().method_4507()));

        }

        if (FancyMenu.getOptions().debugOverlayShowAdvancedScreenCategory.getValue()) {

            overlay.addLine("active_layout_count", DebugOverlay.LinePosition.TOP_LEFT, consumes -> Components.translatable("fancymenu.overlay.debug.screen_active_layout_count", "" + (customizationEnabled ? currentScreenLayer.activeLayouts.size() : 0), "" + (customizationEnabled ? enabledUniversalLayoutsCurrent.size() : 0)));
            overlay.addLine("total_layout_count", DebugOverlay.LinePosition.TOP_LEFT, consumes -> Components.translatable("fancymenu.overlay.debug.screen_total_layout_count", "" + (allLayoutsCurrent.size() + allUniversalLayoutsCurrent.size()), "" + allUniversalLayoutsCurrent.size()));
            overlay.addLine("active_elements_count", DebugOverlay.LinePosition.TOP_LEFT, consumes -> Components.translatable("fancymenu.overlay.debug.screen_active_element_count", "" + (customizationEnabled ? currentScreenLayer.allElements.size() : 0)));

        }

        overlay.addSpacerLine("spacer_after_active_element_count", DebugOverlay.LinePosition.TOP_LEFT, 5);

    }

    private static void addResourcesCategory(@NotNull DebugOverlay overlay) {

        if (!FancyMenu.getOptions().debugOverlayShowResourcesCategory.getValue()) return;

        int slideshowCount = SlideshowHandler.getSlideshows().size();
        int totalSlideshowImages = 0;
        for (ExternalTextureSlideshowRenderer slide : SlideshowHandler.getSlideshows()) {
            totalSlideshowImages += slide.getImageCount();
        }
        final int finalTotalSlideshowImages = totalSlideshowImages;

        overlay.addLine("total_slideshows", DebugOverlay.LinePosition.TOP_LEFT, consumes -> class_2561.method_43469("fancymenu.overlay.debug.loaded_slideshows", "" + slideshowCount, "" + finalTotalSlideshowImages));

        overlay.addSpacerLine("spacer_after_total_slideshows", DebugOverlay.LinePosition.TOP_LEFT, 5);

    }

    private static void addSystemCategory(@NotNull DebugOverlay overlay) {

        if (!FancyMenu.getOptions().debugOverlayShowSystemCategory.getValue()) return;

        overlay.addLine("frames_per_second", DebugOverlay.LinePosition.TOP_LEFT, consumes -> {
            int fps = IMixinMinecraft.getFpsFancyMenu();
            class_5250 fpsComp = Components.literal("" + fps);
            if (fps < 20) fpsComp = fpsComp.method_10862(class_2583.field_24360.method_10977(class_124.field_1065));
            if (fps < 10) fpsComp = fpsComp.method_10862(class_2583.field_24360.method_10977(class_124.field_1061));
            return Components.translatable("fancymenu.overlay.debug.fps", fpsComp);
        });
        overlay.addLine("ram_usage", DebugOverlay.LinePosition.TOP_LEFT, consumes -> {
            long max = Runtime.getRuntime().maxMemory();
            long total = Runtime.getRuntime().totalMemory();
            long free = Runtime.getRuntime().freeMemory();
            long used = total - free;
            long percent = (total - free) * 100L / max;
            String ramString = bytesToMb(used) + "/" + bytesToMb(max) + "MB";
            String percentString = percent + "%";
            if (percent >= 60) percentString = class_124.field_1065 + "" + percent + "%" + class_124.field_1070;
            if (percent >= 80) percentString = class_124.field_1061 + "" + percent + "%" + class_124.field_1070;
            return Components.translatable("fancymenu.overlay.debug.memory", ramString, percentString);
        });
        overlay.addLine("cpu_jvm_usage", DebugOverlay.LinePosition.TOP_LEFT, consumes -> {
            double usage = PerformanceUtils.getJvmCpuUsage();
            if (usage < 0D) usage = 0D;
            usage = usage * 100.0D;
            usage = MathUtils.round(usage, 1);
            String usageString = usage + "%";
            if (usage > 50) usageString = class_124.field_1065 + "" + usage + "%" + class_124.field_1070;
            if (usage >= 80) usageString = class_124.field_1061 + "" + usage + "%" + class_124.field_1070;
            return class_2561.method_43469("fancymenu.overlay.debug.cpu_usage.jvm", usageString);
        });
        overlay.addLine("cpu_os_usage", DebugOverlay.LinePosition.TOP_LEFT, consumes -> {
            double usage = PerformanceUtils.getOsCpuUsage();
            if (usage < 0D) usage = 0D;
            usage = usage * 100.0D;
            usage = MathUtils.round(usage, 1);
            String usageString = usage + "%";
            if (usage > 50) usageString = class_124.field_1065 + "" + usage + "%" + class_124.field_1070;
            if (usage >= 80) usageString = class_124.field_1061 + "" + usage + "%" + class_124.field_1070;
            return class_2561.method_43469("fancymenu.overlay.debug.cpu_usage.os", usageString);
        });
        overlay.addLine("cpu_info", DebugOverlay.LinePosition.TOP_LEFT, consumes -> Components.translatable("fancymenu.overlay.debug.cpu", class_4494.method_22089()));
        overlay.addLine("gpu_info", DebugOverlay.LinePosition.TOP_LEFT, consumes -> Components.translatable("fancymenu.overlay.debug.gpu", class_4494.method_22090(), class_4494.method_22091()));

        overlay.addSpacerLine("spacer_after_gpu_info", DebugOverlay.LinePosition.TOP_LEFT, 5);

    }

    private static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

}
