package de.keksuccino.fancymenu.customization.placeholder.placeholders.advanced;

import com.mojang.brigadier.StringReader;
import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_2203;
import net.minecraft.class_2338;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.nbt.*;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.*;

public class NbtDataGetPlaceholder extends Placeholder {

    private static final Logger LOGGER = LogManager.getLogger();

    public NbtDataGetPlaceholder() {
        super("nbt_data_get");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {

        String sourceType = dps.values.get("source_type");
        String nbtPath = dps.values.get("nbt_path");
        String scaleStr = dps.values.get("scale");
        String returnType = dps.values.get("return_type");

        class_638 level = class_310.method_1551().field_1687;

        if (level == null) return "";

        if (sourceType == null || nbtPath == null) {
            return "";
        }

        // Default return type is "value"
        if (returnType == null || returnType.isEmpty()) {
            returnType = "value";
        }

        try {
            // Parse NBT path
            class_2203.class_2209 path = new class_2203().method_9362(new StringReader(nbtPath));
            
            // Get the source NBT data
            class_2487 sourceData = getSourceData(sourceType, dps);
            if (sourceData == null) {
                return "";
            }

            // Get the tag at the path
            List<class_2520> tags = path.method_9366(sourceData);
            if (tags.isEmpty()) {
                return "";
            }

            class_2520 tag = tags.get(0);
            
            // Return based on return type
            if ("string".equalsIgnoreCase(returnType)) {
                // Return the actual NBT data as string
                return tag.method_10714();
            } else if ("snbt".equalsIgnoreCase(returnType)) {
                // Return as SNBT (formatted NBT)
                return tag.toString();
            } else if ("json".equalsIgnoreCase(returnType) && tag instanceof class_2487) {
                // Return as JSON-formatted component
                String json = class_2561.class_2562.method_10867(class_2512.method_32270(tag));
                if (json.startsWith("\"") && json.endsWith("\"")) {
                    json = json.substring(1, json.length() - 1);
                }
                return json;
            } else {
                // Default: return value (like /data get command)
                double scale = 1.0;
                if (scaleStr != null && !scaleStr.isEmpty()) {
                    try {
                        scale = Double.parseDouble(scaleStr);
                    } catch (NumberFormatException e) {
                        // Invalid scale, use default
                    }
                }
                return getTagValue(tag, scale);
            }
            
        } catch (Exception e) {
            LOGGER.error("[FANCYMENU] Error in nbt_data_get placeholder: " + e.getMessage());
            return "";
        }

    }

    private class_2487 getSourceData(String sourceType, DeserializedPlaceholderString dps) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) return null;
        switch (sourceType.toLowerCase()) {
            case "entity":
                return getEntityData(dps);
            case "block":
                return getBlockData(dps);
            default:
                return null;
        }
    }

    private class_2487 getEntityData(DeserializedPlaceholderString dps) {
        String selector = dps.values.get("entity_selector");
        if (selector == null) return null;

        class_746 player = class_310.method_1551().field_1724;
        class_638 level = class_310.method_1551().field_1687;
        if (player == null || level == null) return null;

        // Handle common selectors
        class_1297 targetEntity = null;
        switch (selector) {
            case "@s":
            case "@p":
                targetEntity = player;
                break;
            case "@e":
                // Get nearest entity
                double nearestDist = Double.MAX_VALUE;
                for (class_1297 entity : level.method_18112()) {
                    double dist = entity.method_5858(player);
                    if (dist < nearestDist) {
                        nearestDist = dist;
                        targetEntity = entity;
                    }
                }
                break;
            default:
                // Try to find entity by UUID or name
                try {
                    UUID uuid = UUID.fromString(selector);
                    for (class_1297 entity : level.method_18112()) {
                        if (entity.method_5667().equals(uuid)) {
                            targetEntity = entity;
                            break;
                        }
                    }
                } catch (IllegalArgumentException e) {
                    // Not a UUID, try as player name
                    for (class_1297 entity : level.method_18112()) {
                        if (entity.method_5477().getString().equals(selector)) {
                            targetEntity = entity;
                            break;
                        }
                    }
                }
                break;
        }

        if (targetEntity == null) return null;

        // Get entity NBT data
        class_2487 tag = new class_2487();
        targetEntity.method_5647(tag);
        return tag;
    }

    private class_2487 getBlockData(DeserializedPlaceholderString dps) {
        String posStr = dps.values.get("block_pos");
        if (posStr == null) return null;

        class_638 level = class_310.method_1551().field_1687;
        if (level == null) return null;

        try {
            // Parse block position (format: "x y z")
            String[] parts = posStr.trim().split("\\s+");
            if (parts.length != 3) return null;

            int x = Integer.parseInt(parts[0]);
            int y = Integer.parseInt(parts[1]);
            int z = Integer.parseInt(parts[2]);

            class_2338 pos = new class_2338(x, y, z);
            class_2586 blockEntity = level.method_8321(pos);
            
            if (blockEntity != null) {
                return blockEntity.method_38244();
            }
        } catch (NumberFormatException e) {
            LOGGER.error("[FANCYMENU] Invalid block position: " + posStr);
        }

        return null;
    }

    private String getTagValue(class_2520 tag, double scale) {
        if (tag instanceof class_2514 numericTag) {
            // Numeric value with optional scaling
            if (scale != 1.0) {
                return String.valueOf(class_3532.method_15357(numericTag.method_10697() * scale));
            } else {
                return String.valueOf(class_3532.method_15357(numericTag.method_10697()));
            }
        } else if (tag instanceof class_2519) {
            // String length
            return String.valueOf(tag.method_10714().length());
        } else if (tag instanceof class_2483<?> collectionTag) {
            // Collection size
            return String.valueOf(collectionTag.size());
        } else if (tag instanceof class_2487 compoundTag) {
            // Compound size
            return String.valueOf(compoundTag.method_10546());
        } else {
            // For other types, return the string representation
            return tag.method_10714();
        }
    }

    @Override
    public @Nullable List<String> getValueNames() {
        return List.of("source_type", "entity_selector", "block_pos", "nbt_path", "scale", "return_type");
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.placeholders.nbt_data_get");
    }

    @Override
    public @Nullable List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.nbt_data_get.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.advanced");
    }

    @Override
    public @NotNull DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> values = new LinkedHashMap<>();
        values.put("source_type", "entity");
        values.put("entity_selector", "@s");
        values.put("block_pos", "");
        values.put("nbt_path", "foodLevel");
        values.put("scale", "1.0");
        values.put("return_type", "value");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }

}
