package de.keksuccino.fancymenu.customization.placeholder.placeholders.world;

import com.google.common.collect.Ordering;
import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.platform.Services;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.*;
import net.minecraft.class_1074;
import net.minecraft.class_1293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class ActiveEffectPlaceholder extends Placeholder {

    public ActiveEffectPlaceholder() {
        super("active_effect");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        class_746 player = class_310.method_1551().field_1724;
        class_638 level = class_310.method_1551().field_1687;
        int index = SerializationUtils.deserializeNumber(Integer.class, 0, dps.values.get("effect_index"));
        if ((player != null) && (level != null)) {
            List<class_1293> effects = Ordering.natural().reverse().sortedCopy(player.method_6026());
            if (effects.size() >= (index + 1)) {
                class_2960 key = Services.PLATFORM.getEffectKey(effects.get(index).method_5579());
                if (key != null) return key.toString();
            }
        }
        return "";
    }

    @Override
    public @Nullable List<String> getValueNames() {
        return List.of("effect_index");
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.placeholders.world.active_effect");
    }

    @Override
    public @Nullable List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.world.active_effect.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.placeholders.categories.world");
    }

    @Override
    public @NotNull DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> values = new LinkedHashMap<>();
        values.put("effect_index", "0");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }

}
