package de.keksuccino.fancymenu.customization.placeholder.placeholders.world;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinGui;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.rendering.text.TextFormattingUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.*;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class CurrentTitlePlaceholder extends Placeholder {

    public CurrentTitlePlaceholder() {
        super("current_title");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        class_746 player = class_310.method_1551().field_1724;
        class_638 level = class_310.method_1551().field_1687;
        boolean isSubtitle = SerializationUtils.deserializeBoolean(false, dps.values.get("is_subtitle"));
        boolean asJson = SerializationUtils.deserializeBoolean(false, dps.values.get("as_json"));
        if ((player != null) && (level != null)) {
            class_2561 component = isSubtitle ? ((IMixinGui)class_310.method_1551().field_1705).get_subtitle_FancyMenu() : ((IMixinGui)class_310.method_1551().field_1705).get_title_FancyMenu();
            if (component != null) {
                if (asJson) {
                    return class_2561.class_2562.method_10867(component);
                } else {
                    return TextFormattingUtils.convertComponentToString(component);
                }
            }
        }
        return "";
    }

    @Override
    public @Nullable List<String> getValueNames() {
        return List.of("is_subtitle", "as_json");
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.placeholders.world.current_title");
    }

    @Override
    public @Nullable List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.world.current_title.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.placeholders.categories.world");
    }

    @Override
    public @NotNull DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> values = new LinkedHashMap<>();
        values.put("is_subtitle", "false");
        values.put("as_json", "false");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }

}
