package de.keksuccino.fancymenu.customization.screen;

import java.lang.reflect.Constructor;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.class_1076;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3264;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3286;
import net.minecraft.class_3288;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_525;
import net.minecraft.class_5285;
import net.minecraft.class_5292;
import net.minecraft.class_5317;
import net.minecraft.class_5359;
import net.minecraft.class_5375;
import net.minecraft.class_5455;
import net.minecraft.class_632;
import net.minecraft.class_7193;
import net.minecraft.class_7237;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.screen.identifier.UniversalScreenIdentifierRegistry;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinCreateWorldScreen;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenInstanceFactory {
	
	private static final Map<Class<?>, Object> DEFAULT_PARAMETERS = new HashMap<>();
	private static final Map<String, Supplier<? extends class_437>> SCREEN_INSTANCE_PROVIDERS = new HashMap<>();

	static {

		DEFAULT_PARAMETERS.put(class_310.class, class_310.method_1551());
		DEFAULT_PARAMETERS.put(class_437.class, null);
		DEFAULT_PARAMETERS.put(class_315.class, class_310.method_1551().field_1690);
		DEFAULT_PARAMETERS.put(class_1076.class, class_310.method_1551().method_1526());
		DEFAULT_PARAMETERS.put(class_1657.class, null);
		DEFAULT_PARAMETERS.put(String.class, "");
		DEFAULT_PARAMETERS.put(class_632.class, null);
		DEFAULT_PARAMETERS.put(class_2561.class, Components.empty());
		DEFAULT_PARAMETERS.put(boolean.class, true);
		DEFAULT_PARAMETERS.put(int.class, 0);
		DEFAULT_PARAMETERS.put(long.class, 0L);
		DEFAULT_PARAMETERS.put(double.class, 0D);
		DEFAULT_PARAMETERS.put(float.class, 0F);
		DEFAULT_PARAMETERS.put(Boolean.class, true);
		DEFAULT_PARAMETERS.put(Integer.class, 0);
		DEFAULT_PARAMETERS.put(Long.class, 0L);
		DEFAULT_PARAMETERS.put(Double.class, 0D);
		DEFAULT_PARAMETERS.put(Float.class, 0F);

		ScreenInstanceFactory.registerScreenProvider(class_525.class.getName(),
				() -> {
					class_310 $$0 = class_310.method_1551();
					class_437 $$1 = class_310.method_1551().field_1755;
					class_3283 $$2 = new class_3283(class_3264.field_14190, new class_3285[]{new class_3286()});
					class_7237.class_6906 $$3 = IMixinCreateWorldScreen.invokeCreateDefaultLoadConfigFancyMenu($$2, class_5359.field_25393);
					CompletableFuture<class_7193> $$4 = class_7237.method_42098($$3, ($$0x, $$1x) -> {
						class_5455.class_6890 $$2x = class_5455.method_40314().method_40316();
						class_5285 $$3x = class_5317.method_41595($$2x);
						return Pair.of($$3x, $$2x);
					}, ($$0x, $$1x, $$2x, $$3x) -> {
						$$0x.close();
						return new class_7193($$3x, Lifecycle.stable(), $$2x, $$1x);
					}, class_156.method_18349(), $$0);
					Objects.requireNonNull($$4);
					$$0.method_18857($$4::isDone);
					return IMixinCreateWorldScreen.invokeConstructFancyMenu($$1, class_5359.field_25393, new class_5292((class_7193)$$4.join(), Optional.of(class_5317.field_25050), OptionalLong.empty()));
				});

		ScreenInstanceFactory.registerScreenProvider(class_5375.class.getName(),
				() -> new class_5375(
						(class_310.method_1551().field_1755 != null) ? class_310.method_1551().field_1755 : new class_442(),
						class_310.method_1551().method_1520(),
						repository -> {
							class_315 options = class_310.method_1551().field_1690;
							List<String> $$1 = ImmutableList.copyOf(options.field_1887);
							options.field_1887.clear();
							options.field_1846.clear();
							for(class_3288 $$2 : repository.method_14444()) {
								if (!$$2.method_14465()) {
									options.field_1887.add($$2.method_14463());
									if (!$$2.method_14460().method_14437()) {
										options.field_1846.add($$2.method_14463());
									}
								}
							}
							options.method_1640();
							List<String> $$3 = ImmutableList.copyOf(options.field_1887);
							if (!$$3.equals($$1)) {
								class_310.method_1551().method_1521();
							}
						},
						class_310.method_1551().method_1479(),
						class_2561.method_43471("resourcePack.title")
				));

	}

	public static void registerScreenProvider(@NotNull String screenClassPath, @NotNull Supplier<? extends class_437> provider) {
		SCREEN_INSTANCE_PROVIDERS.put(screenClassPath, provider);
	}

	@Nullable
	public static Supplier<? extends class_437> getScreenProvider(@NotNull String screenClassPath) {
		return SCREEN_INSTANCE_PROVIDERS.get(screenClassPath);
	}

	@Nullable
	public static class_437 tryConstruct(@NotNull String screenClassPathOrIdentifier) {
		try {
			//Convert universal identifiers to actual class paths
			if (UniversalScreenIdentifierRegistry.universalIdentifierExists(screenClassPathOrIdentifier)) {
				String nonUniversal = UniversalScreenIdentifierRegistry.getScreenForUniversalIdentifier(screenClassPathOrIdentifier);
				if (nonUniversal != null) screenClassPathOrIdentifier = nonUniversal;
			}
			//Fixing potentially invalid class paths
			screenClassPathOrIdentifier = ScreenIdentifierHandler.tryFixInvalidIdentifierWithNonUniversal(screenClassPathOrIdentifier);
			if (ScreenCustomization.isScreenBlacklisted(screenClassPathOrIdentifier)) {
				return null;
			}
			//Update last screen
			DEFAULT_PARAMETERS.put(class_437.class, class_310.method_1551().field_1755);
			//Update player
			DEFAULT_PARAMETERS.put(class_1657.class, class_310.method_1551().field_1724);
			if (class_310.method_1551().field_1724 != null) {
				DEFAULT_PARAMETERS.put(class_632.class, class_310.method_1551().field_1724.field_3944.method_2869());
			}
			//Check if a provider is registered for the screen and return from provider if one was found
			Supplier<? extends class_437> screenProvider = getScreenProvider(screenClassPathOrIdentifier);
			if (screenProvider != null) return screenProvider.get();
			//Try to construct and instance of the screen
			Class<?> screenClass = Class.forName(screenClassPathOrIdentifier, false, ScreenInstanceFactory.class.getClassLoader());
			if (class_437.class.isAssignableFrom(screenClass)) {
				Constructor<?>[] constructors = screenClass.getConstructors();
				if (constructors.length > 0) {
					Constructor<?> constructor = null;
					//Try to find constructor without parameters
					for (Constructor<?> c : constructors) {
						if (c.getParameterTypes().length == 0) {
							constructor = c;
							break;
						}
					}
					if (constructor == null) {
						//Try to find constructor with supported parameters
						for (Constructor<?> c : constructors) {
							if (allParametersSupported(c.getParameterTypes())) {
								constructor = c;
								break;
							}
						}
					}
					if (constructor != null) {
						Class<?>[] parameters = constructor.getParameterTypes();
						List<Object> parameterInstances = new ArrayList<>();
						for (Class<?> p : parameters) {
							parameterInstances.add(DEFAULT_PARAMETERS.get(p));
						}
						return createInstance(constructor, parameterInstances);
					}
					return null;
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		return null;
	}

	private static boolean allParametersSupported(Class<?>[] parameters) {
		for (Class<?> par : parameters) {
			if (!DEFAULT_PARAMETERS.containsKey(par)) {
				return false;
			}
		}
		return true;
	}

	@Nullable
	private static class_437 createInstance(@NotNull Constructor<?> constructor, @Nullable List<Object> parameters) {
		try {
			if ((parameters == null) || parameters.isEmpty()) {
				return (class_437) constructor.newInstance();
			} else {
				return (class_437) constructor.newInstance(parameters.toArray(new Object[0]));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

}
