package de.keksuccino.fancymenu.customization.screen.dummyscreen;

import de.keksuccino.fancymenu.customization.screen.ScreenInstanceFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public class DummyScreenBuilder {

    @NotNull
    protected String screenIdentifier;
    @NotNull
    protected class_2561 screenDisplayName;
    @Nullable
    protected Supplier<List<class_2561>> screenDescription;
    @Nullable
    protected Supplier<? extends class_437> screenProvider;

    public DummyScreenBuilder(@NotNull String screenIdentifier, @NotNull class_2561 screenDisplayName, @Nullable Supplier<? extends class_437> screenProvider) {
        this.screenIdentifier = Objects.requireNonNull(screenIdentifier);
        this.screenDisplayName = Objects.requireNonNull(screenDisplayName);
        this.screenProvider = screenProvider;
    }

    @Nullable
    public class_437 tryConstruct() {
        if (this.screenProvider != null) return this.screenProvider.get();
        return ScreenInstanceFactory.tryConstruct(this.screenIdentifier);
    }

    @NotNull
    public String getScreenIdentifier() {
        return this.screenIdentifier;
    }

    @Nullable
    public Supplier<? extends class_437> getScreenProvider() {
        return this.screenProvider;
    }

    @NotNull
    public class_2561 getScreenDisplayName() {
        return this.screenDisplayName;
    }

    public DummyScreenBuilder setScreenDescriptionSupplier(@Nullable Supplier<List<class_2561>> description) {
        this.screenDescription = description;
        return this;
    }

    @Nullable
    public Supplier<List<class_2561>> getScreenDescriptionSupplier() {
        return this.screenDescription;
    }

}
