package de.keksuccino.fancymenu.customization.variables;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.cycle.LocalizedEnumValueCycle;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.ModernScreen;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.InitialWidgetFocusScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.TextInputScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;

public class ManageVariablesScreen extends ModernScreen implements InitialWidgetFocusScreen {

    protected Consumer<List<Variable>> callback;

    protected ScrollArea variableListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedEditBox searchBar;

    public ManageVariablesScreen(@NotNull Consumer<List<Variable>> callback) {
        super(class_2561.method_43471("fancymenu.overlay.menu_bar.variables.manage"));
        this.callback = callback;
    }

    @Override
    protected void method_25426() {

        String oldSearchValue = (this.searchBar != null) ? this.searchBar.method_1882() : "";
        this.searchBar = new ExtendedEditBox(class_310.method_1551().field_1772, 20 + 1, 50 + 15 + 1, (this.field_22789 / 2) - 40 - 2, 20 - 2, class_2561.method_43473());
        this.searchBar.setHintFancyMenu(consumes -> class_2561.method_43471("fancymenu.variables.manage_variables.screen.search_variable"));
        this.searchBar.method_1852(oldSearchValue);
        this.searchBar.method_1863(s -> this.updateVariablesList());
        this.method_37063(this.searchBar);
        UIBase.applyDefaultWidgetSkinTo(this.searchBar);
        this.setupInitialFocusWidget(this, this.searchBar);

        // Set positions for scroll area
        this.variableListScrollArea.setWidth((this.field_22789 / 2) - 40, true);
        this.variableListScrollArea.setHeight(this.field_22790 - 85 - 25, true);
        this.variableListScrollArea.setX(20, true);
        this.variableListScrollArea.setY(50 + 15 + 25, true);

        // Calculate button width
        int buttonWidth = (this.field_22789 - 20) - ((this.variableListScrollArea.getXWithBorder() + (this.variableListScrollArea.getWidthWithBorder() + 20)));
        if (buttonWidth < 150) buttonWidth = 150;
        if (buttonWidth > 220) buttonWidth = 220;

        // Calculate button positions
        int doneButtonX = this.field_22789 - 20 - buttonWidth;
        int doneButtonY = this.field_22790 - 20 - 20;
        int toggleResetButtonX = doneButtonX;
        int toggleResetButtonY = doneButtonY - 15 - 20;
        int deleteButtonX = doneButtonX;
        int deleteButtonY = toggleResetButtonY - 5 - 20;
        int setValueButtonX = doneButtonX;
        int setValueButtonY = deleteButtonY - 5 - 20;
        int addButtonX = doneButtonX;
        int addButtonY = setValueButtonY - 15 - 20;

        // Create buttons with positions in constructors
        ExtendedButton addVariableButton = new ExtendedButton(addButtonX, addButtonY, buttonWidth, 20, class_2561.method_43471("fancymenu.overlay.menu_bar.variables.manage.add_variable"), (button) -> {
            TextInputScreen s = new TextInputScreen(class_2561.method_43471("fancymenu.overlay.menu_bar.variables.manage.add_variable.input_name"), CharacterFilter.buildOnlyLowercaseFileNameFilter(), (call) -> {
                if (call != null) {
                    if (!VariableHandler.variableExists(call)) {
                        VariableHandler.setVariable(call, "");
                        updateVariablesList();
                    }
                }
                class_310.method_1551().method_1507(this);
            });
            class_310.method_1551().method_1507(s);
        });
        this.method_37063(addVariableButton);
        UIBase.applyDefaultWidgetSkinTo(addVariableButton);

        ExtendedButton setValueButton = new ExtendedButton(setValueButtonX, setValueButtonY, buttonWidth, 20, class_2561.method_43471("fancymenu.overlay.menu_bar.variables.manage.set_value"), (button) -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                TextInputScreen s = new TextInputScreen(class_2561.method_43471("fancymenu.overlay.menu_bar.variables.manage.set_value"), null, (call) -> {
                    if (call != null) {
                        e.variable.setValue(call);
                    }
                    class_310.method_1551().method_1507(this);
                });
                s.setText(e.variable.getValue());
                class_310.method_1551().method_1507(s);
            }
        }).setIsActiveSupplier(consumes -> (this.getSelectedEntry() != null));
        this.method_37063(setValueButton);
        UIBase.applyDefaultWidgetSkinTo(setValueButton);

        ExtendedButton deleteVariableButton = new ExtendedButton(deleteButtonX, deleteButtonY, buttonWidth, 20, class_2561.method_43471("fancymenu.overlay.menu_bar.variables.manage.delete_variable"), (button) -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                class_310.method_1551().method_1507(ConfirmationScreen.ofStrings(call -> {
                    if (call) {
                        VariableHandler.removeVariable(e.variable.getName());
                        this.updateVariablesList();
                    }
                    class_310.method_1551().method_1507(this);
                }, LocalizationUtils.splitLocalizedStringLines("fancymenu.overlay.menu_bar.variables.manage.delete_variable.confirm")));
            }
        }).setIsActiveSupplier(consumes -> (this.getSelectedEntry() != null));
        this.method_37063(deleteVariableButton);
        UIBase.applyDefaultWidgetSkinTo(deleteVariableButton);

        LocalizedEnumValueCycle<CommonCycles.CycleEnabledDisabled> resetOnLaunchDisabled = CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.variables.manage.clear_on_launch", false);
        ExtendedButton toggleResetOnLaunchButton = new ExtendedButton(toggleResetButtonX, toggleResetButtonY, buttonWidth, 20, class_2561.method_43473(), (button) -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                e.variable.setResetOnLaunch(!e.variable.isResetOnLaunch());
            }
        }).setIsActiveSupplier(consumes -> (this.getSelectedEntry() != null))
                .setLabelSupplier(consumes -> {
                    VariableScrollEntry e = this.getSelectedEntry();
                    if (e != null) {
                        LocalizedEnumValueCycle<CommonCycles.CycleEnabledDisabled> enabledDisabled = CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.variables.manage.clear_on_launch");
                        enabledDisabled.setCurrentValue(CommonCycles.CycleEnabledDisabled.getByBoolean(e.variable.isResetOnLaunch()));
                        return enabledDisabled.getCycleComponent();
                    }
                    return resetOnLaunchDisabled.getCycleComponent();
                });
        this.method_37063(toggleResetOnLaunchButton);
        UIBase.applyDefaultWidgetSkinTo(toggleResetOnLaunchButton);

        ExtendedButton doneButton = new ExtendedButton(doneButtonX, doneButtonY, buttonWidth, 20, class_2561.method_43471("fancymenu.common_components.done"), (button) -> {
            this.callback.accept(VariableHandler.getVariables());
        });
        this.method_37063(doneButton);
        UIBase.applyDefaultWidgetSkinTo(doneButton);

        this.updateVariablesList();

    }

    @Override
    public void method_25419() {
        this.callback.accept(VariableHandler.getVariables());
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {

        this.performInitialWidgetFocusActionInRender();

        RenderSystem.enableBlend();

        graphics.fill(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());

        class_2561 titleComp = this.field_22785.method_27661().method_27696(class_2583.field_24360.method_10982(true));
        graphics.drawString(this.field_22793, titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);

        graphics.drawString(this.field_22793, class_2561.method_43471("fancymenu.overlay.menu_bar.variables.manage.variables"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);

        this.variableListScrollArea.render(graphics, mouseX, mouseY, partial);

        super.render(graphics, mouseX, mouseY, partial);

    }

    @Nullable
    protected ManageVariablesScreen.VariableScrollEntry getSelectedEntry() {
        for (ScrollAreaEntry e : this.variableListScrollArea.getEntries()) {
            if (e instanceof VariableScrollEntry s) {
                if (s.isSelected()) return s;
            }
        }
        return null;
    }

    protected boolean variableFitsSearchValue(@NotNull Variable variable, @Nullable String s) {
        if ((s == null) || s.isBlank()) return true;
        s = s.toLowerCase();
        if (variable.getName().toLowerCase().contains(s)) return true;
        return variable.getValue().toLowerCase().contains(s);
    }

    protected void updateVariablesList() {

        String searchValue = (this.searchBar != null) ? this.searchBar.method_1882() : "";
        if (searchValue.isBlank()) searchValue = null;

        this.variableListScrollArea.clearEntries();

        List<Variable> variables = VariableHandler.getVariables();
        variables.sort(Comparator
                .comparing(Variable::getName, String.CASE_INSENSITIVE_ORDER)
                .thenComparing(Variable::getName));

        for (Variable v : variables) {
            if (!this.variableFitsSearchValue(v, searchValue)) continue;
            VariableScrollEntry e = new VariableScrollEntry(this.variableListScrollArea, v, (entry) -> {
            });
            this.variableListScrollArea.addEntry(e);
        }
        if (this.variableListScrollArea.getEntries().isEmpty()) {
            this.variableListScrollArea.addEntry(new TextScrollAreaEntry(this.variableListScrollArea, class_2561.method_43471("fancymenu.overlay.menu_bar.variables.manage.no_variables").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().error_text_color.getColorInt())), (entry) -> {}));
        }

    }

    public static class VariableScrollEntry extends TextListScrollAreaEntry {

        public Variable variable;

        public VariableScrollEntry(ScrollArea parent, @NotNull Variable variable, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, class_2561.method_43470(variable.name).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt())).method_10852(class_2561.method_43470(" (" + variable.getValue() + ")").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt()))), UIBase.getUIColorTheme().listing_dot_color_1.getColor(), onClick);
            this.variable = variable;
        }

    }

}
