package de.keksuccino.fancymenu.customization.widget;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.screen.identifier.UniversalScreenIdentifierRegistry;
import de.keksuccino.fancymenu.customization.screen.ScreenInstanceFactory;
import de.keksuccino.fancymenu.customization.widget.identification.WidgetIdentifierHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.*;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_437;

public class WidgetLocatorHandler {

    private static final Logger LOGGER = LogManager.getLogger();

    protected static final Map<String, ScreenWidgetCollection> CACHED_WIDGETS = new HashMap<>();

    protected static void tryCache(@NotNull String screenIdentifier, boolean overrideCache) {
        class_437 instance = ScreenInstanceFactory.tryConstruct(screenIdentifier);
        if (instance != null) {
            instance.method_25423(class_310.method_1551(), 1000, 1000);
            tryCache(instance, overrideCache);
        } else {
            LOGGER.error("[FANCYMENU] WidgetLocatorHandler failed to construct instance of '" + screenIdentifier + "'! Unable to cache widgets!");
        }
    }

    protected static void tryCache(@NotNull class_437 screen, boolean overrideCache) {
        if (ScreenCustomization.isScreenBlacklisted(screen)) return;
        String screenIdentifier = ScreenIdentifierHandler.getIdentifierOfScreen(screen);
        if (UniversalScreenIdentifierRegistry.universalIdentifierExists(screenIdentifier)) {
            screenIdentifier = Objects.requireNonNull(UniversalScreenIdentifierRegistry.getScreenForUniversalIdentifier(screenIdentifier));
        }
        if (!CACHED_WIDGETS.containsKey(screenIdentifier) || overrideCache) {
            class_437 current = class_310.method_1551().field_1755;
            if (current == screen) {
                if (!ScreenCustomization.isCustomizationEnabledForScreen(current)) return;
                ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getLayerOfScreen(current);
                if (layer != null) {
                    ScreenWidgetCollection collection = new ScreenWidgetCollection();
                    collection.setWidgets(layer.cachedScreenWidgetMetas);
                    CACHED_WIDGETS.put(screenIdentifier, collection);
                } else {
                    LOGGER.error("[FANCYMENU] WidgetLocatorHandler failed to cache widgets of current screen '" + screenIdentifier + "'! Customization layer was NULL!");
                }
            } else {
                ScreenWidgetCollection collection = new ScreenWidgetCollection();
                collection.setWidgets(ScreenWidgetDiscoverer.getWidgetsOfScreen(screen));
                CACHED_WIDGETS.put(screenIdentifier, collection);
            }
        }
    }

    @Nullable
    public static WidgetMeta getWidget(@NotNull String widgetLocator) {
        if (widgetLocator.contains(":")) {
            String screenIdentifier = widgetLocator.split(":", 2)[0];
            if (UniversalScreenIdentifierRegistry.universalIdentifierExists(screenIdentifier)) {
                screenIdentifier = Objects.requireNonNull(UniversalScreenIdentifierRegistry.getScreenForUniversalIdentifier(screenIdentifier));
            }
            screenIdentifier = ScreenIdentifierHandler.tryFixInvalidIdentifierWithNonUniversal(screenIdentifier);
            String widgetIdentifier = widgetLocator.split(":", 2)[1];
            class_437 current = class_310.method_1551().field_1755;
            //Check if the button locator is pointing to a button in the current screen
            if ((current != null) && ScreenIdentifierHandler.isIdentifierOfScreen(screenIdentifier, current)) {
                if (ScreenCustomization.isCustomizationEnabledForScreen(current)) {
                    ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getLayerOfScreen(current);
                    if (layer != null) {
                        if (!CACHED_WIDGETS.containsKey(screenIdentifier)) tryCache(current, false);
                        for (WidgetMeta meta : layer.cachedScreenWidgetMetas) {
                            if (WidgetIdentifierHandler.isIdentifierOfWidget(widgetIdentifier, meta)) return meta;
                        }
                    }
                }
            } else if (!CACHED_WIDGETS.containsKey(screenIdentifier)) {
                tryCache(screenIdentifier, false);
            }
            ScreenWidgetCollection collection = CACHED_WIDGETS.get(screenIdentifier);
            if (collection != null) {
                return collection.getWidget(widgetIdentifier);
            }
        }
        return null;
    }

    public static boolean invokeWidgetOnClick(@NotNull String widgetLocator) {
        WidgetMeta meta = getWidget(widgetLocator);
        if (meta != null) {
            return invokeWidgetOnClick(meta);
        }
        return false;
    }

    public static boolean invokeWidgetOnClick(@NotNull WidgetMeta meta) {
        try {
            class_339 w = meta.getWidget();
            w.method_25348(w.field_22760 + 1, w.field_22761 + 1);
            return true;
        } catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to invoke widget's onClick() method!", ex);
        }
        LOGGER.error("[FANCYMENU] WidgetLocatorHandler failed to invoke widget onClick!");
        return false;
    }

    public static void clearCache() {
        CACHED_WIDGETS.clear();
    }

    protected static class ScreenWidgetCollection {

        @NotNull
        protected List<WidgetMeta> widgets = new ArrayList<>();

        protected void setWidgets(@NotNull List<WidgetMeta> metas) {
            this.widgets = metas;
        }

        @NotNull
        protected List<WidgetMeta> getWidgets() {
            return this.widgets;
        }

        @Nullable
        protected WidgetMeta getWidget(@NotNull String widgetIdentifier) {
            for (WidgetMeta meta : this.widgets) {
                if (WidgetIdentifierHandler.isIdentifierOfWidget(widgetIdentifier, meta)) return meta;
            }
            return null;
        }

    }

}
