package de.keksuccino.fancymenu.events.screen;

import de.keksuccino.fancymenu.util.event.acara.EventBase;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Gets fired before a {@link class_437} gets closed by setting a new {@link class_437} (or no screen) via {@link class_310#method_1507(class_437)}.<br>
 * The new {@link class_437} is not opened yet when this event gets fired.
 */
public class CloseScreenEvent extends EventBase {

    private final class_437 closedScreen;
    private final class_437 newScreen;

    public CloseScreenEvent(@NotNull class_437 closedScreen, @Nullable class_437 newScreen) {
        this.closedScreen = closedScreen;
        this.newScreen = newScreen;
    }

    @Deprecated
    public class_437 getScreen() {
        return this.closedScreen;
    }

    @NotNull
    public class_437 getClosedScreen() {
        return this.closedScreen;
    }

    @Nullable
    public class_437 getNewScreen() {
        return this.newScreen;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

}
