package de.keksuccino.fancymenu.mixin.mixins.common.client;

import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.FancyMenuWidget;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;

@Mixin(class_465.class)
public class MixinAbstractContainerScreen extends class_437 {

    @Unique private static final List<class_364> CLICKED_WIDGETS_FANCYMENU = new ArrayList<>();

    // Dummy constructor
    private MixinAbstractContainerScreen() {
        super(class_2561.method_43473());
    }

    /**
     * @reason This is to make widgets work correctly in Inventory Container screens.
     */
    @Inject(method = "mouseClicked", at = @At("HEAD"), cancellable = true)
    private void head_mouseClicked_FancyMenu(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> info) {

        for (class_364 l : this.method_25396()) {
            if ((l instanceof FancyMenuWidget) && this.canClickWidget_FancyMenu(l)) {
                CLICKED_WIDGETS_FANCYMENU.add(l);
                if (l.method_25402(mouseX, mouseY, button)) {
                    info.setReturnValue(true);
                    break;
                }
            }
        }

    }

    /**
     * @reason This is to make widgets work correctly in Inventory Container screens.
     */
    @Inject(method = "mouseReleased", at = @At("HEAD"), cancellable = true)
    private void head_mouseReleased_FancyMenu(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> info) {

        for (class_364 l : this.method_25396()) {
            if ((l instanceof FancyMenuWidget) && CLICKED_WIDGETS_FANCYMENU.contains(l)) {
                if (l.method_25406(mouseX, mouseY, button)) {
                    info.setReturnValue(true);
                    break;
                }
            }
        }

        CLICKED_WIDGETS_FANCYMENU.clear();

    }

    /**
     * @reason This is to make widgets work correctly in Inventory Container screens.
     */
    @Inject(method = "mouseDragged", at = @At("HEAD"), cancellable = true)
    private void head_mouseDragged_FancyMenu(double mouseX, double mouseY, int button, double dragX, double dragY, CallbackInfoReturnable<Boolean> info) {

        for (class_364 l : this.method_25396()) {
            if ((l instanceof FancyMenuWidget) && CLICKED_WIDGETS_FANCYMENU.contains(l)) {
                if (l.method_25403(mouseX, mouseY, button, dragX, dragY)) {
                    info.setReturnValue(true);
                    break;
                }
            }
        }

    }

    @Unique
    private boolean canClickWidget_FancyMenu(@NotNull class_364 listener) {
        if (listener instanceof class_339 w) {
            return (((IMixinAbstractWidget)w).getIsHoveredFancyMenu() && w.method_37303() && w.field_22764);
        }
        return false;
    }

}
