package de.keksuccino.fancymenu.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.WrapWithCondition;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.screen.WidgetifiedScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.RendererWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.TextWidget;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_3928;
import net.minecraft.class_3953;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@WidgetifiedScreen
@Mixin(class_3928.class)
public abstract class MixinLevelLoadingScreen extends class_437 {

    @Shadow @Final private class_3953 progressListener;

    @Unique private TextWidget percentageTextFancyMenu;
    @Unique private RendererWidget chunkRendererFancyMenu;

    protected MixinLevelLoadingScreen(class_2561 component) {
        super(component);
    }

    @Override
    protected void method_25426() {

        if (this.isCustomizableFancyMenu()) {

            this.chunkRendererFancyMenu = this.method_37063(new RendererWidget((this.field_22789 / 2) - 50, (this.field_22790 / 2) + 30 - 50, 100, 100,
                    (graphics, mouseX, mouseY, partial, x, y, width1, height1, renderer) -> {
                        this.renderChunkBoxFancyMenu(graphics.pose(), x + 50, y + 50, this.progressListener);
                    }
            )).setWidgetIdentifierFancyMenu("chunks");

            this.percentageTextFancyMenu = this.method_37063(TextWidget.of(Components.literal("0%"), 0, (this.field_22790 / 2) - 30 - (9 / 2), 200))
                    .setTextAlignment(TextWidget.TextAlignment.CENTER)
                    .centerWidget(this)
                    .setWidgetIdentifierFancyMenu("percentage");

        } else {
            this.chunkRendererFancyMenu = null;
            this.percentageTextFancyMenu = null;
        }

    }

    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/LevelLoadingScreen;renderChunks(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/server/level/progress/StoringChunkProgressListener;IIII)V"))
    private boolean wrapRenderChunksFancyMenu(class_4587 $$0, class_3953 $$1, int $$2, int $$3, int $$4, int $$5) {
        return !this.isCustomizableFancyMenu();
    }

    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/LevelLoadingScreen;drawCenteredString(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/gui/Font;Ljava/lang/String;III)V"))
    private boolean wrapRenderPercentStringFancyMenu(class_4587 instance, class_327 $$0, String $$1, int $$2, int $$3, int $$4) {
        return !this.isCustomizableFancyMenu();
    }

    @Inject(method = "render", at = @At("RETURN"))
    private void afterRenderFancyMenu(class_4587 graphics, int mouseX, int mouseY, float partial, CallbackInfo info) {
        if (this.isCustomizableFancyMenu()) {
            if (this.chunkRendererFancyMenu != null) this.chunkRendererFancyMenu.method_25394(graphics, mouseX, mouseY, partial);
            if (this.percentageTextFancyMenu != null) {
                this.percentageTextFancyMenu.method_25355(Components.literal(this.getFormattedProgress()));
                this.percentageTextFancyMenu.method_25394(graphics, mouseX, mouseY, partial);
            }
        }
    }

    @Unique
    private void renderChunkBoxFancyMenu(@NotNull class_4587 graphics, int xCenter, int yCenter, class_3953 listener) {
        class_3928.method_17538(graphics, listener, xCenter, yCenter, 2, 0);
    }

    @Unique
    private boolean isCustomizableFancyMenu() {
        return ScreenCustomization.isCustomizationEnabledForScreen(this);
    }

    @Shadow protected abstract String getFormattedProgress();

}
