package de.keksuccino.fancymenu.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiBaseScreen;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.mixin.MixinCacheCommon;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.events.screen.RenderedScreenBackgroundEvent;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CustomizableScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_4587;
import net.minecraft.class_5684;

@Mixin(class_437.class)
public abstract class MixinScreen implements CustomizableScreen, class_4069 {

    @Unique private static final Logger LOGGER_FANCYMENU = LogManager.getLogger();

    @Unique private final List<class_364> removeOnInitChildrenFancyMenu = new ArrayList<>();
    @Unique private boolean initialized_FancyMenu = false;
    @Unique private boolean nextFocusPath_called_FancyMenu = false;

    @Shadow @Final private List<class_364> children;

    @Inject(method = "init(Lnet/minecraft/client/Minecraft;II)V", at = @At("RETURN"))
    private void return_init_FancyMenu(class_310 minecraft, int width, int height, CallbackInfo info) {
        this.initialized_FancyMenu = true;
    }

    @Inject(method = "renderTooltipInternal", at = @At("HEAD"), cancellable = true)
    private void head_renderTooltipInternal_FancyMenu(class_4587 pose, List<class_5684> clientTooltipComponents, int mouseX, int mouseY, CallbackInfo info) {
        if (RenderingUtils.isTooltipRenderingBlocked()) info.cancel();
    }

    @WrapOperation(method = "renderBackground(Lcom/mojang/blaze3d/vertex/PoseStack;I)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/Screen;fillGradient(Lcom/mojang/blaze3d/vertex/PoseStack;IIIIII)V"))
    private void wrap_fillGradient_in_renderBackground_FancyMenu(class_437 instance, class_4587 pose, int i1, int i2, int i3, int i4, int i5, int i6, Operation<Void> original) {
        this.renderBackgroundWrappedInEvent_FancyMenu(() -> original.call(instance, pose, i1, i2, i3, i4, i5, i6));
    }

    @WrapMethod(method = "renderDirtBackground")
    private void wrap_renderDirtBackground_FancyMenu(int vOffset, Operation<Void> original) {
        this.renderBackgroundWrappedInEvent_FancyMenu(() -> original.call(vOffset));
    }

    @Unique
    private void renderBackgroundWrappedInEvent_FancyMenu(@NotNull Runnable original) {
        class_437 instance = ((class_437)(Object)this);
        GuiGraphics graphics = GuiGraphics.currentGraphics();
        int mouseX = MixinCacheCommon.cached_screen_render_mouseX;
        int mouseY = MixinCacheCommon.cached_screen_render_mouseY;
        float partial = MixinCacheCommon.cached_screen_render_partial;
        //Don't fire the event in the TitleScreen or in Custom GUIs, because it gets handled differently there
        if ((instance instanceof class_442) || (instance instanceof CustomGuiBaseScreen)) {
            original.run();
            return;
        }
        ScreenCustomizationLayer l = ScreenCustomizationLayerHandler.getLayerOfScreen(instance);
        if ((l != null) && ScreenCustomization.isCustomizationEnabledForScreen(instance)) {
            if (!l.layoutBase.menuBackgrounds.isEmpty()) {
                RenderSystem.enableBlend();
                //Render a black background before the custom background gets rendered
                graphics.fill(0, 0, instance.field_22789, instance.field_22790, 0);
                RenderingUtils.resetShaderColor(graphics);
            } else {
                original.run();
            }
        } else {
            original.run();
        }
        EventHandler.INSTANCE.postEvent(new RenderedScreenBackgroundEvent(instance, graphics, mouseX, mouseY, partial));
    }

    @WrapOperation(method = "keyPressed", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/Screen;changeFocus(Z)Z"))
    private boolean wrap_changeFocus_in_keyPressed_FancyMenu(class_437 instance, boolean focus, Operation<Boolean> original) {
        this.nextFocusPath_called_FancyMenu = true;
        boolean b = original.call(instance, focus);
        this.nextFocusPath_called_FancyMenu = false;
        return b;
    }

    @Override
    public void method_20085(@Nullable class_364 eventListener) {
        this.nextFocusPath_called_FancyMenu = true;
        this.method_25395(eventListener);
        if (eventListener != null) {
            eventListener.method_25407(true);
        }
        this.nextFocusPath_called_FancyMenu = false;
    }

    @Override
    public boolean method_25407(boolean forward) {
        this.nextFocusPath_called_FancyMenu = true;
        class_364 current = this.method_25399();
        boolean hadFocused = current != null;

        if (hadFocused && current.method_25407(forward)) {
            this.nextFocusPath_called_FancyMenu = false;
            return true;
        }

        List<? extends class_364> list = this.method_25396();
        int start = hadFocused ? list.indexOf(current) + (forward ? 1 : 0) : (forward ? 0 : list.size());
        ListIterator<? extends class_364> it = list.listIterator(start);
        BooleanSupplier hasNext = forward ? it::hasNext : it::hasPrevious;
        Supplier<? extends class_364> next = forward ? it::next : it::previous;

        while (hasNext.getAsBoolean()) {
            class_364 candidate = next.get();
            if (candidate.method_25407(forward)) {
                this.method_25395(candidate);
                this.nextFocusPath_called_FancyMenu = false;
                return true;
            }
        }

        this.method_25395(null);
        this.nextFocusPath_called_FancyMenu = false;
        return false;
    }

    @Inject(method = "children", at = @At("RETURN"), cancellable = true)
    private void atReturnChildrenFancyMenu(CallbackInfoReturnable<List<? extends class_364>> info) {
        if (this.nextFocusPath_called_FancyMenu) {
            List<class_364> filtered = new ArrayList<>(this.children);
            filtered.removeIf(guiEventListener -> (guiEventListener instanceof NavigatableWidget n) && (!n.isFocusable() || !n.isNavigatable()));
            info.setReturnValue(filtered);
        }
    }

    @Unique
    @Override
    public @NotNull List<class_364> removeOnInitChildrenFancyMenu() {
        return this.removeOnInitChildrenFancyMenu;
    }

    @Unique
    @Override
    public boolean isScreenInitialized_FancyMenu() {
        return this.initialized_FancyMenu;
    }

}