package de.keksuccino.fancymenu.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import de.keksuccino.fancymenu.util.rendering.text.color.TextColorFormatter;
import de.keksuccino.fancymenu.util.rendering.text.color.TextColorFormatterRegistry;
import net.minecraft.class_124;
import net.minecraft.class_2583;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_5223.class)
public class MixinStringDecomposer {

    @Nullable
    @Unique private static Character cachedCharacterFancyMenu = null;
    @Nullable
    @Unique private static class_2583 cachedEmptyStyleFancyMenu = null;

    @Inject(method = "iterateFormatted(Ljava/lang/String;ILnet/minecraft/network/chat/Style;Lnet/minecraft/network/chat/Style;Lnet/minecraft/util/FormattedCharSink;)Z", at = @At("HEAD"))
    private static void beforeIterateFormattedFancyMenu(String in, int i, class_2583 style1, class_2583 emptyStyle, class_5224 sink, CallbackInfoReturnable<Boolean> info) {
        cachedEmptyStyleFancyMenu = emptyStyle;
    }

    @WrapOperation(method = "iterateFormatted(Ljava/lang/String;ILnet/minecraft/network/chat/Style;Lnet/minecraft/network/chat/Style;Lnet/minecraft/util/FormattedCharSink;)Z", at = @At(value = "INVOKE", target = "Lnet/minecraft/ChatFormatting;getByCode(C)Lnet/minecraft/ChatFormatting;"))
    private static class_124 wrapGetByCodeFancyMenu(char c, Operation<class_124> original) {

        //Cache character for using it later
        cachedCharacterFancyMenu = c;

        //Return WHITE here to make iterateFormatted() call applyLegacyFormat() later
        return class_124.field_1068;

    }

    @WrapOperation(method = "iterateFormatted(Ljava/lang/String;ILnet/minecraft/network/chat/Style;Lnet/minecraft/network/chat/Style;Lnet/minecraft/util/FormattedCharSink;)Z", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/chat/Style;applyLegacyFormat(Lnet/minecraft/ChatFormatting;)Lnet/minecraft/network/chat/Style;"))
    private static class_2583 wrapApplyLegacyFormatFancyMenu(class_2583 instance, class_124 chatFormatting, Operation<class_2583> original) {

        if ((cachedCharacterFancyMenu == null) || (cachedEmptyStyleFancyMenu == null)) return original.call(instance, chatFormatting);

        class_2583 returnValue = instance;

        class_124 vanillaFormatting = class_124.method_544(cachedCharacterFancyMenu);
        if (vanillaFormatting != null) {
            returnValue = vanillaFormatting == class_124.field_1070 ? cachedEmptyStyleFancyMenu : original.call(instance, vanillaFormatting);
        } else {
            //Handle custom formatting codes
            TextColorFormatter formatter = TextColorFormatterRegistry.getByCode(cachedCharacterFancyMenu);
            if (formatter != null) returnValue = formatter.getStyle();
        }

        return returnValue;

    }

}
