package de.keksuccino.fancymenu.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.events.screen.RenderedScreenBackgroundEvent;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.ui.widget.*;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4399;
import net.minecraft.class_442;
import net.minecraft.class_4587;
import net.minecraft.class_7077;
import net.minecraft.class_766;
import net.minecraft.client.gui.components.*;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_442.class)
public abstract class MixinTitleScreen extends class_437 {

    @Shadow @Final public static class_2561 COPYRIGHT_TEXT;
    @Shadow @Final private static class_2960 PANORAMA_OVERLAY;
    @Shadow @Nullable private class_4399 realmsNotificationsScreen;
    @Shadow @Final private static class_2960 MINECRAFT_LOGO;
    @Shadow @Final private static class_2960 MINECRAFT_EDITION;
    @Shadow @Nullable private String splash;
    @Shadow public boolean fading;

    @Unique private int cached_mouseX_FancyMenu = -1;
    @Unique private int cached_mouseY_FancyMenu = -1;
    @Unique private float cached_partial_FancyMenu = -1f;

    //unused dummy constructor
    @SuppressWarnings("all")
    private MixinTitleScreen() {
        super(null);
    }

    @Inject(method = "init", at = @At("RETURN"))
    private void after_init_FancyMenu(CallbackInfo info) {

        // Give the Copyright button and identifier
        this.method_25396().forEach(guiEventListener -> {
            if (guiEventListener instanceof class_7077 b) {
                if (b.method_25369() == COPYRIGHT_TEXT) ((UniqueWidget)b).setWidgetIdentifierFancyMenu("title_screen_copyright_button");
            }
        });

        // Add widgets for all Title screen elements to make them editable

        MinecraftLogoRenderer logo = MinecraftLogoRenderer.DEFAULT_INSTANCE;
        this.method_37063(new RendererWidget((this.field_22789 / 2) - (logo.getTotalWidth() / 2), 30, logo.getTotalWidth(), logo.getTotalHeight(),
                        (graphics, mouseX, mouseY, partial, x, y, width, height, renderer) -> {
                            logo.render(GuiGraphics.currentGraphics(), x, y, renderer.getAlpha());
                        }))
                .setWidgetIdentifierFancyMenu("minecraft_logo_widget")
                .method_25355(class_2561.method_43471("fancymenu.widgetified_screens.title_screen.logo"));

        MinecraftSplashRenderer splash = MinecraftSplashRenderer.getDefaultInstance();
        this.method_37063(new RendererWidget(splash.getDefaultPositionX(this.field_22789) - 50, splash.getDefaultPositionY() - 20, 100, 40,
                        (graphics, mouseX, mouseY, partial, x, y, width, height, renderer) -> {
                            int splashColor = class_3532.method_15386(renderer.getAlpha() * 255.0F) << 24;
                            splash.renderAt(GuiGraphics.currentGraphics(), x + (width / 2), y + (height / 2), class_310.method_1551().field_1772, splashColor);
                        }))
                .setWidgetIdentifierFancyMenu("minecraft_splash_widget")
                .method_25355(class_2561.method_43471("fancymenu.widgetified_screens.title_screen.splash"));

        BrandingRenderer branding = new BrandingRenderer(this.field_22790);
        this.method_37063(new RendererWidget(branding.getDefaultPositionX(), branding.getDefaultPositionY(), branding.getTotalWidth(), branding.getTotalHeight(),
                        (pose, mouseX, mouseY, partial, x, y, width, height, renderer) -> {
                            branding.setOpacity(renderer.getAlpha());
                            branding.render(GuiGraphics.currentGraphics(), x, y);
                        }))
                .setWidgetIdentifierFancyMenu("minecraft_branding_widget")
                .method_25355(class_2561.method_43471("fancymenu.widgetified_screens.title_screen.branding"));

        // We don't need that in older MC versions anyway
        this.realmsNotificationsScreen = null;

    }

    @Inject(method = "render", at = @At("HEAD"))
    private void before_render_FancyMenu(class_4587 poseStack, int mouseX, int mouseY, float partial, CallbackInfo ci) {
        this.cached_mouseX_FancyMenu = mouseX;
        this.cached_mouseY_FancyMenu = mouseY;
        this.cached_partial_FancyMenu = partial;
        //Disable fading if customizations enabled, so FancyMenu can properly handle widget alpha
        if (ScreenCustomization.isCustomizationEnabledForScreen(this)) {
            this.fading = false;
        }
    }

    /**
     * @reason Manually fire FancyMenu's {@link RenderedScreenBackgroundEvent} in {@link class_442}, because normal event doesn't work correctly here.
     */
    @WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/PanoramaRenderer;render(FF)V"))
    private void wrap_renderPanorama_FancyMenu(class_766 instance, float deltaT, float alpha, Operation<Void> original) {
        ScreenCustomizationLayer l = ScreenCustomizationLayerHandler.getLayerOfScreen(this);
        if ((l != null) && ScreenCustomization.isCustomizationEnabledForScreen(this)) {
            if (!l.layoutBase.menuBackgrounds.isEmpty()) {
                RenderSystem.enableBlend();
                //Render a black background before the custom background gets rendered
                GuiGraphics.currentGraphics().fill(0, 0, this.field_22789, this.field_22790, 0);
            } else {
                original.call(instance, deltaT, alpha);
            }
        } else {
            original.call(instance, deltaT, alpha);
        }
        EventHandler.INSTANCE.postEvent(new RenderedScreenBackgroundEvent(this, GuiGraphics.currentGraphics(), this.cached_mouseX_FancyMenu, this.cached_mouseY_FancyMenu, this.cached_partial_FancyMenu));
    }

    /**
     * @reason Cancel panorama overlay rendering when a custom background is active.
     */
    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/TitleScreen;blit(Lcom/mojang/blaze3d/vertex/PoseStack;IIIIFFIIII)V"))
    private boolean wrap_blit_in_render_FancyMenu(class_4587 pose, int i1, int i2, int i3, int i4, float v5, float v6, int i7, int i8, int i9, int i0) {
        if (i0 == 128) {
            ScreenCustomizationLayer l = ScreenCustomizationLayerHandler.getLayerOfScreen(this);
            if ((l != null) && ScreenCustomization.isCustomizationEnabledForScreen(this)) {
                if (!l.layoutBase.menuBackgrounds.isEmpty()) {
                    return false;
                }
            }
        }
        return true;
    }

    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lcom/mojang/realmsclient/gui/screens/RealmsNotificationsScreen;render(Lcom/mojang/blaze3d/vertex/PoseStack;IIF)V"))
    private boolean cancel_VanillaRealmsNotificationRendering_FancyMenu(class_4399 instance, class_4587 p_88837_, int p_88838_, int p_88839_, float p_88840_) {
        return false;
    }

    @WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture(ILnet/minecraft/resources/ResourceLocation;)V"))
    private void cancel_VanillaLogoRendering_FancyMenu(int i, class_2960 texture, Operation<Void> original) {
        if (texture == MINECRAFT_LOGO) texture = RenderingUtils.FULLY_TRANSPARENT_TEXTURE;
        if (texture == MINECRAFT_EDITION) texture = RenderingUtils.FULLY_TRANSPARENT_TEXTURE;
        original.call(i, texture);
    }

    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/TitleScreen;drawCenteredString(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/gui/Font;Ljava/lang/String;III)V"))
    private boolean cancel_VanillaSplashRendering_FancyMenu(class_4587 pose, class_327 font, String s, int i1, int i2, int i3) {
        if (s.equals(this.splash)) return false;
        return true;
    }

    /**
     * @reason This is to make the Title screen not constantly update the alpha of its widgets, so FancyMenu can properly handle it.
     */
    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/components/AbstractWidget;setAlpha(F)V"))
    private boolean cancel_setAlpha_FancyMenu(class_339 instance, float alpha) {
        return !ScreenCustomization.isCustomizationEnabledForScreen(this);
    }

}