package de.keksuccino.fancymenu.mixin.mixins.fabric.client;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import de.keksuccino.fancymenu.util.rendering.ui.FancyMenuUiComponent;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_312.class)
public class MixinFabricMouseHandler {

    @Shadow private double xpos;
    @Shadow private double ypos;

    @Unique private int cachedMouseButton_FancyMenu = -1;

    /**
     * @reason This restores Minecraft's old UI component scroll logic to not only scroll the hovered component, but all of them. The old logic is only used for FancyMenu's components.
     */
    @WrapOperation(method = "onScroll", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/Screen;mouseScrolled(DDD)Z"))
    private boolean wrap_Screen_mouseScrolled_in_onScroll_FancyMenu(class_437 instance, double v1, double v2, double v3, Operation<Boolean> original) {
        for (class_364 listener : instance.method_25396()) {
            if (listener instanceof FancyMenuUiComponent) {
                if (listener.method_25401(v1, v2, v3)) {
                    return true;
                }
            }
        }
        return original.call(instance, v1, v2, v3);
    }

    @Inject(method = "onPress", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/platform/Window;getScreenWidth()I"))
    private void before_getScreenWidth_in_onPress_FancyMenu(long windowPointer, int button, int action, int modifiers, CallbackInfo info) {
        this.cachedMouseButton_FancyMenu = button;
    }

    /**
     * @reason This restores Minecraft's old UI component click logic to not only click the hovered component, but all of them. The old logic is only used for FancyMenu's components.
     */
    @WrapWithCondition(method = "onPress", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/Screen;wrapScreenError(Ljava/lang/Runnable;Ljava/lang/String;Ljava/lang/String;)V"))
    private boolean wrap_Screen_mouseClicked_in_onPress_FancyMenu(Runnable runnable, String message, String className) {
        if ("mouseClicked event handler".equals(message)) {
            class_310 minecraft = class_310.method_1551();
            class_437 instance = minecraft.field_1755;
            if (instance != null) {
                double d = this.xpos * (double) minecraft.method_22683().method_4486() / (double) minecraft.method_22683().method_4480();
                double e = this.ypos * (double) minecraft.method_22683().method_4502() / (double) minecraft.method_22683().method_4507();
                for (class_364 listener : instance.method_25396()) {
                    if (listener instanceof FancyMenuUiComponent) {
                        if (listener.method_25402(d, e, this.cachedMouseButton_FancyMenu)) {
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    /**
     * @reason This restores Minecraft's old UI component click logic to not only click the hovered component, but all of them. The old logic is only used for FancyMenu's components.
     */
    @WrapWithCondition(method = "onPress", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/Screen;wrapScreenError(Ljava/lang/Runnable;Ljava/lang/String;Ljava/lang/String;)V"))
    private boolean wrap_Screen_mouseReleased_in_onPress_FancyMenu(Runnable runnable, String message, String className) {
        if ("mouseReleased event handler".equals(message)) {
            class_310 minecraft = class_310.method_1551();
            class_437 instance = minecraft.field_1755;
            if (instance != null) {
                double d = this.xpos * (double) minecraft.method_22683().method_4486() / (double) minecraft.method_22683().method_4480();
                double e = this.ypos * (double) minecraft.method_22683().method_4502() / (double) minecraft.method_22683().method_4507();
                for (class_364 listener : instance.method_25396()) {
                    if (listener instanceof FancyMenuUiComponent) {
                        if (listener.method_25406(d, e, this.cachedMouseButton_FancyMenu)) {
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

}
