package de.keksuccino.fancymenu.networking.packets.commands.opengui;

import de.keksuccino.fancymenu.customization.customgui.CustomGuiHandler;
import de.keksuccino.fancymenu.customization.screen.ScreenInstanceFactory;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_525;

public class ClientSideOpenGuiCommandPacketLogic {

    private static final Logger LOGGER = LogManager.getLogger();

    protected static boolean handle(@NotNull OpenGuiCommandPacket packet) {
        if (class_310.method_1551().field_1724 == null) return false;
        try {
            Objects.requireNonNull(packet.screen_identifier);
            if (packet.screen_identifier.equalsIgnoreCase(class_525.class.getName())) {
                class_525.method_31130(class_310.method_1551(), class_310.method_1551().field_1755);
                return true;
            }
            if (CustomGuiHandler.guiExists(packet.screen_identifier)) {
                class_437 custom = CustomGuiHandler.constructInstance(packet.screen_identifier, class_310.method_1551().field_1755, null);
                if (custom != null) class_310.method_1551().method_1507(custom);
                return true;
            } else {
                class_437 s = ScreenInstanceFactory.tryConstruct(ScreenIdentifierHandler.getBestIdentifier(packet.screen_identifier));
                if (s != null) {
                    class_310.method_1551().method_1507(s);
                    return true;
                } else {
                    packet.sendChatFeedback(class_2561.method_43469("fancymenu.commmands.openguiscreen.unable_to_open_gui", packet.screen_identifier), true);
                }
            }
        } catch (Exception ex) {
            packet.sendChatFeedback(class_2561.method_43471("fancymenu.commands.openguiscreen.error"), true);
            LOGGER.error("[FANCYMENU] An error happened while trying to open a GUI via the /openguiscreen command!", ex);
        }
        return false;
    }

}
