package de.keksuccino.fancymenu.util;

import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinClientLanguage;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.konkrete.input.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1078;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_7417;

public class LocalizationUtils {

    @NotNull
    public static class_2561[] splitLocalizedLines(@NotNull String localizationKey, String... placeholderReplacements) {
        List<class_2561> l = new ArrayList<>();
        for (String s : splitLocalizedStringLines(localizationKey, placeholderReplacements)) {
            l.add(Components.literal(s));
        }
        return l.toArray(new class_2561[]{});
    }

    @NotNull
    public static String[] splitLocalizedStringLines(@NotNull String localizationKey, String... placeholderReplacements) {
        return StringUtils.splitLines(class_1074.method_4662(localizationKey, (Object[]) placeholderReplacements), "\n");
    }

    @NotNull
    public static List<String> getLocalizationKeys() {
        List<String> keys = new ArrayList<>();
        class_2477 lang = class_2477.method_10517();
        if (lang instanceof class_1078 c) {
            keys.addAll(((IMixinClientLanguage)c).getStorageFancyMenu().keySet());
        }
        return keys;
    }

    public static boolean isLocalizationKey(String key) {
        if (key == null) return false;
        return class_1074.method_4663(key);
    }

    @Nullable
    public static String getComponentLocalizationKey(@NotNull class_2561 component) {
        if (component instanceof class_5250 m) {
            class_7417 cc = m.method_10851();
            if (cc instanceof class_2588 t) {
                return t.method_11022();
            }
        }
        return null;
    }

}
