package de.keksuccino.fancymenu.util.enums;

import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import org.jetbrains.annotations.NotNull;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

/**
 * @param <E> The enum type.
 */
public interface LocalizedEnum<E> extends NamedEnum<E> {

    Supplier<class_2583> SUCCESS_TEXT_STYLE = () -> class_2583.field_24360.method_36139(UIBase.getUIColorTheme().success_text_color.getColorInt());
    Supplier<class_2583> WARNING_TEXT_STYLE = () -> class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt());
    Supplier<class_2583> ERROR_TEXT_STYLE = () -> class_2583.field_24360.method_36139(UIBase.getUIColorTheme().error_text_color.getColorInt());

    @NotNull
    String getLocalizationKeyBase();

    @NotNull
    default String getValueLocalizationKey() {
        return this.getLocalizationKeyBase() + "." + this.getName();
    }

    @NotNull
    default class_5250 getValueComponent() {
        return class_2561.method_43471(this.getValueLocalizationKey()).method_27696(this.getValueComponentStyle());
    }

    @NotNull
    default class_2583 getValueComponentStyle() {
        return class_2583.field_24360;
    }

}
