package de.keksuccino.fancymenu.util.rendering.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.ObjectUtils;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1041;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1309;
import net.minecraft.class_133;
import net.minecraft.class_148;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2ic;

@SuppressWarnings("unused")
public class GuiGraphics {

    public static final class_437 DUMMY_SCREEN = ObjectUtils.build(() -> {
        class_437 s = new class_442();
        s.method_25423(class_310.method_1551(), 1000, 1000);
        return s;
    });
    public static final class_332 GUI_COMPONENT = new class_332() {
        @Override
        protected void method_25292(class_4587 $$0, int $$1, int $$2, int $$3, int $$4) {
            super.method_25292($$0, $$1, $$2, $$3, $$4);
        }
    };

    public static final float MAX_GUI_Z = 10000.0F;
    public static final float MIN_GUI_Z = -10000.0F;
    private static final int EXTRA_SPACE_AFTER_FIRST_TOOLTIP_LINE = 2;
    private final class_310 minecraft;
    private final class_4587 pose;
    private final class_4597.class_4598 bufferSource;
    private final GuiGraphics.ScissorStack scissorStack = new GuiGraphics.ScissorStack();
    private boolean managed;

    protected static GuiGraphics currentGraphics = null;

    @NotNull
    public static GuiGraphics updateGraphicsAndGet(@NotNull class_4587 pose, @NotNull class_4597.class_4598 bufferSource) {
        currentGraphics = new GuiGraphics(class_310.method_1551(), pose, bufferSource);
        return currentGraphics;
    }

    public static GuiGraphics currentGraphics() {
        return currentGraphics;
    }

    private GuiGraphics(class_310 minecraft, class_4587 pose, class_4597.class_4598 bufferSource) {
        this.minecraft = minecraft;
        this.pose = pose;
        this.bufferSource = bufferSource;
    }

    public GuiGraphics(class_310 minecraft, class_4597.class_4598 bufferSource) {
        this(minecraft, new class_4587(), bufferSource);
    }

    public class_4597.class_4598 getBufferSource() {
        return this.bufferSource;
    }

    /**
     * Executes a runnable while managing the render state. The render state is flushed before and after executing the runnable.
     *
     * @param runnable the runnable to execute.
     */
    public void drawManaged(Runnable runnable) {
        this.flush();
        this.managed = true;
        runnable.run();
        this.managed = false;
        this.flush();
    }

    /**
     * Flushes the render state if it is not managed.
     */
    private void flushIfUnmanaged() {
        if (!this.managed) {
            this.flush();
        }
    }

    /**
     * Flushes the render state if it is managed.
     */
    private void flushIfManaged() {
        if (this.managed) {
            this.flush();
        }
    }

    /**
     * {@return returns the width of the GUI screen in pixels}
     */
    public int guiWidth() {
        return this.minecraft.method_22683().method_4486();
    }

    /**
     * {@return returns the height of the GUI screen in pixels}
     */
    public int guiHeight() {
        return this.minecraft.method_22683().method_4502();
    }

    /**
     * {@return returns the PoseStack used for transformations and rendering.}
     */
    public class_4587 pose() {
        return this.pose;
    }

    /**
     * {@return returns the buffer source for rendering.}
     */
    public class_4597.class_4598 bufferSource() {
        return this.bufferSource;
    }

    /**
     * Flushes the render state, ending the current batch and enabling depth testing.
     */
    public void flush() {
        RenderSystem.disableDepthTest();
        this.bufferSource.method_22993();
        RenderSystem.enableDepthTest();
    }

    /**
     * Draws a horizontal line from minX to maxX at the specified y-coordinate with the given color.
     *
     * @param minX the x-coordinate of the start point.
     * @param maxX the x-coordinate of the end point.
     * @param y the y-coordinate of the line.
     * @param color the color of the line.
     */
    public void hLine(int minX, int maxX, int y, int color) {
        this.hLine(GuiRenderTypes.gui(), minX, maxX, y, color);
    }

    /**
     * Draws a horizontal line from minX to maxX at the specified y-coordinate with the given color using the specified render type.
     *
     * @param renderType the render type to use.
     * @param minX the x-coordinate of the start point.
     * @param maxX the x-coordinate of the end point.
     * @param y the y-coordinate of the line.
     * @param color the color of the line.
     */
    public void hLine(class_1921 renderType, int minX, int maxX, int y, int color) {
        if (maxX < minX) {
            int i = minX;
            minX = maxX;
            maxX = i;
        }

        this.fill(renderType, minX, y, maxX + 1, y + 1, color);
    }

    /**
     * Draws a vertical line from minY to maxY at the specified x-coordinate with the given color.
     *
     * @param x the x-coordinate of the line.
     * @param minY the y-coordinate of the start point.
     * @param maxY the y-coordinate of the end point.
     * @param color the color of the line.
     */
    public void vLine(int x, int minY, int maxY, int color) {
        this.vLine(GuiRenderTypes.gui(), x, minY, maxY, color);
    }

    /**
     * Draws a vertical line from minY to maxY at the specified x-coordinate with the given color using the specified render type.
     *
     * @param renderType the render type to use.
     * @param x the x-coordinate of the line.
     * @param minY the y-coordinate of the start point.
     * @param maxY the y-coordinate of the end point.
     * @param color the color of the line.
     */
    public void vLine(class_1921 renderType, int x, int minY, int maxY, int color) {
        if (maxY < minY) {
            int i = minY;
            minY = maxY;
            maxY = i;
        }

        this.fill(renderType, x, minY + 1, x + 1, maxY, color);
    }

    /**
     * Enables scissoring with the specified screen coordinates.
     *
     * @param minX the minimum x-coordinate of the scissor region.
     * @param minY the minimum y-coordinate of the scissor region.
     * @param maxX the maximum x-coordinate of the scissor region.
     * @param maxY the maximum y-coordinate of the scissor region.
     */
    public void enableScissor(int minX, int minY, int maxX, int maxY) {
        this.applyScissor(this.scissorStack.push(new ScreenRectangle(minX, minY, maxX - minX, maxY - minY)));
    }

    /**
     * Disables scissoring.
     */
    public void disableScissor() {
        this.applyScissor(this.scissorStack.pop());
    }

    /**
     * Applies scissoring based on the provided screen rectangle.
     *
     * @param rectangle the screen rectangle to apply scissoring with. Can be null to disable scissoring.
     */
    private void applyScissor(@Nullable ScreenRectangle rectangle) {
        this.flushIfManaged();
        if (rectangle != null) {
            class_1041 window = class_310.method_1551().method_22683();
            int i = window.method_4506();
            double d = window.method_4495();
            double e = (double)rectangle.left() * d;
            double f = (double)i - (double)rectangle.bottom() * d;
            double g = (double)rectangle.width() * d;
            double h = (double)rectangle.height() * d;
            RenderSystem.enableScissor((int)e, (int)f, Math.max(0, (int)g), Math.max(0, (int)h));
        } else {
            RenderSystem.disableScissor();
        }
    }

    /**
     * Sets the current rendering color.
     *
     * @param red the red component of the color.
     * @param green the green component of the color.
     * @param blue the blue component of the color.
     * @param alpha the alpha component of the color.
     */
    public void setColor(float red, float green, float blue, float alpha) {
        this.flushIfManaged();
        RenderSystem.setShaderColor(red, green, blue, alpha);
    }

    /**
     * Fills a rectangle with the specified color using the given coordinates as the boundaries.
     *
     * @param minX the minimum x-coordinate of the rectangle.
     * @param minY the minimum y-coordinate of the rectangle.
     * @param maxX the maximum x-coordinate of the rectangle.
     * @param maxY the maximum y-coordinate of the rectangle.
     * @param color the color to fill the rectangle with.
     */
    public void fill(int minX, int minY, int maxX, int maxY, int color) {
        this.fill(minX, minY, maxX, maxY, 0, color);
    }

    /**
     * Fills a rectangle with the specified color and z-level using the given coordinates as the boundaries.
     *
     * @param minX the minimum x-coordinate of the rectangle.
     * @param minY the minimum y-coordinate of the rectangle.
     * @param maxX the maximum x-coordinate of the rectangle.
     * @param maxY the maximum y-coordinate of the rectangle.
     * @param z the z-level of the rectangle.
     * @param color the color to fill the rectangle with.
     */
    public void fill(int minX, int minY, int maxX, int maxY, int z, int color) {
        this.fill(GuiRenderTypes.gui(), minX, minY, maxX, maxY, z, color);
    }

    /**
     * Fills a rectangle with the specified color using the given render type and coordinates as the boundaries.
     *
     * @param renderType the render type to use.
     * @param minX the minimum x-coordinate of the rectangle.
     * @param minY the minimum y-coordinate of the rectangle.
     * @param maxX the maximum x-coordinate of the rectangle.
     * @param maxY the maximum y-coordinate of the rectangle.
     * @param color the color to fill the rectangle with.
     */
    public void fill(class_1921 renderType, int minX, int minY, int maxX, int maxY, int color) {
        this.fill(renderType, minX, minY, maxX, maxY, 0, color);
    }

    /**
     * Fills a rectangle with the specified color and z-level using the given render type and coordinates as the boundaries.
     *
     * @param renderType the render type to use.
     * @param minX the minimum x-coordinate of the rectangle.
     * @param minY the minimum y-coordinate of the rectangle.
     * @param maxX the maximum x-coordinate of the rectangle.
     * @param maxY the maximum y-coordinate of the rectangle.
     * @param z the z-level of the rectangle.
     * @param color the color to fill the rectangle with.
     */
    public void fill(class_1921 renderType, int minX, int minY, int maxX, int maxY, int z, int color) {
        class_1159 matrix4F = this.pose.method_23760().method_23761();
        if (minX < maxX) {
            int i = minX;
            minX = maxX;
            maxX = i;
        }

        if (minY < maxY) {
            int i = minY;
            minY = maxY;
            maxY = i;
        }

        float f = (float)class_5253.class_5254.method_27762(color) / 255.0F;
        float g = (float)class_5253.class_5254.method_27765(color) / 255.0F;
        float h = (float)class_5253.class_5254.method_27766(color) / 255.0F;
        float j = (float)class_5253.class_5254.method_27767(color) / 255.0F;
        class_4588 vertexConsumer = this.bufferSource.getBuffer(renderType);
        vertexConsumer.method_22918(matrix4F, (float)minX, (float)minY, (float)z).method_22915(g, h, j, f).method_1344();
        vertexConsumer.method_22918(matrix4F, (float)minX, (float)maxY, (float)z).method_22915(g, h, j, f).method_1344();
        vertexConsumer.method_22918(matrix4F, (float)maxX, (float)maxY, (float)z).method_22915(g, h, j, f).method_1344();
        vertexConsumer.method_22918(matrix4F, (float)maxX, (float)minY, (float)z).method_22915(g, h, j, f).method_1344();
        this.flushIfUnmanaged();
    }

    /**
     * Fills a rectangle with a gradient color from colorFrom to colorTo using the given coordinates as the boundaries.
     *
     * @param x1 the x-coordinate of the first corner of the rectangle.
     * @param y1 the y-coordinate of the first corner of the rectangle.
     * @param x2 the x-coordinate of the second corner of the rectangle.
     * @param y2 the y-coordinate of the second corner of the rectangle.
     * @param colorFrom the starting color of the gradient.
     * @param colorTo the ending color of the gradient.
     */
    public void fillGradient(int x1, int y1, int x2, int y2, int colorFrom, int colorTo) {
        this.fillGradient(x1, y1, x2, y2, 0, colorFrom, colorTo);
    }

    /**
     * Fills a rectangle with a gradient color from colorFrom to colorTo at the specified z-level using the given coordinates as the boundaries.
     *
     * @param x1 the x-coordinate of the first corner of the rectangle.
     * @param y1 the y-coordinate of the first corner of the rectangle.
     * @param x2 the x-coordinate of the second corner of the rectangle.
     * @param y2 the y-coordinate of the second corner of the rectangle.
     * @param z the z-level of the rectangle.
     * @param colorFrom the starting color of the gradient.
     * @param colorTo the ending color of the gradient.
     */
    public void fillGradient(int x1, int y1, int x2, int y2, int z, int colorFrom, int colorTo) {
        this.fillGradient(GuiRenderTypes.gui(), x1, y1, x2, y2, colorFrom, colorTo, z);
    }

    /**
     * Fills a rectangle with a gradient color from colorFrom to colorTo at the specified z-level using the given render type and coordinates as the boundaries.
     *
     * @param renderType the render type to use.
     * @param x1 the x-coordinate of the first corner of the rectangle.
     * @param y1 the y-coordinate of the first corner of the rectangle.
     * @param x2 the x-coordinate of the second corner of the rectangle.
     * @param y2 the y-coordinate of the second corner of the rectangle.
     * @param colorFrom the starting color of the gradient.
     * @param colorTo the ending color of the gradient.
     * @param z the z-level of the rectangle.
     */
    public void fillGradient(class_1921 renderType, int x1, int y1, int x2, int y2, int colorFrom, int colorTo, int z) {
        class_4588 vertexConsumer = this.bufferSource.getBuffer(renderType);
        this.fillGradient(vertexConsumer, x1, y1, x2, y2, z, colorFrom, colorTo);
        this.flushIfUnmanaged();
    }

    /**
     * The core `fillGradient` method.
     * <p>
     * Fills a rectangle with a gradient color from colorFrom to colorTo at the specified z-level using the given render type and coordinates as the boundaries.
     *
     * @param consumer the {@linkplain class_4588} object for drawing the vertices on screen.
     * @param x1 the x-coordinate of the first corner of the rectangle.
     * @param y1 the y-coordinate of the first corner of the rectangle.
     * @param x2 the x-coordinate of the second corner of the rectangle.
     * @param y2 the y-coordinate of the second corner of the rectangle.
     * @param z the z-level of the rectangle.
     * @param colorFrom the starting color of the gradient.
     * @param colorTo the ending color of the gradient.
     */
    private void fillGradient(class_4588 consumer, int x1, int y1, int x2, int y2, int z, int colorFrom, int colorTo) {
        float f = (float)class_5253.class_5254.method_27762(colorFrom) / 255.0F;
        float g = (float)class_5253.class_5254.method_27765(colorFrom) / 255.0F;
        float h = (float)class_5253.class_5254.method_27766(colorFrom) / 255.0F;
        float i = (float)class_5253.class_5254.method_27767(colorFrom) / 255.0F;
        float j = (float)class_5253.class_5254.method_27762(colorTo) / 255.0F;
        float k = (float)class_5253.class_5254.method_27765(colorTo) / 255.0F;
        float l = (float)class_5253.class_5254.method_27766(colorTo) / 255.0F;
        float m = (float)class_5253.class_5254.method_27767(colorTo) / 255.0F;
        class_1159 matrix4F = this.pose.method_23760().method_23761();
        consumer.method_22918(matrix4F, (float)x1, (float)y1, (float)z).method_22915(g, h, i, f).method_1344();
        consumer.method_22918(matrix4F, (float)x1, (float)y2, (float)z).method_22915(k, l, m, j).method_1344();
        consumer.method_22918(matrix4F, (float)x2, (float)y2, (float)z).method_22915(k, l, m, j).method_1344();
        consumer.method_22918(matrix4F, (float)x2, (float)y1, (float)z).method_22915(g, h, i, f).method_1344();
    }

    /**
     * Draws a centered string at the specified coordinates using the given font, text, and color.
     *
     * @param font the font to use for rendering.
     * @param text the text to draw.
     * @param x the x-coordinate of the center of the string.
     * @param y the y-coordinate of the string.
     * @param color the color of the string.
     */
    public void drawCenteredString(class_327 font, String text, int x, int y, int color) {
        this.drawString(font, text, x - font.method_1727(text) / 2, y, color);
    }

    /**
     * Draws a centered string at the specified coordinates using the given font, text component, and color.
     *
     * @param font the font to use for rendering.
     * @param text the text component to draw.
     * @param x the x-coordinate of the center of the string.
     * @param y the y-coordinate of the string.
     * @param color the color of the string.
     */
    public void drawCenteredString(class_327 font, class_2561 text, int x, int y, int color) {
        class_5481 formattedCharSequence = text.method_30937();
        this.drawString(font, formattedCharSequence, x - font.method_30880(formattedCharSequence) / 2, y, color);
    }

    /**
     * Draws a centered string at the specified coordinates using the given font, formatted character sequence, and color.
     *
     * @param font the font to use for rendering.
     * @param text the formatted character sequence to draw.
     * @param x the x-coordinate of the center of the string.
     * @param y the y-coordinate of the string.
     * @param color the color of the string.
     */
    public void drawCenteredString(class_327 font, class_5481 text, int x, int y, int color) {
        this.drawString(font, text, x - font.method_30880(text) / 2, y, color);
    }

    /**
     * Draws a string at the specified coordinates using the given font, text, and color. Returns the width of the drawn string.
     * <p>
     * @return the width of the drawn string.
     *
     * @param font the font to use for rendering.
     * @param text the text to draw.
     * @param x the x-coordinate of the string.
     * @param y the y-coordinate of the string.
     * @param color the color of the string.
     */
    public int drawString(class_327 font, @Nullable String text, int x, int y, int color) {
        return this.drawString(font, text, x, y, color, true);
    }

    /**
     * Draws a string at the specified coordinates using the given font, text, color, and drop shadow. Returns the width of the drawn string.
     * <p>
     * @return the width of the drawn string.
     *
     * @param font the font to use for rendering.
     * @param text the text to draw.
     * @param x the x-coordinate of the string.
     * @param y the y-coordinate of the string.
     * @param color the color of the string.
     * @param dropShadow whether to apply a drop shadow to the string.
     */
    public int drawString(class_327 font, @Nullable String text, int x, int y, int color, boolean dropShadow) {
        if (text == null) {
            return 0;
        } else {
            boolean seeThrough = false;
            int i = font.method_27522(text, (float)x, (float)y, color, dropShadow, this.pose.method_23760().method_23761(), this.bufferSource, seeThrough, 0, 15728880, font.method_1726());
            this.flushIfUnmanaged();
            return i;
        }
    }

    /**
     * Draws a formatted character sequence at the specified coordinates using the given font, text, and color. Returns the width of the drawn string.
     * <p>
     * @return the width of the drawn string.
     *
     * @param font the font to use for rendering.
     * @param text the formatted character sequence to draw.
     * @param x the x-coordinate of the string.
     * @param y the y-coordinate of the string.
     * @param color the color of the string
     */
    public int drawString(class_327 font, class_5481 text, int x, int y, int color) {
        return this.drawString(font, text, x, y, color, true);
    }

    /**
     * Draws a formatted character sequence at the specified coordinates using the given font, text, color, and drop shadow. Returns the width of the drawn string.
     * <p>
     * @return returns the width of the drawn string.
     *
     * @param font the font to use for rendering.
     * @param text the formatted character sequence to draw.
     * @param x the x-coordinate of the string.
     * @param y the y-coordinate of the string.
     * @param color the color of the string.
     * @param dropShadow whether to apply a drop shadow to the string.
     */
    public int drawString(class_327 font, class_5481 text, int x, int y, int color, boolean dropShadow) {
        boolean seeThrough = false;
        int i = font.method_22942(text, (float)x, (float)y, color, dropShadow, this.pose.method_23760().method_23761(), this.bufferSource, seeThrough, 0, 15728880);
        this.flushIfUnmanaged();
        return i;
    }

    /**
     * Draws a component's visual order text at the specified coordinates using the given font, text component, and color.
     * <p>
     * @return the width of the drawn string.
     *
     * @param font the font to use for rendering.
     * @param text the text component to draw.
     * @param x the x-coordinate of the string.
     * @param y the y-coordinate of the string.
     * @param color the color of the string.
     */
    public int drawString(class_327 font, class_2561 text, int x, int y, int color) {
        return this.drawString(font, text, x, y, color, true);
    }

    /**
     * Draws a component's visual order text at the specified coordinates using the given font, text component, color, and drop shadow.
     * <p>
     * @return the width of the drawn string.
     *
     * @param font the font to use for rendering.
     * @param text the text component to draw.
     * @param x the x-coordinate of the string.
     * @param y the y-coordinate of the string.
     * @param color the color of the string.
     * @param dropShadow whether to apply a drop shadow to the string.
     */
    public int drawString(class_327 font, class_2561 text, int x, int y, int color, boolean dropShadow) {
        return this.drawString(font, text.method_30937(), x, y, color, dropShadow);
    }

    /**
     * Draws a formatted text with word wrapping at the specified coordinates using the given font, text, line width, and color.
     *
     * @param font the font to use for rendering.
     * @param text the formatted text to draw.
     * @param x the x-coordinate of the starting position.
     * @param y the y-coordinate of the starting position.
     * @param lineWidth the maximum width of each line before wrapping.
     * @param color the color of the text.
     */
    public void drawWordWrap(class_327 font, class_5348 text, int x, int y, int lineWidth, int color) {
        for (class_5481 formattedCharSequence : font.method_1728(text, lineWidth)) {
            this.drawString(font, formattedCharSequence, x, y, color, false);
            y += 9;
        }
    }

    /**
     * Blits a portion of the specified texture atlas sprite onto the screen at the given coordinates.
     *
     * @param x the x-coordinate of the blit position.
     * @param y the y-coordinate of the blit position.
     * @param blitOffset the z-level offset for rendering order.
     * @param width the width of the blitted portion.
     * @param height the height of the blitted portion.
     * @param sprite the texture atlas sprite to blit.
     */
    public void blit(int x, int y, int blitOffset, int width, int height, class_1058 sprite) {
        this.innerBlit(sprite.method_4598(), x, x + width, y, y + height, blitOffset, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575());
    }

    /**
     * Blits a portion of the specified texture atlas sprite onto the screen at the given coordinates with a color tint.
     *
     * @param x the x-coordinate of the blit position.
     * @param y the y-coordinate of the blit position.
     * @param blitOffset the z-level offset for rendering order.
     * @param width the width of the blitted portion.
     * @param height the height of the blitted portion.
     * @param sprite the texture atlas sprite to blit.
     * @param red the red component of the color tint.
     * @param green the green component of the color tint.
     * @param blue the blue component of the color tint.
     * @param alpha the alpha component of the color tint.
     */
    public void blit(int x, int y, int blitOffset, int width, int height, class_1058 sprite, float red, float green, float blue, float alpha) {
        this.innerBlit(
                sprite.method_4598(), x, x + width, y, y + height, blitOffset, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575(), red, green, blue, alpha
        );
    }

    /**
     * Renders an outline rectangle on the screen with the specified color.
     *
     * @param x the x-coordinate of the top-left corner of the rectangle.
     * @param y the y-coordinate of the top-left corner of the rectangle.
     * @param width the width of the blitted portion.
     * @param height the height of the rectangle.
     * @param color the color of the outline.
     */
    public void renderOutline(int x, int y, int width, int height, int color) {
        this.fill(x, y, x + width, y + 1, color);
        this.fill(x, y + height - 1, x + width, y + height, color);
        this.fill(x, y + 1, x + 1, y + height - 1, color);
        this.fill(x + width - 1, y + 1, x + width, y + height - 1, color);
    }

    /**
     * Blits a portion of the texture specified by the atlas location onto the screen at the given coordinates.
     *
     * @param atlasLocation the location of the texture atlas.
     * @param x the x-coordinate of the blit position.
     * @param y the y-coordinate of the blit position.
     * @param uOffset the horizontal texture coordinate offset.
     * @param vOffset the vertical texture coordinate offset.
     * @param uWidth the width of the blitted portion in texture coordinates.
     * @param vHeight the height of the blitted portion in texture coordinates.
     */
    public void blit(class_2960 atlasLocation, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        this.blit(atlasLocation, x, y, 0, (float)uOffset, (float)vOffset, uWidth, vHeight, 256, 256);
    }

    /**
     * Blits a portion of the texture specified by the atlas location onto the screen at the given coordinates with a blit offset and texture coordinates.
     *
     * @param atlasLocation the location of the texture atlas.
     * @param x the x-coordinate of the blit position.
     * @param y the y-coordinate of the blit position.
     * @param blitOffset the z-level offset for rendering order.
     * @param uOffset the horizontal texture coordinate offset.
     * @param vOffset the vertical texture coordinate offset.
     * @param uWidth the width of the blitted portion in texture coordinates.
     * @param vHeight the height of the blitted portion in texture coordinates.
     * @param textureWidth the width of the texture.
     * @param textureHeight the height of the texture.
     */
    public void blit(
            class_2960 atlasLocation, int x, int y, int blitOffset, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight
    ) {
        this.blit(atlasLocation, x, x + uWidth, y, y + vHeight, blitOffset, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    /**
     * Blits a portion of the texture specified by the atlas location onto the screen at the given position and dimensions with texture coordinates.
     *
     * @param atlasLocation the location of the texture atlas.
     * @param x the x-coordinate of the top-left corner of the blit position.
     * @param y the y-coordinate of the top-left corner of the blit position.
     * @param width the width of the blitted portion.
     * @param height the height of the blitted portion.
     * @param uOffset the horizontal texture coordinate offset.
     * @param vOffset the vertical texture coordinate offset.
     * @param uWidth the width of the blitted portion in texture coordinates.
     * @param vHeight the height of the blitted portion in texture coordinates.
     * @param textureWidth the width of the texture.
     * @param textureHeight the height of the texture.
     */
    public void blit(
            class_2960 atlasLocation,
            int x,
            int y,
            int width,
            int height,
            float uOffset,
            float vOffset,
            int uWidth,
            int vHeight,
            int textureWidth,
            int textureHeight
    ) {
        this.blit(atlasLocation, x, x + width, y, y + height, 0, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    /**
     * Blits a portion of the texture specified by the atlas location onto the screen at the given position and dimensions with texture coordinates.
     *
     * @param atlasLocation the location of the texture atlas.
     * @param x the x-coordinate of the top-left corner of the blit position.
     * @param y the y-coordinate of the top-left corner of the blit position.
     * @param uOffset the horizontal texture coordinate offset.
     * @param vOffset the vertical texture coordinate offset.
     * @param width the width of the blitted portion.
     * @param height the height of the blitted portion.
     * @param textureWidth the width of the texture.
     * @param textureHeight the height of the texture.
     */
    public void blit(class_2960 atlasLocation, int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight) {
        this.blit(atlasLocation, x, y, width, height, uOffset, vOffset, width, height, textureWidth, textureHeight);
    }

    /**
     * Performs the inner blit operation for rendering a texture with the specified coordinates and texture coordinates.
     *
     * @param atlasLocation the location of the texture atlas.
     * @param x1 the x-coordinate of the first corner of the blit position.
     * @param x2 the x-coordinate of the second corner of the blit position.
     * @param y1 the y-coordinate of the first corner of the blit position.
     * @param y2 the y-coordinate of the second corner of the blit position.
     * @param blitOffset the z-level offset for rendering order.
     * @param uWidth the width of the blitted portion in texture coordinates.
     * @param vHeight the height of the blitted portion in texture coordinates.
     * @param uOffset the horizontal texture coordinate offset.
     * @param vOffset the vertical texture coordinate offset.
     * @param textureWidth the width of the texture.
     * @param textureHeight the height of the texture.
     */
    void blit(
            class_2960 atlasLocation,
            int x1,
            int x2,
            int y1,
            int y2,
            int blitOffset,
            int uWidth,
            int vHeight,
            float uOffset,
            float vOffset,
            int textureWidth,
            int textureHeight
    ) {
        this.innerBlit(
                atlasLocation,
                x1,
                x2,
                y1,
                y2,
                blitOffset,
                (uOffset + 0.0F) / (float)textureWidth,
                (uOffset + (float)uWidth) / (float)textureWidth,
                (vOffset + 0.0F) / (float)textureHeight,
                (vOffset + (float)vHeight) / (float)textureHeight
        );
    }

    /**
     * Performs the inner blit operation for rendering a texture with the specified coordinates and texture coordinates without color tinting.
     *
     * @param atlasLocation the location of the texture atlas.
     * @param x1 the x-coordinate of the first corner of the blit position.
     * @param x2 the x-coordinate of the second corner of the blit position.
     * @param y1 the y-coordinate of the first corner of the blit position.
     * @param y2 the y-coordinate of the second corner of the blit position.
     * @param blitOffset the z-level offset for rendering order.
     * @param minU the minimum horizontal texture coordinate.
     * @param maxU the maximum horizontal texture coordinate.
     * @param minV the minimum vertical texture coordinate.
     * @param maxV the maximum vertical texture coordinate.
     */
    void innerBlit(class_2960 atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        RenderSystem.setShaderTexture(0, atlasLocation);
        RenderSystem.setShader(class_757::method_34542);
        class_1159 matrix4F = this.pose.method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4F, (float)x1, (float)y1, (float)blitOffset).method_22913(minU, minV).method_1344();
        bufferBuilder.method_22918(matrix4F, (float)x1, (float)y2, (float)blitOffset).method_22913(minU, maxV).method_1344();
        bufferBuilder.method_22918(matrix4F, (float)x2, (float)y2, (float)blitOffset).method_22913(maxU, maxV).method_1344();
        bufferBuilder.method_22918(matrix4F, (float)x2, (float)y1, (float)blitOffset).method_22913(maxU, minV).method_1344();
        class_286.method_43433(bufferBuilder.method_1326());
    }

    /**
     * Performs the inner blit operation for rendering a texture with the specified coordinates, texture coordinates, and color tint.
     *
     * @param atlasLocation the location of the texture atlas.
     * @param x1 the x-coordinate of the first corner of the blit position.
     * @param x2 the x-coordinate of the second corner of the blit position.
     * @param y1 the y-coordinate of the first corner of the blit position.
     * @param y2 the y-coordinate of the second corner of the blit position.
     * @param blitOffset the z-level offset for rendering order.
     * @param minU the minimum horizontal texture coordinate.
     * @param maxU the maximum horizontal texture coordinate.
     * @param minV the minimum vertical texture coordinate.
     * @param maxV the maximum vertical texture coordinate.
     * @param red the red component of the color tint.
     * @param green the green component of the color tint.
     * @param blue the blue component of the color tint.
     * @param alpha the alpha component of the color tint.
     */
    void innerBlit(
            class_2960 atlasLocation,
            int x1,
            int x2,
            int y1,
            int y2,
            int blitOffset,
            float minU,
            float maxU,
            float minV,
            float maxV,
            float red,
            float green,
            float blue,
            float alpha
    ) {
        RenderSystem.setShaderTexture(0, atlasLocation);
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.enableBlend();
        class_1159 matrix4F = this.pose.method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        bufferBuilder.method_22918(matrix4F, (float)x1, (float)y1, (float)blitOffset).method_22915(red, green, blue, alpha).method_22913(minU, minV).method_1344();
        bufferBuilder.method_22918(matrix4F, (float)x1, (float)y2, (float)blitOffset).method_22915(red, green, blue, alpha).method_22913(minU, maxV).method_1344();
        bufferBuilder.method_22918(matrix4F, (float)x2, (float)y2, (float)blitOffset).method_22915(red, green, blue, alpha).method_22913(maxU, maxV).method_1344();
        bufferBuilder.method_22918(matrix4F, (float)x2, (float)y1, (float)blitOffset).method_22915(red, green, blue, alpha).method_22913(maxU, minV).method_1344();
        class_286.method_43433(bufferBuilder.method_1326());
        RenderSystem.disableBlend();
    }

    public void blitNineSliced(class_2960 resourceLocation, int i, int j, int k, int l, int m, int n, int o, int p, int q) {
        this.blitNineSliced(resourceLocation, i, j, k, l, m, m, m, m, n, o, p, q);
    }

    public void blitNineSliced(class_2960 resourceLocation, int i, int j, int k, int l, int m, int n, int o, int p, int q, int r) {
        this.blitNineSliced(resourceLocation, i, j, k, l, m, n, m, n, o, p, q, r);
    }

    public void blitNineSliced(class_2960 resourceLocation, int i, int j, int k, int l, int m, int n, int o, int p, int q, int r, int s, int t) {
        m = Math.min(m, k / 2);
        o = Math.min(o, k / 2);
        n = Math.min(n, l / 2);
        p = Math.min(p, l / 2);
        if (k == q && l == r) {
            this.blit(resourceLocation, i, j, s, t, k, l);
        } else if (l == r) {
            this.blit(resourceLocation, i, j, s, t, m, l);
            this.blitRepeating(resourceLocation, i + m, j, k - o - m, l, s + m, t, q - o - m, r);
            this.blit(resourceLocation, i + k - o, j, s + q - o, t, o, l);
        } else if (k == q) {
            this.blit(resourceLocation, i, j, s, t, k, n);
            this.blitRepeating(resourceLocation, i, j + n, k, l - p - n, s, t + n, q, r - p - n);
            this.blit(resourceLocation, i, j + l - p, s, t + r - p, k, p);
        } else {
            this.blit(resourceLocation, i, j, s, t, m, n);
            this.blitRepeating(resourceLocation, i + m, j, k - o - m, n, s + m, t, q - o - m, n);
            this.blit(resourceLocation, i + k - o, j, s + q - o, t, o, n);
            this.blit(resourceLocation, i, j + l - p, s, t + r - p, m, p);
            this.blitRepeating(resourceLocation, i + m, j + l - p, k - o - m, p, s + m, t + r - p, q - o - m, p);
            this.blit(resourceLocation, i + k - o, j + l - p, s + q - o, t + r - p, o, p);
            this.blitRepeating(resourceLocation, i, j + n, m, l - p - n, s, t + n, m, r - p - n);
            this.blitRepeating(resourceLocation, i + m, j + n, k - o - m, l - p - n, s + m, t + n, q - o - m, r - p - n);
            this.blitRepeating(resourceLocation, i + k - o, j + n, m, l - p - n, s + q - o, t + n, o, r - p - n);
        }
    }

    public void blitRepeating(class_2960 resourceLocation, int i, int j, int k, int l, int m, int n, int o, int p) {
        int q = i;
        IntIterator intIterator = slices(k, o);

        while (intIterator.hasNext()) {
            int r = intIterator.nextInt();
            int s = (o - r) / 2;
            int t = j;
            IntIterator intIterator2 = slices(l, p);

            while (intIterator2.hasNext()) {
                int u = intIterator2.nextInt();
                int v = (p - u) / 2;
                this.blit(resourceLocation, q, t, m + s, n + v, r, u);
                t += u;
            }

            q += r;
        }
    }

    private static IntIterator slices(int i, int j) {
        int k = class_3532.method_38788(i, j);
        return new Divisor(i, k);
    }

    /**
     * Renders an item stack at the specified coordinates.
     *
     * @param stack the item stack to render.
     * @param x the x-coordinate of the rendering position.
     * @param y the y-coordinate of the rendering position.
     */
    public void renderItem(class_1799 stack, int x, int y) {
        this.renderItem(this.minecraft.field_1724, this.minecraft.field_1687, stack, x, y, 0);
    }

    /**
     * Renders an item stack at the specified coordinates with a random seed.
     *
     * @param stack the item stack to render.
     * @param x the x-coordinate of the rendering position.
     * @param y the y-coordinate of the rendering position.
     * @param seed the random seed.
     */
    public void renderItem(class_1799 stack, int x, int y, int seed) {
        this.renderItem(this.minecraft.field_1724, this.minecraft.field_1687, stack, x, y, seed);
    }

    /**
     * Renders an item stack at the specified coordinates with a random seed and a custom value.
     *
     * @param stack the item stack to render.
     * @param x the x-coordinate of the rendering position.
     * @param y the y-coordinate of the rendering position.
     * @param seed the random seed.
     * @param guiOffset the GUI offset.
     */
    public void renderItem(class_1799 stack, int x, int y, int seed, int guiOffset) {
        this.renderItem(this.minecraft.field_1724, this.minecraft.field_1687, stack, x, y, seed, guiOffset);
    }

    /**
     * Renders a fake item stack at the specified coordinates.
     *
     * @param stack the fake item stack to render.
     * @param x the x-coordinate of the rendering position.
     * @param y the y-coordinate of the rendering position.
     */
    public void renderFakeItem(class_1799 stack, int x, int y) {
        this.renderItem(null, this.minecraft.field_1687, stack, x, y, 0);
    }

    /**
     * Renders an item stack for a living entity at the specified coordinates with a random seed.
     *
     * @param entity the living entity.
     * @param stack the item stack to render.
     * @param x the x-coordinate of the rendering position.
     * @param y the y-coordinate of the rendering position.
     * @param seed the random seed.
     */
    public void renderItem(class_1309 entity, class_1799 stack, int x, int y, int seed) {
        this.renderItem(entity, entity.field_6002, stack, x, y, seed);
    }

    /**
     * Renders an item stack for a living entity in a specific level at the specified coordinates with a random seed.
     *
     * @param entity the living entity. Can be null.
     * @param level the level in which the rendering occurs. Can be null.
     * @param stack the item stack to render.
     * @param x the x-coordinate of the rendering position.
     * @param y the y-coordinate of the rendering position.
     * @param seed the random seed.
     */
    private void renderItem(@Nullable class_1309 entity, @Nullable class_1937 level, class_1799 stack, int x, int y, int seed) {
        this.renderItem(entity, level, stack, x, y, seed, 0);
    }

    /**
     * Renders an item stack for a living entity in a specific level at the specified coordinates with a random seed and a custom GUI offset.
     *
     * @param entity the living entity. Can be null.
     * @param level the level in which the rendering occurs. Can be null.
     * @param stack the item stack to render.
     * @param x the x-coordinate of the rendering position.
     * @param y the y-coordinate of the rendering position.
     * @param seed the random seed.
     * @param guiOffset the GUI offset value.
     */
    private void renderItem(@Nullable class_1309 entity, @Nullable class_1937 level, class_1799 stack, int x, int y, int seed, int guiOffset) {
        if (!stack.method_7960()) {
            class_1087 bakedModel = this.minecraft.method_1480().method_4019(stack, level, entity, seed);
            this.pose.method_22903();
            this.pose.method_22904((float)(x + 8), (float)(y + 8), (float)(150 + (bakedModel.method_4712() ? guiOffset : 0)));

            try {
                this.pose.method_34425(new GuiMatrix4f().scaling(1.0F, -1.0F, 1.0F));
                this.pose.method_22905(16.0F, 16.0F, 16.0F);
                boolean bl = !bakedModel.method_24304();
                if (bl) {
                    class_308.method_24210();
                }
                this.minecraft
                        .method_1480()
                        .method_23179(stack, class_809.class_811.field_4317, false, this.pose, this.bufferSource(), 15728880, class_4608.field_21444, bakedModel);
                this.flush();
                if (bl) {
                    class_308.method_24211();
                }
            } catch (Throwable var12) {
                class_128 crashReport = class_128.method_560(var12, "Rendering item");
                class_129 crashReportCategory = crashReport.method_562("Item being rendered");
                crashReportCategory.method_577("Item Type", (class_133<String>)(() -> String.valueOf(stack.method_7909())));
                crashReportCategory.method_577("Item Damage", (class_133<String>)(() -> String.valueOf(stack.method_7919())));
                crashReportCategory.method_577("Item NBT", (class_133<String>)(() -> String.valueOf(stack.method_7969())));
                crashReportCategory.method_577("Item Foil", (class_133<String>)(() -> String.valueOf(stack.method_7958())));
                throw new class_148(crashReport);
            }

            this.pose.method_22909();
        }
    }

    /**
     * Renders additional decorations for an item stack at the specified coordinates.
     *
     * @param font the font used for rendering text.
     * @param stack the item stack to decorate.
     * @param x the x-coordinate of the rendering position.
     * @param y the y-coordinate of the rendering position.
     */
    public void renderItemDecorations(class_327 font, class_1799 stack, int x, int y) {
        this.renderItemDecorations(font, stack, x, y, null);
    }

    /**
     * Renders additional decorations for an item stack at the specified coordinates with optional custom text.
     *
     * @param font the font used for rendering text.
     * @param stack the item stack to decorate.
     * @param x the x-coordinate of the rendering position.
     * @param y the y-coordinate of the rendering position.
     * @param text the custom text to display. Can be null.
     */
    public void renderItemDecorations(class_327 font, class_1799 stack, int x, int y, @Nullable String text) {
        if (!stack.method_7960()) {
            this.pose.method_22903();
            if (stack.method_7947() != 1 || text != null) {
                String string = text == null ? String.valueOf(stack.method_7947()) : text;
                this.pose.method_22904(0.0F, 0.0F, 200.0F);
                this.drawString(font, string, x + 19 - 2 - font.method_1727(string), y + 6 + 3, 16777215, true);
            }

            if (stack.method_31578()) {
                int i = stack.method_31579();
                int j = stack.method_31580();
                int k = x + 2;
                int l = y + 13;
                this.fill(GuiRenderTypes.guiOverlay(), k, l, k + 13, l + 2, -16777216);
                this.fill(GuiRenderTypes.guiOverlay(), k, l, k + i, l + 1, j | 0xFF000000);
            }

            class_746 localPlayer = this.minecraft.field_1724;
            float f = localPlayer == null ? 0.0F : localPlayer.method_7357().method_7905(stack.method_7909(), this.minecraft.method_1488());
            if (f > 0.0F) {
                int k = y + class_3532.method_15375(16.0F * (1.0F - f));
                int l = k + class_3532.method_15386(16.0F * f);
                this.fill(GuiRenderTypes.guiOverlay(), x, k, x + 16, l, Integer.MAX_VALUE);
            }

            this.pose.method_22909();
        }
    }

    /**
     * Renders a tooltip for an item stack at the specified mouse coordinates.
     *
     * @param font the font used for rendering text.
     * @param stack the item stack to display the tooltip for.
     * @param mouseX the x-coordinate of the mouse position.
     * @param mouseY the y-coordinate of the mouse position.
     */
    public void renderTooltip(class_327 font, class_1799 stack, int mouseX, int mouseY) {
        this.renderTooltip(font, DUMMY_SCREEN.method_25408(stack), stack.method_32347(), mouseX, mouseY);
    }

    /**
     * Renders a tooltip with customizable components at the specified mouse coordinates.
     *
     * @param font the font used for rendering text.
     * @param tooltipLines the lines of the tooltip.
     * @param visualTooltipComponent the visual tooltip component. Can be empty.
     * @param mouseX the x-coordinate of the mouse position.
     * @param mouseY the y-coordinate of the mouse position.
     */
    public void renderTooltip(class_327 font, List<class_2561> tooltipLines, Optional<class_5632> visualTooltipComponent, int mouseX, int mouseY) {
        List<class_5684> list = (List<class_5684>)tooltipLines.stream()
                .map(class_2561::method_30937)
                .map(class_5684::method_32662)
                .collect(Collectors.toList());
        visualTooltipComponent.ifPresent(tooltipComponent -> list.add(1, class_5684.method_32663(tooltipComponent)));
        this.renderTooltipInternal(font, list, mouseX, mouseY, DefaultTooltipPositioner.INSTANCE);
    }

    /**
     * Renders a tooltip with a single line of text at the specified mouse coordinates.
     *
     * @param font the font used for rendering text.
     * @param text the text to display in the tooltip.
     * @param mouseX the x-coordinate of the mouse position.
     * @param mouseY the y-coordinate of the mouse position.
     */
    public void renderTooltip(class_327 font, class_2561 text, int mouseX, int mouseY) {
        this.renderTooltip(font, List.of(text.method_30937()), mouseX, mouseY);
    }

    /**
     * Renders a tooltip with multiple lines of component-based text at the specified mouse coordinates.
     *
     * @param font the font used for rendering text.
     * @param tooltipLines the lines of the tooltip as components.
     * @param mouseX the x-coordinate of the mouse position.
     * @param mouseY the y-coordinate of the mouse position.
     */
    public void renderComponentTooltip(class_327 font, List<class_2561> tooltipLines, int mouseX, int mouseY) {
        this.renderTooltip(font, Lists.transform(tooltipLines, class_2561::method_30937), mouseX, mouseY);
    }

    /**
     * Renders a tooltip with multiple lines of formatted text at the specified mouse coordinates.
     *
     * @param font the font used for rendering text.
     * @param tooltipLines the lines of the tooltip as formatted character sequences.
     * @param mouseX the x-coordinate of the mouse position.
     * @param mouseY the y-coordinate of the mouse position.
     */
    public void renderTooltip(class_327 font, List<? extends class_5481> tooltipLines, int mouseX, int mouseY) {
        this.renderTooltipInternal(
                font,
                (List<class_5684>)tooltipLines.stream().map(class_5684::method_32662).collect(Collectors.toList()),
                mouseX,
                mouseY,
                DefaultTooltipPositioner.INSTANCE
        );
    }

    /**
     * Renders a tooltip with multiple lines of formatted text using a custom tooltip positioner at the specified mouse coordinates.
     *
     * @param font the font used for rendering text.
     * @param tooltipLines the lines of the tooltip as formatted character sequences.
     * @param tooltipPositioner the positioner to determine the tooltip's position.
     * @param mouseX the x-coordinate of the mouse position.
     * @param mouseY the y-coordinate of the mouse position.
     */
    public void renderTooltip(class_327 font, List<class_5481> tooltipLines, ClientTooltipPositioner tooltipPositioner, int mouseX, int mouseY) {
        this.renderTooltipInternal(
                font,
                (List<class_5684>)tooltipLines.stream().map(class_5684::method_32662).collect(Collectors.toList()),
                mouseX,
                mouseY,
                tooltipPositioner
        );
    }

    /**
     * Renders an internal tooltip with customizable tooltip components at the specified mouse coordinates using a tooltip positioner.
     *
     * @param font the font used for rendering text.
     * @param components the tooltip components to render.
     * @param mouseX the x-coordinate of the mouse position.
     * @param mouseY the y-coordinate of the mouse position.
     * @param tooltipPositioner the positioner to determine the tooltip's position.
     */
    private void renderTooltipInternal(class_327 font, List<class_5684> components, int mouseX, int mouseY, ClientTooltipPositioner tooltipPositioner) {
        if (!components.isEmpty()) {
            int i = 0;
            int j = components.size() == 1 ? -2 : 0;

            for (class_5684 clientTooltipComponent : components) {
                int k = clientTooltipComponent.method_32664(font);
                if (k > i) {
                    i = k;
                }

                j += clientTooltipComponent.method_32661();
            }

            int l = i;
            int m = j;
            Vector2ic vector2ic = tooltipPositioner.positionTooltip(this.guiWidth(), this.guiHeight(), mouseX, mouseY, l, m);
            int n = vector2ic.x();
            int o = vector2ic.y();
            this.pose.method_22903();
            int p = 400;
            this.drawManaged(() -> TooltipRenderUtil.renderTooltipBackground(this, n, o, l, m, 400));
            this.pose.method_22904(0.0F, 0.0F, 400.0F);
            int q = o;

            for (int r = 0; r < components.size(); r++) {
                class_5684 clientTooltipComponent2 = (class_5684)components.get(r);
                clientTooltipComponent2.method_32665(font, n, q, this.pose.method_23760().method_23761(), this.bufferSource);
                q += clientTooltipComponent2.method_32661() + (r == 0 ? 2 : 0);
            }

            q = o;

            for (int r = 0; r < components.size(); r++) {
                class_5684 clientTooltipComponent2 = (class_5684)components.get(r);
                clientTooltipComponent2.method_32666(font, n, q, this.pose, class_310.method_1551().method_1480(), 400);
                q += clientTooltipComponent2.method_32661() + (r == 0 ? 2 : 0);
            }

            this.pose.method_22909();
        }
    }

    /**
     * Renders a hover effect for a text component at the specified mouse coordinates.
     *
     * @param font the font used for rendering text.
     * @param style the style of the text component. Can be null.
     * @param mouseX the x-coordinate of the mouse position.
     * @param mouseY the y-coordinate of the mouse position.
     */
    public void renderComponentHoverEffect(class_327 font, @Nullable class_2583 style, int mouseX, int mouseY) {
        if (style != null && style.method_10969() != null) {
            class_2568 hoverEvent = style.method_10969();
            class_2568.class_5249 itemStackInfo = hoverEvent.method_10891(class_2568.class_5247.field_24343);
            if (itemStackInfo != null) {
                this.renderTooltip(font, itemStackInfo.method_27683(), mouseX, mouseY);
            } else {
                class_2568.class_5248 entityTooltipInfo = hoverEvent.method_10891(class_2568.class_5247.field_24344);
                if (entityTooltipInfo != null) {
                    if (this.minecraft.field_1690.field_1827) {
                        this.renderComponentTooltip(font, entityTooltipInfo.method_27682(), mouseX, mouseY);
                    }
                } else {
                    class_2561 component = hoverEvent.method_10891(class_2568.class_5247.field_24342);
                    if (component != null) {
                        this.renderTooltip(font, font.method_1728(component, Math.max(this.guiWidth() / 2, 200)), mouseX, mouseY);
                    }
                }
            }
        }
    }

    /**
     * A utility class for managing a stack of screen rectangles for scissoring.
     */
    public static class ScissorStack {

        private final Deque<ScreenRectangle> stack = new ArrayDeque<>();

        /**
         * Pushes a screen rectangle onto the scissor stack.
         * <p>
         * @return The resulting intersection of the pushed rectangle with the previous top rectangle on the stack, or the pushed rectangle if the stack is empty.
         *
         * @param scissor the screen rectangle to push.
         */
        public ScreenRectangle push(ScreenRectangle scissor) {
            ScreenRectangle screenRectangle = (ScreenRectangle)this.stack.peekLast();
            if (screenRectangle != null) {
                ScreenRectangle screenRectangle2 = (ScreenRectangle)Objects.requireNonNullElse(scissor.intersection(screenRectangle), ScreenRectangle.empty());
                this.stack.addLast(screenRectangle2);
                return screenRectangle2;
            } else {
                this.stack.addLast(scissor);
                return scissor;
            }
        }

        /**
         * Pops the top screen rectangle from the scissor stack.
         * <p>
         * @return The new top screen rectangle after the pop operation, or null if the stack is empty.
         * @throws IllegalStateException if the stack is empty.
         */
        @Nullable
        public ScreenRectangle pop() {
            if (this.stack.isEmpty()) {
                throw new IllegalStateException("Scissor stack underflow");
            } else {
                this.stack.removeLast();
                return (ScreenRectangle)this.stack.peekLast();
            }
        }

    }

}
