package de.keksuccino.fancymenu.util.rendering.gui;

import java.util.List;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6383;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.rendering.text.TextFormattingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.widget.WidgetWithVanillaTooltip;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaTooltip implements class_6383 {

    private static final int MAX_WIDTH = 170;

    private final class_2561 message;
    @Nullable
    private List<class_5481> cachedTooltip;
    @Nullable
    private class_2477 splitWithLanguage;
    @Nullable
    private final class_2561 narration;
    @Nullable
    private List<class_5250> cachedTooltipComponents;

    private VanillaTooltip(class_2561 message, @Nullable class_2561 narration) {
        this.message = message;
        this.narration = narration;
    }

    public static VanillaTooltip create(class_2561 message, @Nullable class_2561 narration) {
        return new VanillaTooltip(message, narration);
    }

    public static VanillaTooltip create(class_2561 message) {
        return new VanillaTooltip(message, message);
    }

    @Override
    public void method_37020(@NotNull class_6382 narrationElementOutput) {
        if (this.narration != null) {
            narrationElementOutput.method_37034(class_6381.field_33790, this.narration);
        }
    }

    public List<class_5250> toComponentList(class_310 minecraft) {
        class_2477 language = class_2477.method_10517();
        if (this.cachedTooltipComponents == null || language != this.splitWithLanguage) {
            this.cachedTooltipComponents = TextFormattingUtils.lineWrapComponents(this.message, MAX_WIDTH);
            this.splitWithLanguage = language;
        }
        return this.cachedTooltipComponents;
    }

    public List<class_5481> toCharSequence(class_310 minecraft) {
        class_2477 language = class_2477.method_10517();
        if (this.cachedTooltip == null || language != this.splitWithLanguage) {
            this.cachedTooltip = splitTooltip(minecraft, this.message);
            this.splitWithLanguage = language;
        }
        return this.cachedTooltip;
    }

    public static List<class_5481> splitTooltip(class_310 minecraft, class_2561 message) {
        return minecraft.field_1772.method_1728(message, MAX_WIDTH);
    }

    public static void renderScreenTooltips(@NotNull class_437 screen, @NotNull class_4587 pose, int mouseX, int mouseY, float partial) {
        for (class_364 listener : screen.method_25396()) {
            if ((listener instanceof WidgetWithVanillaTooltip l) && (listener instanceof class_339 w)) {
                if (!w.field_22764 || !((IMixinAbstractWidget)w).getIsHoveredFancyMenu()) continue;
                VanillaTooltip t = l.getVanillaTooltip_FancyMenu();
                if (t != null) {
                    screen.method_25417(pose, t.toCharSequence(class_310.method_1551()), mouseX, mouseY);
                    return;
                }
            }
        }
    }

}
