package de.keksuccino.fancymenu.util.rendering.ui.screen;

import java.util.List;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

/**
 * Gets applied to the {@link class_437} class to add helper methods for easier customization.
 */
public interface CustomizableScreen {

    /**
     * Every widget that gets added to the {@link class_437#method_25396()}, {@link class_437#renderables} and {@link class_437#narratables} lists and should,
     * under any circumstances, get removed from said lists before resizing/re-initializing the {@link class_437} (because they get rebuild on init/resize,
     * even if the {@link class_437} does not clear its child list) should get added to this list.
     */
    @NotNull
    List<class_364> removeOnInitChildrenFancyMenu();

    boolean isScreenInitialized_FancyMenu();

}
