package de.keksuccino.fancymenu.util.rendering.ui.screen.queueable;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.input.InputConstants;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import org.jetbrains.annotations.NotNull;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5481;

public class QueueableNotificationScreen extends QueueableScreen {

    @NotNull
    protected class_2561 text;
    protected List<class_5481> renderText;

    public QueueableNotificationScreen(@NotNull class_2561 text) {
        super(class_2561.method_43473());
        this.text = text;
    }

    @Override
    protected void method_25426() {

        int centerX = this.field_22789 / 2;

        super.method_25426();

        this.renderText = this.field_22793.method_1728(this.text, this.field_22789 - 60);

        UIBase.applyDefaultWidgetSkinTo(this.method_37063(new ExtendedButton(centerX - 100, this.field_22790 - 50, 200, 20, class_2561.method_43471("fancymenu.common_components.ok"), button -> {
            this.method_25419();
        })));

    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {

        super.render(graphics, mouseX, mouseY, partial);

        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;

        if (this.renderText == null) return;

        // Calculate the total height of all text lines
        int lineHeight = this.field_22793.field_2000 + 2; // Add 2 pixels of spacing between lines
        int totalTextHeight = this.renderText.size() * lineHeight;
        
        // Start rendering from the top of the centered text block
        int renderY = centerY - (totalTextHeight / 2);
        
        for (class_5481 s : this.renderText) {
            graphics.drawCenteredString(this.field_22793, s, centerX, renderY, UIBase.getUIColorTheme().generic_text_base_color.getColorInt());
            renderY += lineHeight;
        }

    }

    @Override
    public void renderBackground(@NotNull GuiGraphics graphics) {
        RenderSystem.enableBlend();
        graphics.fill(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());
    }

    @Override
    public boolean method_25404(int key, int scancode, int modifiers) {

        if ((key == InputConstants.KEY_ENTER) || (key == InputConstants.field_31980)) {
            this.method_25419();
            return true;
        }

        return super.method_25404(key, scancode, modifiers);

    }

}
