package de.keksuccino.fancymenu.util.rendering.ui.widget.editbox;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinEditBox;
import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.VanillaTooltip;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.UniqueWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.WidgetWithVanillaTooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.FancyMenuWidget;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_757;

@SuppressWarnings("unused")
public class ExtendedEditBox extends class_342 implements UniqueWidget, NavigatableWidget, FancyMenuWidget, WidgetWithVanillaTooltip {

    private static final Logger LOGGER = LogManager.getLogger();

    protected CharacterFilter characterFilter;
    protected CharacterRenderFormatter characterRenderFormatter;
    protected DrawableColor backgroundColor = DrawableColor.of(new Color(0, 0, 0));
    protected DrawableColor borderNormalColor = DrawableColor.of(new Color(-6250336));
    protected DrawableColor borderFocusedColor = DrawableColor.of(new Color(255, 255, 255));
    protected DrawableColor textColor = DrawableColor.of(new Color(14737632));
    protected DrawableColor textColorUneditable = DrawableColor.of(new Color(7368816));
    protected DrawableColor suggestionTextColor = DrawableColor.of(new Color(-8355712));
    protected boolean textShadow = true;
    protected final class_327 font;
    @Nullable
    protected String identifier;
    protected boolean focusable = true;
    protected boolean navigatable = true;
    protected boolean canConsumeUserInput = true;
    @Nullable
    protected String inputPrefix;
    @Nullable
    protected String inputSuffix;
    protected boolean deleteAllAllowed = true;
    @Nullable
    protected ConsumingSupplier<ExtendedEditBox, Boolean> isActiveSupplier = null;
    @Nullable
    protected ConsumingSupplier<ExtendedEditBox, Boolean> isVisibleSupplier = null;
    @Nullable
    protected Supplier<Tooltip> customTooltip;
    protected boolean forceDefaultTooltipStyle = true;
    @Nullable
    protected ConsumingSupplier<ExtendedEditBox, class_2561> hintFancymenu = null;
    @Nullable
    protected VanillaTooltip vanillaTooltip;

    public ExtendedEditBox(class_327 font, int x, int y, int width, int height, class_2561 narrationMessage) {
        super(font, x, y, width, height, narrationMessage);
        this.font = font;
    }

    public ExtendedEditBox(class_327 font, int x, int y, int width, int height, @Nullable class_342 editBox, class_2561 narrationMessage) {
        super(font, x, y, width, height, editBox, narrationMessage);
        this.font = font;
    }

    public int getX() {
        return this.field_22760;
    }

    public void method_16872(int x) {
        this.field_22760 = x;
    }

    public int getY() {
        return this.field_22761;
    }

    public void setY(int y) {
        this.field_22761 = y;
    }

    public void method_25358(int width) {
        this.field_22758 = width;
    }

    public void setHeight(int height) {
        this.field_22759 = height;
    }

    @Override
    public void method_25359(@NotNull class_4587 pose, int mouseX, int mouseY, float partial) {

        GuiGraphics graphics = GuiGraphics.currentGraphics();
        IMixinEditBox access = ((IMixinEditBox)this);
        boolean bordered = access.getBorderedFancyMenu();

        if (this.method_1885()) {

            graphics.fill(this.getX(), this.getY(), this.getX() + this.field_22758, this.getY() + this.field_22759, this.backgroundColor.getColorInt());
            if (bordered) {
                int borderColor = this.method_25370() ? this.borderFocusedColor.getColorInt() : this.borderNormalColor.getColorInt();
                UIBase.renderBorder(graphics, this.getX() - 1, this.getY() - 1, this.getX() + this.field_22758 + 1, this.getY() + this.field_22759 + 1, 1, borderColor, true, true, true, true);
            }

            int textColor = access.getIsEditableFancyMenu() ? this.textColor.getColorInt() : this.textColorUneditable.getColorInt();
            int cursorPos = this.method_1881() - access.getDisplayPosFancyMenu();
            int highlightPos = access.getHighlightPosFancyMenu() - access.getDisplayPosFancyMenu();
            String text = this.font.method_27523(this.method_1882().substring(access.getDisplayPosFancyMenu()), this.method_1859());
            boolean isCursorInsideVisibleText = cursorPos >= 0 && cursorPos <= text.length();
            boolean isCursorVisible = this.method_25370() && access.getFrameFancyMenu() / 6 % 2 == 0 && isCursorInsideVisibleText;
            int textX = bordered ? this.getX() + 4 : this.getX();
            int textY = bordered ? this.getY() + (this.field_22759 - 8) / 2 : this.getY();
            int textXAfterCursor = textX;
            if (highlightPos > text.length()) {
                highlightPos = text.length();
            }

            int textCharacterRenderIndex = access.getDisplayPosFancyMenu();

            if (!text.isEmpty()) {
                String textBeforeCursor = isCursorInsideVisibleText ? text.substring(0, cursorPos) : text;
                class_5250 beforeCursorComp = class_2561.method_43470("");
                if (this.characterRenderFormatter == null) {
                    beforeCursorComp = class_2561.method_43470(textBeforeCursor);
                } else {
                    for (char c : textBeforeCursor.toCharArray()) {
                        class_5250 comp = this.characterRenderFormatter.formatComponent(this, class_2561.method_43470(String.valueOf(c)), textCharacterRenderIndex, c, text, this.method_1882());
                        beforeCursorComp.method_10852(comp);
                        textCharacterRenderIndex++;
                    }
                }
                textXAfterCursor = graphics.drawString(this.font, beforeCursorComp, textX, textY, textColor, this.textShadow);
            }

            boolean renderSmallCursor = (this.method_1881() < this.method_1882().length()) || (this.method_1882().length() >= access.getMaxLengthFancyMenu());
            int finalTextXAfterCursor = textXAfterCursor;
            if (!isCursorInsideVisibleText) {
                finalTextXAfterCursor = (cursorPos > 0) ? (textX + this.field_22758) : textX;
            } else if (renderSmallCursor) {
                finalTextXAfterCursor = textXAfterCursor - 1;
                if (this.textShadow) --textXAfterCursor;
            }

            if (!text.isEmpty() && isCursorInsideVisibleText && cursorPos < text.length()) {
                String textAfterCursor = text.substring(cursorPos);
                class_5250 afterCursorComp = class_2561.method_43470("");
                if (this.characterRenderFormatter == null) {
                    afterCursorComp = class_2561.method_43470(textAfterCursor);
                } else {
                    for (char c : textAfterCursor.toCharArray()) {
                        class_5250 comp = this.characterRenderFormatter.formatComponent(this, class_2561.method_43470(String.valueOf(c)), textCharacterRenderIndex, c, text, this.method_1882());
                        afterCursorComp.method_10852(comp);
                        textCharacterRenderIndex++;
                    }
                }
                graphics.drawString(this.font, afterCursorComp, textXAfterCursor, textY, textColor, this.textShadow);
            }

            // FancyMenu's Custom Hint Implementation
            class_2561 hintFm = this.getHintFancyMenu();
            if ((hintFm != null) && text.isEmpty()) {
                graphics.enableScissor(this.getX(), this.getY(), this.getX() + this.method_25368(), this.getY() + this.method_25364());
                graphics.drawString(this.font, hintFm, this.getX() + 4, this.getY() + (this.method_25364() / 2) - (this.font.field_2000 / 2), -1, false);
                graphics.disableScissor();
            }

            if (!renderSmallCursor && access.getSuggestionFancyMenu() != null) {
                graphics.drawString(this.font, access.getSuggestionFancyMenu(), (finalTextXAfterCursor - 1), textY, this.suggestionTextColor.getColorInt(), this.textShadow);
            }

            if (isCursorVisible) {
                if (renderSmallCursor) {
                    graphics.fill(finalTextXAfterCursor, textY - 1, finalTextXAfterCursor + 1, textY + 1 + 9, textColor);
                } else {
                    graphics.fill(finalTextXAfterCursor, textY + this.font.field_2000 - 2, finalTextXAfterCursor + 5, textY + this.font.field_2000 - 1, textColor);
                }
            }

            if (highlightPos != cursorPos) {
                int l1 = textX + this.font.method_1727(text.substring(0, highlightPos));
                this.renderHighlight(graphics, finalTextXAfterCursor, textY - 1, l1 - 1, textY + 1 + 9);
            }

            graphics.flush();

        }

    }

    protected void renderHighlight(@NotNull GuiGraphics graphics, int x1, int y1, int x2, int y2) {

        int left = Math.min(x1, x2);
        int right = Math.max(x1, x2);
        int top = Math.min(y1, y2);
        int bottom = Math.max(y1, y2);

        if (right > this.field_22760 + this.field_22758) {
            right = this.field_22760 + this.field_22758;
        }

        if (left > this.field_22760 + this.field_22758) {
            left = this.field_22760 + this.field_22758;
        }

        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34539);
        graphics.setColor(0.0F, 0.0F, 1.0F, 1.0F);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp(GlStateManager.class_1030.field_5110);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        buffer.method_22912(left, bottom, 0.0).method_1344();
        buffer.method_22912(right, bottom, 0.0).method_1344();
        buffer.method_22912(right, top, 0.0).method_1344();
        buffer.method_22912(left, top, 0.0).method_1344();
        tesselator.method_1350();
        graphics.setColor(1.0F, 1.0F, 1.0F, 1.0F);
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();

    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {

        if (this.isActiveSupplier != null) this.field_22763 = this.isActiveSupplier.get(this);

        if (this.isVisibleSupplier != null) this.field_22764 = this.isVisibleSupplier.get(this);

        super.method_25394(graphics.pose(), mouseX, mouseY, partial);

        if ((this.customTooltip != null) && this.field_22764 && this.isHovered()) {
            Tooltip tt = this.customTooltip.get();
            if (tt != null) {
                if (this.forceDefaultTooltipStyle) {
                    tt.setDefaultStyle();
                }
                TooltipHandler.INSTANCE.addTooltip(tt, () -> true, true, true);
            }
        }

    }

    @Deprecated
    @Override
    public void method_25394(@NotNull class_4587 pose, int mouseX, int mouseY, float partial) {
        this.render(GuiGraphics.currentGraphics(), mouseX, mouseY, partial);
    }

    public int getDisplayPosition() {
        return ((IMixinEditBox)this).getDisplayPosFancyMenu();
    }

    public void setDisplayPosition(int position) {
        ((IMixinEditBox)this).setDisplayPosFancyMenu(position);
    }

    public int getHighlightPosition() {
        return ((IMixinEditBox)this).getHighlightPosFancyMenu();
    }

    public @Nullable CharacterFilter getCharacterFilter() {
        return this.characterFilter;
    }

    public ExtendedEditBox setCharacterFilter(@Nullable CharacterFilter characterFilter) {
        this.characterFilter = characterFilter;
        return this;
    }

    @NotNull
    public ExtendedEditBox setDeleteAllAllowed(boolean allowed) {
        this.deleteAllAllowed = allowed;
        return this;
    }

    public boolean isDeleteAllAllowed() {
        return this.deleteAllAllowed;
    }

    public boolean hasTextShadow() {
        return this.textShadow;
    }

    public ExtendedEditBox setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
        return this;
    }

    @NotNull
    public DrawableColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public ExtendedEditBox setBackgroundColor(@NotNull DrawableColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @NotNull
    public DrawableColor getBorderNormalColor() {
        return borderNormalColor;
    }

    public ExtendedEditBox setBorderNormalColor(@NotNull DrawableColor borderNormalColor) {
        this.borderNormalColor = borderNormalColor;
        return this;
    }

    @NotNull
    public DrawableColor getBorderFocusedColor() {
        return this.borderFocusedColor;
    }

    public ExtendedEditBox setBorderFocusedColor(@NotNull DrawableColor borderFocusedColor) {
        this.borderFocusedColor = borderFocusedColor;
        return this;
    }

    @Nullable
    public ExtendedEditBox.CharacterRenderFormatter getCharacterRenderFormatter() {
        return this.characterRenderFormatter;
    }

    public ExtendedEditBox setCharacterRenderFormatter(@Nullable ExtendedEditBox.CharacterRenderFormatter characterRenderFormatter) {
        this.characterRenderFormatter = characterRenderFormatter;
        return this;
    }

    @NotNull
    public DrawableColor getTextColor() {
        return this.textColor;
    }

    public ExtendedEditBox setTextColor(@NotNull DrawableColor textColor) {
        this.textColor = textColor;
        return this;
    }

    @NotNull
    public DrawableColor getTextColorUneditable() {
        return this.textColorUneditable;
    }

    public ExtendedEditBox setTextColorUneditable(@NotNull DrawableColor textColorUneditable) {
        this.textColorUneditable = textColorUneditable;
        return this;
    }

    @NotNull
    public DrawableColor getSuggestionTextColor() {
        return this.suggestionTextColor;
    }

    public ExtendedEditBox setSuggestionTextColor(@NotNull DrawableColor suggestionTextColor) {
        this.suggestionTextColor = suggestionTextColor;
        return this;
    }

    public boolean canConsumeUserInput() {
        return this.canConsumeUserInput;
    }

    public ExtendedEditBox setCanConsumeUserInput(boolean canConsumeUserInput) {
        this.canConsumeUserInput = canConsumeUserInput;
        return this;
    }

    public @Nullable String getInputPrefix() {
        return inputPrefix;
    }

    public ExtendedEditBox setInputPrefix(@Nullable String inputPrefix) {
        this.inputPrefix = inputPrefix;
        this.method_1852(this.getValueWithoutPrefixSuffix());
        return this;
    }

    public @Nullable String getInputSuffix() {
        return inputSuffix;
    }

    public ExtendedEditBox setInputSuffix(@Nullable String inputSuffix) {
        this.inputSuffix = inputSuffix;
        this.method_1852(this.getValueWithoutPrefixSuffix());
        return this;
    }

    public ExtendedEditBox applyInputPrefixSuffixCharacterRenderFormatter() {
        this.setCharacterRenderFormatter((editBox, component, characterIndex, character, visiblePartOfLine, fullLine) -> {
            if ((this.inputSuffix != null) && (characterIndex > Math.max(0, (editBox.method_1882().length() - this.inputSuffix.length())-1))) {
                component.method_27696(class_2583.field_24360.method_36139(this.getTextColorUneditable().getColorInt()));
            }
            if ((this.inputPrefix != null) && (characterIndex < this.inputPrefix.length())) {
                component.method_27696(class_2583.field_24360.method_36139(this.getTextColorUneditable().getColorInt()));
            }
            return component;
        });
        return this;
    }

    public void setIsActiveSupplier(@Nullable ConsumingSupplier<ExtendedEditBox, Boolean> isActiveSupplier) {
        this.isActiveSupplier = isActiveSupplier;
    }

    public void setIsVisibleSupplier(@Nullable ConsumingSupplier<ExtendedEditBox, Boolean> isVisibleSupplier) {
        this.isVisibleSupplier = isVisibleSupplier;
    }

    @Deprecated
    @Override
    public void method_1868(int color) {
        this.textColor = DrawableColor.of(new Color(color));
    }

    @Deprecated
    @Override
    public void method_1860(int color) {
        this.textColorUneditable = DrawableColor.of(new Color(color));
    }

    @Override
    public void method_1852(@NotNull String value) {
        String v = this.getWithoutPrefixSuffix(value);
        if (this.inputPrefix != null) v = this.inputPrefix + v;
        if (this.inputSuffix != null) v = v + this.inputSuffix;
        super.method_1852(v);
    }

    @Override
    public boolean method_25400(char character, int modifiers) {
        if ((this.characterFilter != null) && !this.characterFilter.isAllowedChar(character)) {
            return false;
        }
        return super.method_25400(character, modifiers);
    }

    @Override
    public void method_1867(@NotNull String textToWrite) {
        if (this.isInPrefixSuffix(this.method_1881(), 0, 0)) return;
        if (this.isInPrefixSuffix(this.getHighlightPosition(), 0, 0)) return;
        if (this.characterFilter != null) {
            textToWrite = this.characterFilter.filterForAllowedChars(textToWrite);
        }
        super.method_1867(textToWrite);
    }

    @Override
    public void method_1878(int i) {
        if (this.isInPrefixSuffix(this.method_1881(), -1, -1) || this.isInPrefixSuffix(this.method_1881(), 0, 0)) return;
        if (this.isInPrefixSuffix(this.getHighlightPosition(), 0, 0)) return;
        super.method_1878(i);
    }

    @SuppressWarnings("all")
    public boolean isInPrefixSuffix(int index, int prefixIndexOffset, int suffixIndexOffset) {
        int cursorPrefix = index + prefixIndexOffset;
        int cursorSuffix = index + suffixIndexOffset;
        if (this.inputPrefix != null) {
            if (cursorPrefix < this.inputPrefix.length()) return true;
        }
        if (this.inputSuffix != null) {
            int i = (this.inputPrefix != null) ? this.inputPrefix.length() + this.getValueWithoutPrefixSuffix().length() : this.getValueWithoutPrefixSuffix().length();
            if (cursorSuffix > i) return true;
        }
        return false;
    }

    public String getValueWithoutPrefixSuffix() {
        return this.getWithoutPrefixSuffix(this.method_1882());
    }

    protected String getWithoutPrefixSuffix(@NotNull String value) {
        if (value.isEmpty()) return value;
        boolean containsPrefix = (this.inputPrefix != null) && value.startsWith(this.inputPrefix);
        boolean containsSuffix = (this.inputSuffix != null) && value.endsWith(this.inputSuffix);
        String v = containsPrefix ? value.substring(this.inputPrefix.length()) : value;
        if (containsSuffix) v = v.substring(0, Math.max(0, v.length() - this.inputSuffix.length()));
        return v;
    }

    @Override
    public void method_16873(int i) {
        if (this.deleteAllAllowed) {
            super.method_16873(i);
        } else {
            this.method_1878(i);
        }
    }

    @Override
    public boolean method_25404(int keycode, int scancode, int modifiers) {
        if (!this.canConsumeUserInput) return false;
        //If select all, only select parts that are not prefix or suffix
        if (class_437.method_25439(keycode) && ((this.inputPrefix != null) || (this.inputSuffix != null))) {
            if (this.inputSuffix != null) {
                this.method_1883(this.method_1882().length() - this.inputSuffix.length());
            } else {
                this.method_1872();
            }
            this.method_1884((this.inputPrefix != null) ? this.inputPrefix.length() : 0);
            return true;
        }
        return super.method_25404(keycode, scancode, modifiers);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.canConsumeUserInput) return false;
        return super.method_25402(mouseX, mouseY, button);
    }

    //This is to make the edit box work in FocuslessEventHandlers
    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        return false;
    }

    @Override
    public ExtendedEditBox setWidgetIdentifierFancyMenu(@Nullable String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    public @Nullable String getWidgetIdentifierFancyMenu() {
        return this.identifier;
    }

    @Override
    public void method_25365(boolean focused) {
        if (!this.focusable) {
            super.method_25365(false);
            return;
        }
        super.method_25365(focused);
    }

    @Override
    public boolean method_25370() {
        if (!this.focusable) return false;
        return super.method_25370();
    }

    @Override
    public boolean isFocusable() {
        return this.focusable;
    }

    @Override
    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    @Override
    public boolean isNavigatable() {
        return this.navigatable;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
        this.navigatable = navigatable;
    }

    @NotNull
    public ExtendedEditBox setTooltip(@Nullable Supplier<Tooltip> tooltip) {
        this.customTooltip = tooltip;
        return this;
    }

    public boolean isForceDefaultTooltipStyle() {
        return forceDefaultTooltipStyle;
    }

    public void setForceDefaultTooltipStyle(boolean forceDefaultTooltipStyle) {
        this.forceDefaultTooltipStyle = forceDefaultTooltipStyle;
    }

    @NotNull
    public ExtendedEditBox setHintFancyMenu(@Nullable ConsumingSupplier<ExtendedEditBox, class_2561> hint) {
        this.hintFancymenu = hint;
        return this;
    }

    @Nullable
    protected class_5250 getHintFancyMenu() {
        if (this.hintFancymenu == null) return null;
        class_2561 c = this.hintFancymenu.get(this);
        if (c != null) {
            return c.method_27661().method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().edit_box_text_color_uneditable.getColorInt()));
        }
        return null;
    }

    public boolean isHovered() {
        return this.field_22762;
    }

    @Override
    public @Nullable VanillaTooltip getVanillaTooltip_FancyMenu() {
        return this.vanillaTooltip;
    }

    @Override
    public void setVanillaTooltip_FancyMenu(@Nullable VanillaTooltip tooltip) {
        this.vanillaTooltip = tooltip;
    }

    @FunctionalInterface
    public interface CharacterRenderFormatter {
        @NotNull class_5250 formatComponent(@NotNull ExtendedEditBox editBox, @NotNull class_5250 component, int characterIndex, char character, @NotNull String visiblePartOfLine, @NotNull String fullLine);
    }

}