package de.keksuccino.fancymenu.util.resource;

import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RenderableResource extends Resource {

    public static final class_2960 MISSING_TEXTURE_LOCATION = class_1060.field_5285;
    public static final class_2960 FULLY_TRANSPARENT_TEXTURE = new class_2960("fancymenu", "textures/fully_transparent.png");

    /**
     * Some resource types asynchronously update their current {@link class_2960},
     * so make sure to always cache the location returned by this method before using it.
     */
    @Nullable class_2960 getResourceLocation();

    int getWidth();

    int getHeight();

    @NotNull AspectRatio getAspectRatio();

    void reset();

}
