/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.image;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.elements.image.ImageEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.image.ImageElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageElementBuilder
extends ElementBuilder<ImageElement, ImageEditorElement> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ImageElementBuilder() {
        super("image");
    }

    @Override
    @NotNull
    public ImageElement buildDefaultInstance() {
        ImageElement i = new ImageElement(this);
        i.baseWidth = 100;
        i.baseHeight = 100;
        return i;
    }

    @Override
    public ImageElement deserializeElement(@NotNull SerializedElement serialized) {
        ImageElement element = this.buildDefaultInstance();
        element.textureSupplier = ImageElementBuilder.deserializeImageResourceSupplier(serialized.getValue("source"));
        element.repeat = this.deserializeBoolean(element.repeat, serialized.getValue("repeat_texture"));
        element.nineSlice = this.deserializeBoolean(element.nineSlice, serialized.getValue("nine_slice_texture"));
        element.nineSliceBorderX = this.deserializeNumber(Integer.class, element.nineSliceBorderX, serialized.getValue("nine_slice_texture_border_x"));
        element.nineSliceBorderY = this.deserializeNumber(Integer.class, element.nineSliceBorderY, serialized.getValue("nine_slice_texture_border_y"));
        element.restartAnimatedOnMenuLoad = this.deserializeBoolean(element.restartAnimatedOnMenuLoad, serialized.getValue("restart_animated_on_menu_load"));
        element.imageTint = Objects.requireNonNullElse(serialized.getValue("image_tint"), element.imageTint);
        return element;
    }

    @Override
    protected SerializedElement serializeElement(@NotNull ImageElement element, @NotNull SerializedElement serializeTo) {
        if (element.textureSupplier != null) {
            serializeTo.putProperty("source", element.textureSupplier.getSourceWithPrefix());
        }
        serializeTo.putProperty("repeat_texture", "" + element.repeat);
        serializeTo.putProperty("nine_slice_texture", "" + element.nineSlice);
        serializeTo.putProperty("nine_slice_texture_border_x", "" + element.nineSliceBorderX);
        serializeTo.putProperty("nine_slice_texture_border_y", "" + element.nineSliceBorderY);
        serializeTo.putProperty("image_tint", element.imageTint);
        serializeTo.putProperty("restart_animated_on_menu_load", "" + element.restartAnimatedOnMenuLoad);
        return serializeTo;
    }

    @Override
    @NotNull
    public ImageEditorElement wrapIntoEditorElement(@NotNull ImageElement element, @NotNull LayoutEditorScreen editor) {
        return new ImageEditorElement(element, editor);
    }

    @Override
    @NotNull
    public Component getDisplayName(@Nullable AbstractElement element) {
        return Component.m_237115_((String)"fancymenu.elements.image");
    }

    @Override
    @Nullable
    public Component[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines("fancymenu.elements.image.desc", new String[0]);
    }
}

