/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.packets.commands.layout.command.LayoutCommandPacket;
import de.keksuccino.fancymenu.util.CommandUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class LayoutCommand {
    public static final Map<String, List<String>> CACHED_LAYOUT_SUGGESTIONS = Collections.synchronizedMap(new HashMap());

    public static void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)Commands.literal((String)"fmlayout").then(Commands.argument((String)"layout_name", (ArgumentType)StringArgumentType.string()).suggests((context, provider) -> CommandUtils.buildStringSuggestionsList((CommandContext<CommandSourceStack>)context, LayoutCommand.getLayoutNameSuggestions(((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(((RequiredArgumentBuilder)Commands.argument((String)"is_layout_enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> LayoutCommand.setLayoutState((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"layout_name"), BoolArgumentType.getBool((CommandContext)context, (String)"is_layout_enabled"), null))).then(((RequiredArgumentBuilder)Commands.argument((String)"target_players", (ArgumentType)EntityArgument.players()).requires(context -> context.hasPermission(2))).executes(context -> LayoutCommand.setLayoutState((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"layout_name"), BoolArgumentType.getBool((CommandContext)context, (String)"is_layout_enabled"), EntityArgument.getPlayers((CommandContext)context, (String)"target_players")))))));
    }

    private static String[] getLayoutNameSuggestions(ServerPlayer sender) {
        ArrayList<String> l = new ArrayList<String>(Objects.requireNonNullElse(CACHED_LAYOUT_SUGGESTIONS.get(sender.getUUID().toString()), new ArrayList()));
        if (l.isEmpty()) {
            l.add("<no_layouts_found>");
        }
        return l.toArray(new String[0]);
    }

    private static int setLayoutState(CommandSourceStack stack, String layoutName, boolean enabled, @Nullable Collection<ServerPlayer> targets) {
        try {
            if (targets == null) {
                ServerPlayer sender = stack.getPlayerOrException();
                LayoutCommandPacket packet = new LayoutCommandPacket();
                packet.layout_name = layoutName;
                packet.enabled = enabled;
                PacketHandler.sendToClient(sender, packet);
            } else {
                for (ServerPlayer target : targets) {
                    LayoutCommandPacket packet = new LayoutCommandPacket();
                    packet.layout_name = layoutName;
                    packet.enabled = enabled;
                    PacketHandler.sendToClient(target, packet);
                }
            }
        }
        catch (Exception ex) {
            stack.sendFailure((Component)Component.literal((String)"Error while executing /fmlayout command!"));
            ex.printStackTrace();
        }
        return 1;
    }
}

