/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.file;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.file.DotMinecraftUtils;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.DualTextInputScreen;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyFileAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();

    public CopyFileAction() {
        super("copy_file_in_game_dir");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        block11: {
            try {
                if (value == null || !value.contains("||")) break block11;
                String[] valueArray = value.split("\\|\\|", 2);
                String rawSourcePath = valueArray[0];
                String rawDestinationPath = valueArray[1];
                boolean wildcardSource = this.isWildcardPath(rawSourcePath);
                if (this.isWildcardPath(rawDestinationPath)) {
                    throw new IllegalArgumentException("Destination path cannot end with '*': " + rawDestinationPath);
                }
                String sourcePath = this.resolveActionPath(rawSourcePath, wildcardSource);
                String destinationPath = this.resolveActionPath(rawDestinationPath, false);
                File sourceFile = new File(sourcePath);
                File destinationFile = new File(destinationPath);
                if (!sourceFile.exists()) {
                    throw new FileNotFoundException("Source not found! Can't copy: " + (wildcardSource ? rawSourcePath : sourcePath));
                }
                if (wildcardSource) {
                    if (!sourceFile.isDirectory()) {
                        throw new FileNotFoundException("Source directory not found! Can't copy: " + rawSourcePath);
                    }
                    this.ensureDestinationDirectory(destinationFile, destinationPath);
                    this.copyWildcardFiles(sourceFile, destinationFile);
                    return;
                }
                if (destinationFile.exists()) {
                    throw new FileAlreadyExistsException("Destination exists already! Can't copy to: " + destinationPath);
                }
                Path normalizedSourcePath = sourceFile.toPath().toAbsolutePath().normalize();
                Path normalizedDestinationPath = destinationFile.toPath().toAbsolutePath().normalize();
                if (normalizedDestinationPath.startsWith(normalizedSourcePath)) {
                    throw new IllegalArgumentException("Destination path cannot be inside the source path: " + destinationPath);
                }
                Path destinationParent = normalizedDestinationPath.getParent();
                if (destinationParent != null) {
                    Files.createDirectories(destinationParent, new FileAttribute[0]);
                }
                if (sourceFile.isDirectory()) {
                    this.copyDirectoryRecursively(sourceFile, destinationFile);
                    break block11;
                }
                if (sourceFile.isFile()) {
                    com.google.common.io.Files.copy((File)sourceFile, (File)destinationFile);
                    break block11;
                }
                throw new FileNotFoundException("Source not found! Can't copy: " + sourcePath);
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to copy file in game directory via CopyFileAction: " + value, (Throwable)ex);
            }
        }
    }

    @Override
    @NotNull
    public Component getActionDisplayName() {
        return Component.translatable((String)"fancymenu.actions.copy_file");
    }

    @Override
    @NotNull
    public Component[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.copy_file.desc", new String[0]);
    }

    @Override
    public Component getValueDisplayName() {
        return Component.empty();
    }

    @Override
    public String getValueExample() {
        return "/config/source_directory/some_file.txt||/config/destination_directory/some_file_copy.txt";
    }

    @Override
    public void editValue(@NotNull Screen parentScreen, @NotNull ActionInstance instance) {
        DualTextInputScreen s = DualTextInputScreen.build(this.getActionDisplayName(), (Component)Component.translatable((String)"fancymenu.actions.copy_file.value.source"), (Component)Component.translatable((String)"fancymenu.actions.copy_file.value.destination"), null, callback -> {
            if (callback != null) {
                instance.value = (String)callback.getKey() + "||" + (String)callback.getValue();
            }
            Minecraft.getInstance().setScreen(parentScreen);
        });
        String val = instance.value;
        if (val != null && val.contains("||")) {
            String[] array = val.split("\\|\\|", 2);
            s.setFirstText(array[0]);
            s.setSecondText(array[1]);
        }
        Minecraft.getInstance().setScreen((Screen)s);
    }

    private void copyDirectoryRecursively(@NotNull File sourceDirectory, @NotNull File destinationDirectory) throws IOException {
        final Path sourcePath = sourceDirectory.toPath();
        final Path destinationPath = destinationDirectory.toPath();
        Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path targetDir = destinationPath.resolve(sourcePath.relativize(dir));
                Files.createDirectories(targetDir, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path targetFile = destinationPath.resolve(sourcePath.relativize(file));
                Files.copy(file, targetFile, new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void copyWildcardFiles(@NotNull File sourceDirectory, @NotNull File destinationDirectory) throws IOException {
        File targetFile;
        File[] filesToCopy = sourceDirectory.listFiles(File::isFile);
        if (filesToCopy == null) {
            throw new IOException("Failed to list files in source directory: " + sourceDirectory.getAbsolutePath());
        }
        for (File file : filesToCopy) {
            targetFile = new File(destinationDirectory, file.getName());
            if (!targetFile.exists()) continue;
            throw new FileAlreadyExistsException("File exists at the destination path already! Can't copy to: " + targetFile.getAbsolutePath());
        }
        for (File file : filesToCopy) {
            targetFile = new File(destinationDirectory, file.getName());
            com.google.common.io.Files.copy((File)file, (File)targetFile);
        }
    }

    private void ensureDestinationDirectory(@NotNull File destinationDirectory, @NotNull String destinationPath) throws IOException {
        if (destinationDirectory.exists()) {
            if (!destinationDirectory.isDirectory()) {
                throw new IllegalArgumentException("Destination must be a directory when using '*': " + destinationPath);
            }
        } else {
            Files.createDirectories(destinationDirectory.toPath(), new FileAttribute[0]);
        }
    }

    @NotNull
    private String resolveActionPath(@NotNull String path, boolean wildcard) {
        String processedPath = wildcard ? this.stripTrailingWildcard(path) : path;
        String resolvedPath = DotMinecraftUtils.resolveMinecraftPath(processedPath);
        if (!DotMinecraftUtils.isInsideMinecraftDirectory(resolvedPath)) {
            resolvedPath = GameDirectoryUtils.getAbsoluteGameDirectoryPath(resolvedPath);
        }
        return resolvedPath;
    }

    @NotNull
    private String stripTrailingWildcard(@NotNull String path) {
        if (path.length() <= 1) {
            throw new IllegalArgumentException("Wildcard path requires a directory before '*': " + path);
        }
        String withoutWildcard = path.substring(0, path.length() - 1);
        if (withoutWildcard.isEmpty()) {
            throw new IllegalArgumentException("Wildcard path requires a directory before '*': " + path);
        }
        return withoutWildcard;
    }

    private boolean isWildcardPath(@Nullable String path) {
        return path != null && path.endsWith("*");
    }
}

