/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.level;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.queueable.QueueableNotificationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.queueable.QueueableScreenHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnterWorldAction
extends Action {
    private static long lastJoinErrorTrigger = -1L;

    public EnterWorldAction() {
        super("loadworld");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        if (Minecraft.getInstance().level != null) {
            long now = System.currentTimeMillis();
            if (lastJoinErrorTrigger + 20000L < now) {
                lastJoinErrorTrigger = now;
                QueueableScreenHandler.addToQueue(new QueueableNotificationScreen((Component)Component.translatable((String)"fancymenu.actions.errors.cannot_join_world_while_in_world")));
            }
            return;
        }
        if (value != null && Minecraft.getInstance().getLevelSource().levelExists(value)) {
            Screen current = Minecraft.getInstance().screen != null ? Minecraft.getInstance().screen : new TitleScreen();
            Minecraft.getInstance().setScreen((Screen)new GenericMessageScreen((Component)Component.translatable((String)"selectWorld.data_read")));
            Minecraft.getInstance().createWorldOpenFlows().openWorld(value, () -> Minecraft.getInstance().setScreen(current));
        }
    }

    @Override
    @NotNull
    public Component getActionDisplayName() {
        return Component.translatable((String)"fancymenu.actions.loadworld");
    }

    @Override
    @NotNull
    public Component[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.loadworld.desc", new String[0]);
    }

    @Override
    public Component getValueDisplayName() {
        return Component.translatable((String)"fancymenu.actions.loadworld.desc.value");
    }

    @Override
    public String getValueExample() {
        return "exampleworld";
    }
}

