/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.customgui;

import de.keksuccino.fancymenu.customization.customgui.CustomGui;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomGuiBaseScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final CustomGui gui;
    protected final Screen overrideScreen;
    protected final Screen parentScreen;

    public CustomGuiBaseScreen(@NotNull CustomGui customGui, @Nullable Screen parentScreen, @Nullable Screen overrideScreen) {
        super((Component)Component.empty());
        this.gui = customGui;
        this.overrideScreen = overrideScreen;
        this.parentScreen = parentScreen;
    }

    protected void init() {
        super.init();
        if (this.gui.popupMode) {
            this.resizePopupMenuBackgroundScreen(Minecraft.getInstance(), this.width, this.height);
        }
    }

    protected void resizePopupMenuBackgroundScreen(Minecraft minecraft, int width, int height) {
        try {
            if (this.parentScreen != null) {
                Screen current = Minecraft.getInstance().screen;
                Minecraft.getInstance().screen = this.parentScreen;
                this.parentScreen.resize(minecraft, width, height);
                Minecraft.getInstance().screen = current;
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to resize popup menu background screen of Custom GUI!", (Throwable)ex);
        }
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parentScreen);
    }

    public boolean shouldCloseOnEsc() {
        return this.gui.allowEsc;
    }

    public boolean isPauseScreen() {
        return this.gui.pauseGame;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        super.render(graphics, mouseX, mouseY, partial);
        String title = PlaceholderParser.replacePlaceholders(this.getTitleString());
        MutableComponent titleComp = LocalizationUtils.isLocalizationKey(title) ? Component.translatable((String)title) : Component.literal((String)title);
        graphics.drawCenteredString(this.font, (Component)titleComp, this.width / 2, 8, -1);
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        boolean popupOverlay;
        boolean popup = this.gui.popupMode && this.parentScreen != null;
        boolean bl = popupOverlay = popup && this.gui.popupModeBackgroundOverlay;
        if (popup) {
            this.renderPopupMenuBackgroundScreen(graphics, mouseX, mouseY, partial);
        } else if (Minecraft.getInstance().level == null || !this.gui.worldBackground) {
            this.renderPanorama(graphics, partial);
        }
        if (popup) {
            RenderingUtils.setOverrideBackgroundBlurRadius(7);
        }
        try {
            if (!popup || popupOverlay) {
                graphics.nextStratum();
                this.renderBlurredBackground(graphics);
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Error while rendering background blur in Custom GUI!", (Throwable)ex);
        }
        RenderingUtils.resetOverrideBackgroundBlurRadius();
        if (!popup) {
            this.renderMenuBackground(graphics);
        }
    }

    protected void renderPopupMenuBackgroundScreen(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.gui.popupModeBackgroundOverlay) {
            RenderingUtils.setMenuBlurringBlocked(true);
        }
        RenderingUtils.setTooltipRenderingBlocked(true);
        Screen current = Minecraft.getInstance().screen;
        CustomGui.isCurrentlyRenderingPopupBackgroundScreen = true;
        try {
            Minecraft.getInstance().screen = this.parentScreen;
            this.parentScreen.renderWithTooltipAndSubtitles(graphics, -500, -500, partial);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to render popup menu background screen of Custom GUI!", (Throwable)ex);
        }
        CustomGui.isCurrentlyRenderingPopupBackgroundScreen = false;
        Minecraft.getInstance().screen = current;
        RenderingUtils.setTooltipRenderingBlocked(false);
        RenderingUtils.setMenuBlurringBlocked(false);
    }

    @NotNull
    public String getTitleString() {
        return this.gui.title;
    }

    @NotNull
    public String getIdentifier() {
        return this.gui.identifier;
    }

    @Nullable
    public Screen getOverriddenScreen() {
        return this.overrideScreen;
    }

    @NotNull
    public CustomGui getGuiMetadata() {
        return this.gui;
    }

    @Nullable
    public Screen getParentScreen() {
        return this.parentScreen;
    }
}

