/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.video.mcef;

import de.keksuccino.fancymenu.customization.customgui.CustomGuiBaseScreen;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.elements.video.IVideoElement;
import de.keksuccino.fancymenu.customization.element.elements.video.VideoElementController;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.mcef.MCEFUtil;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.video.mcef.MCEFVideoManager;
import de.keksuccino.fancymenu.util.rendering.video.mcef.MCEFVideoPlayer;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import java.awt.Color;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.sounds.SoundSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MCEFVideoElement
extends AbstractElement
implements IVideoElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    private static final DrawableColor MISSING_MCEF_COLOR = DrawableColor.of(Color.RED);
    @Nullable
    public ResourceSource rawVideoUrlSource = null;
    public boolean loop = false;
    public float volume = 1.0f;
    @NotNull
    public SoundSource soundSource = SoundSource.MASTER;
    protected volatile boolean initialized = false;
    @Nullable
    protected MCEFVideoManager videoManager = null;
    protected MCEFVideoPlayer videoPlayer = null;
    protected String playerId = null;
    protected String lastFinalUrl = null;
    protected int lastAbsoluteWidth = -10000;
    protected int lastAbsoluteHeight = -10000;
    protected int lastAbsoluteX = -10000;
    protected int lastAbsoluteY = -10000;
    protected Boolean lastLoop = null;
    protected float cachedActualVolume = -10000.0f;
    protected float lastCachedActualVolume = -11000.0f;
    protected Boolean lastPausedState = null;
    protected volatile long lastRenderTickTime = -1L;
    protected final AtomicReference<Float> cachedDuration = new AtomicReference<Float>(Float.valueOf(0.0f));
    protected final AtomicReference<Float> cachedPlayTime = new AtomicReference<Float>(Float.valueOf(0.0f));
    protected volatile ScheduledFuture<?> garbageChecker = EXECUTOR.scheduleAtFixedRate(() -> {
        if (this.initialized && this.lastRenderTickTime != -1L && this.lastRenderTickTime + 11000L < System.currentTimeMillis()) {
            this.resetElement();
        }
    }, 0L, 100L, TimeUnit.MILLISECONDS);
    protected volatile ScheduledFuture<?> asyncTicker = EXECUTOR.scheduleAtFixedRate(() -> {
        if (this.initialized) {
            this.cachedDuration.set(Float.valueOf(this._getDuration()));
            this.cachedPlayTime.set(Float.valueOf(this._getPlayTime()));
        }
    }, 0L, 900L, TimeUnit.MILLISECONDS);
    protected boolean triedRestore = false;

    public MCEFVideoElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        if (MCEFUtil.isMCEFLoaded() && MCEFUtil.MCEF_initialized) {
            this.videoManager = MCEFVideoManager.getInstance();
        }
        this.allowDepthTestManipulation = true;
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.shouldRender()) {
            if (!MCEFUtil.isMCEFLoaded() || !MCEFUtil.MCEF_initialized) {
                graphics.fill(this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteX() + this.getAbsoluteWidth(), this.getAbsoluteY() + this.getAbsoluteHeight(), MISSING_MCEF_COLOR.getColorInt());
                int xCenter = this.getAbsoluteX() + this.getAbsoluteWidth() / 2;
                int yCenter = this.getAbsoluteY() + this.getAbsoluteHeight() / 2;
                graphics.drawCenteredString(Minecraft.getInstance().font, "\u00a7lMCEF IS NOT INSTALLED! PLEASE DOWNLOAD FROM CURSEFORGE!", xCenter, yCenter, -1);
                return;
            }
            this.lastRenderTickTime = System.currentTimeMillis();
            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            int w = this.getAbsoluteWidth();
            int h = this.getAbsoluteHeight();
            if (!this.ensureVideoManagerReady()) {
                graphics.fill(x, y, x + w, y + h, DrawableColor.BLACK.getColorIntWithAlpha(this.opacity));
                return;
            }
            if (!this.triedRestore) {
                this.triedRestore = true;
                this.tryRestoreFromMemory();
            }
            if (!this.initialized) {
                this.initialized = true;
                this.playerId = this.videoManager.createPlayer(x, y, w, h);
                if (this.playerId != null) {
                    this.videoPlayer = this.videoManager.getPlayer(this.playerId);
                    if (this.videoPlayer != null) {
                        this.videoPlayer.setFillScreen(true);
                    }
                }
            }
            if (this.videoPlayer == null) {
                return;
            }
            this.updateVolume();
            if (this.lastCachedActualVolume == -11000.0f || this.cachedActualVolume != this.lastCachedActualVolume) {
                this.setVolume(this.volume, true);
            }
            this.lastCachedActualVolume = this.cachedActualVolume;
            if (this.lastLoop == null || !Objects.equals(this.loop, this.lastLoop)) {
                this.videoPlayer.setLooping(this.loop);
            }
            this.lastLoop = this.loop;
            if (this.lastAbsoluteX != x || this.lastAbsoluteY != y || this.lastAbsoluteWidth != w || this.lastAbsoluteHeight != h) {
                this.videoPlayer.setPosition(x, y);
                this.videoPlayer.setSize(w, h);
            }
            this.lastAbsoluteX = x;
            this.lastAbsoluteY = y;
            this.lastAbsoluteWidth = w;
            this.lastAbsoluteHeight = h;
            boolean pausedState = this.getControllerPausedState();
            String finalVideoUrl = null;
            if (this.rawVideoUrlSource != null) {
                finalVideoUrl = PlaceholderParser.replacePlaceholders(this.rawVideoUrlSource.getSourceWithoutPrefix());
            }
            boolean videoUrlChanged = !Objects.equals(finalVideoUrl, this.lastFinalUrl);
            this.lastFinalUrl = finalVideoUrl;
            if (videoUrlChanged && finalVideoUrl != null) {
                this.videoPlayer.stop();
                try {
                    File videoFile = new File(finalVideoUrl);
                    if (videoFile.exists()) {
                        String videoUri = videoFile.toURI().toString();
                        this.videoPlayer.loadVideo(videoUri);
                        if (!pausedState) {
                            this.videoPlayer.play();
                        }
                    } else {
                        this.videoPlayer.loadVideo(finalVideoUrl);
                        if (!pausedState) {
                            this.videoPlayer.play();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.lastPausedState == null || !Objects.equals(pausedState, this.lastPausedState)) {
                if (pausedState) {
                    this.videoPlayer.pause();
                } else {
                    this.videoPlayer.play();
                }
            }
            this.lastPausedState = pausedState;
            graphics.fill(x, y, x + w, y + h, DrawableColor.BLACK.getColorIntWithAlpha(this.opacity));
            this.videoPlayer.setOpacity(this.opacity);
            if (finalVideoUrl != null) {
                this.videoPlayer.render(graphics, mouseX, mouseY, partial);
            }
        }
    }

    protected void tryRestoreFromMemory() {
        if (this.getMemory().hasProperty("video_player") && this.getMemory().hasProperty("player_id") && this.getMemory().hasProperty("last_final_url") && this.getMemory().hasProperty("save_timestamp")) {
            Long saveTimestamp = Objects.requireNonNullElse(this.getMemory().getProperty("save_timestamp", Long.class), -1L);
            if (saveTimestamp + 10000L > System.currentTimeMillis()) {
                this.videoPlayer = this.getMemory().getProperty("video_player", MCEFVideoPlayer.class);
                this.playerId = this.getMemory().getStringProperty("player_id");
                this.lastFinalUrl = this.getMemory().getStringProperty("last_final_url");
                this.initialized = true;
            } else {
                this.getMemory().clear();
            }
        } else {
            this.getMemory().clear();
        }
    }

    protected void trySaveToMemory() {
        if (this.videoPlayer != null && this.playerId != null && this.initialized) {
            this.getMemory().putProperty("save_timestamp", System.currentTimeMillis());
            this.getMemory().putProperty("video_player", this.videoPlayer);
            this.getMemory().putProperty("player_id", this.playerId);
            this.getMemory().putProperty("last_final_url", this.lastFinalUrl);
        } else {
            this.disposePlayer();
        }
    }

    @Override
    public void afterConstruction() {
        if (!VideoElementController.hasMetaFor(this.getInstanceIdentifier())) {
            VideoElementController.putMeta(this.getInstanceIdentifier(), new VideoElementController.VideoElementMeta(this.getInstanceIdentifier(), 1.0f, false));
        }
    }

    @Override
    public void onBeforeResizeScreen() {
        super.onBeforeResizeScreen();
        this.garbageChecker.cancel(true);
        this.asyncTicker.cancel(true);
        this.trySaveToMemory();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onCloseScreen(@Nullable Screen closedScreen, @Nullable Screen newScreen) {
        super.onCloseScreen(closedScreen, newScreen);
        if (!(closedScreen instanceof CustomGuiBaseScreen)) ** GOTO lbl-1000
        c1 = (CustomGuiBaseScreen)closedScreen;
        if (newScreen instanceof CustomGuiBaseScreen) {
            c2 = (CustomGuiBaseScreen)newScreen;
            if (Objects.equals(c1.getIdentifier(), c2.getIdentifier())) {
                this.garbageChecker.cancel(true);
                this.asyncTicker.cancel(true);
                this.trySaveToMemory();
                return;
            }
        } else if (closedScreen != null && newScreen != null && Objects.equals(closedScreen.getClass(), newScreen.getClass())) {
            this.garbageChecker.cancel(true);
            this.asyncTicker.cancel(true);
            this.trySaveToMemory();
            return;
        }
        this.getMemory().clear();
        this.garbageChecker.cancel(true);
        this.asyncTicker.cancel(true);
        this.disposePlayer();
    }

    @Override
    public void onBecomeInvisible() {
        super.onBecomeInvisible();
        this.resetElement();
    }

    protected void setVolume(float volume, boolean updatePlayer) {
        this.volume = volume = Math.max(0.0f, Math.min(1.0f, volume));
        if (this.videoPlayer != null) {
            float actualVolume = this.volume;
            float masterVolume = Minecraft.getInstance().options.getSoundSourceVolume(SoundSource.MASTER);
            float soundSourceVolume = Minecraft.getInstance().options.getSoundSourceVolume(this.soundSource);
            if (this.soundSource != SoundSource.MASTER) {
                soundSourceVolume *= masterVolume;
            }
            actualVolume *= soundSourceVolume;
            this.cachedActualVolume = actualVolume *= this.getControllerVolume();
            if (updatePlayer) {
                this.videoPlayer.setVolume(Math.min(1.0f, Math.max(0.0f, actualVolume)));
            }
        }
    }

    protected void updateVolume() {
        this.setVolume(this.volume, false);
    }

    public float getControllerVolume() {
        VideoElementController.VideoElementMeta meta;
        if (!VideoElementController.hasMetaFor(this.getInstanceIdentifier())) {
            VideoElementController.putMeta(this.getInstanceIdentifier(), new VideoElementController.VideoElementMeta(this.getInstanceIdentifier(), 1.0f, false));
        }
        if ((meta = VideoElementController.getMeta(this.getInstanceIdentifier())) != null) {
            return Math.max(0.0f, Math.min(1.0f, meta.volume));
        }
        return 1.0f;
    }

    public boolean getControllerPausedState() {
        VideoElementController.VideoElementMeta meta;
        if (!VideoElementController.hasMetaFor(this.getInstanceIdentifier())) {
            VideoElementController.putMeta(this.getInstanceIdentifier(), new VideoElementController.VideoElementMeta(this.getInstanceIdentifier(), 1.0f, false));
        }
        if ((meta = VideoElementController.getMeta(this.getInstanceIdentifier())) == null) {
            return false;
        }
        return meta.paused;
    }

    public void disposePlayer() {
        if (this.videoManager != null && this.playerId != null && this.videoPlayer != null) {
            this.videoPlayer.stop();
            this.videoManager.removePlayer(this.playerId);
        }
    }

    public void resetElement() {
        this.disposePlayer();
        this.initialized = false;
        this.videoPlayer = null;
        this.playerId = null;
        this.lastFinalUrl = null;
        this.lastAbsoluteWidth = -10000;
        this.lastAbsoluteHeight = -10000;
        this.lastAbsoluteX = -10000;
        this.lastAbsoluteY = -10000;
        this.lastLoop = null;
        this.cachedActualVolume = -10000.0f;
        this.lastCachedActualVolume = -11000.0f;
        this.lastPausedState = null;
        this.lastRenderTickTime = -1L;
    }

    protected float _getDuration() {
        if (!this.initialized || this.videoPlayer == null) {
            return 0.0f;
        }
        return (float)this.videoPlayer.getDuration();
    }

    protected float _getPlayTime() {
        if (!this.initialized || this.videoPlayer == null) {
            return 0.0f;
        }
        return (float)this.videoPlayer.getCurrentTime();
    }

    @Override
    public float getDuration() {
        return this.cachedDuration.get().floatValue();
    }

    @Override
    public float getPlayTime() {
        return this.cachedPlayTime.get().floatValue();
    }

    protected boolean ensureVideoManagerReady() {
        if (this.videoManager != null) {
            return true;
        }
        if (!MCEFUtil.isMCEFLoaded() || !MCEFUtil.MCEF_initialized) {
            return false;
        }
        if (!MCEFVideoManager.initialized) {
            return false;
        }
        this.videoManager = MCEFVideoManager.getInstance();
        return this.videoManager != null;
    }
}

