/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.background.MenuBackground;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.HideableElement;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetElementBuilder;
import de.keksuccino.fancymenu.customization.layer.ElementFactory;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.LayoutHandler;
import de.keksuccino.fancymenu.customization.layout.editor.AnchorPointOverlay;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorHistory;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorUI;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.BuddyWidget;
import de.keksuccino.fancymenu.customization.layout.editor.widget.AbstractLayoutEditorWidget;
import de.keksuccino.fancymenu.customization.layout.editor.widget.LayoutEditorWidgetRegistry;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.widget.ScreenWidgetDiscoverer;
import de.keksuccino.fancymenu.customization.widget.WidgetMeta;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.ObjectUtils;
import de.keksuccino.fancymenu.util.ScreenTitleUtils;
import de.keksuccino.fancymenu.util.file.FileUtils;
import de.keksuccino.fancymenu.util.file.type.FileType;
import de.keksuccino.fancymenu.util.file.type.groups.FileTypeGroup;
import de.keksuccino.fancymenu.util.file.type.types.FileTypes;
import de.keksuccino.fancymenu.util.file.type.types.TextFileType;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.contextmenu.v2.ContextMenu;
import de.keksuccino.fancymenu.util.rendering.ui.menubar.v2.MenuBar;
import de.keksuccino.fancymenu.util.rendering.ui.screen.NotificationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.filebrowser.SaveFileScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableWidget;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.fancymenu.util.window.WindowHandler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class LayoutEditorScreen
extends Screen
implements ElementFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final boolean FORCE_DISABLE_BUDDY = true;
    protected static final Map<SerializedElement, ElementBuilder<?, ?>> COPIED_ELEMENTS_CLIPBOARD = new LinkedHashMap();
    public static final int ELEMENT_DRAG_CRUMPLE_ZONE = 5;
    @Nullable
    protected static LayoutEditorScreen currentInstance = null;
    @Nullable
    public Screen layoutTargetScreen;
    @NotNull
    public Layout layout;
    public List<AbstractEditorElement> normalEditorElements = new ArrayList<AbstractEditorElement>();
    public List<VanillaWidgetEditorElement> vanillaWidgetEditorElements = new ArrayList<VanillaWidgetEditorElement>();
    public LayoutEditorHistory history = new LayoutEditorHistory(this);
    public MenuBar menuBar;
    public AnchorPointOverlay anchorPointOverlay = new AnchorPointOverlay(this);
    public ContextMenu rightClickMenu;
    public ContextMenu activeElementContextMenu = null;
    public List<AbstractLayoutEditorWidget> layoutEditorWidgets = new ArrayList<AbstractLayoutEditorWidget>();
    protected boolean isMouseSelection = false;
    protected int mouseSelectionStartX = 0;
    protected int mouseSelectionStartY = 0;
    public int leftMouseDownPosX = 0;
    public int leftMouseDownPosY = 0;
    protected boolean elementMovingStarted = false;
    protected boolean elementResizingStarted = false;
    protected boolean mouseDraggingStarted = false;
    protected List<AbstractEditorElement> currentlyDraggedElements = new ArrayList<AbstractEditorElement>();
    protected int rightClickMenuOpenPosX = -1000;
    protected int rightClickMenuOpenPosY = -1000;
    protected LayoutEditorHistory.Snapshot preDragElementSnapshot;
    public final List<WidgetMeta> cachedVanillaWidgetMetas = new ArrayList<WidgetMeta>();
    public boolean unsavedChanges = false;
    protected final BuddyWidget buddyWidget = new BuddyWidget(0, 0);
    public boolean justOpened = true;

    public LayoutEditorScreen(@NotNull Layout layout) {
        this(null, layout);
    }

    public LayoutEditorScreen(@Nullable Screen layoutTargetScreen, @NotNull Layout layout) {
        super((Component)Component.literal((String)""));
        Component cachedOriTitle;
        this.layoutTargetScreen = layoutTargetScreen;
        layout.updateLastEditedTime();
        layout.saveToFileIfPossible();
        this.layout = layout.copy();
        if (this.layoutTargetScreen != null && (cachedOriTitle = ScreenCustomizationLayer.cachedOriginalMenuTitles.get(this.layoutTargetScreen.getClass())) != null) {
            ScreenTitleUtils.setScreenTitle(this.layoutTargetScreen, cachedOriTitle);
        }
        this.constructElementInstances();
        this.getAllElements().forEach(element -> element.element._onOpenScreen());
    }

    protected void init() {
        this.currentlyDraggedElements.clear();
        this.anchorPointOverlay.resetOverlay();
        for (WidgetMeta m : this.cachedVanillaWidgetMetas) {
            AbstractWidget abstractWidget = m.getWidget();
            if (!(abstractWidget instanceof CustomizableWidget)) continue;
            CustomizableWidget w = (CustomizableWidget)abstractWidget;
            w.resetWidgetCustomizationsFancyMenu();
        }
        if (this.layoutEditorWidgets == null || this.layoutEditorWidgets.isEmpty()) {
            this.layoutEditorWidgets = LayoutEditorWidgetRegistry.buildWidgetInstances(this);
        }
        this.closeRightClickMenu();
        this.rightClickMenu = LayoutEditorUI.buildRightClickContextMenu(this);
        this.addWidget(this.rightClickMenu);
        if (this.menuBar != null) {
            this.menuBar.closeAllContextMenus();
        }
        this.menuBar = LayoutEditorUI.buildMenuBar(this, this.menuBar == null || this.menuBar.isExpanded());
        this.addWidget(this.menuBar);
        for (AbstractLayoutEditorWidget w : Lists.reverse(new ArrayList<AbstractLayoutEditorWidget>(this.layoutEditorWidgets))) {
            this.addWidget((GuiEventListener)w);
        }
        this.isMouseSelection = false;
        this.preDragElementSnapshot = null;
        this.closeActiveElementMenu(true);
        this.serializeElementInstancesToLayoutInstance();
        if (this.layout.forcedScale != 0.0f) {
            WidgetMeta m;
            float newscale = this.layout.forcedScale;
            if (newscale <= 0.0f) {
                newscale = 1.0f;
            }
            m = Minecraft.getInstance().getWindow();
            WindowHandler.setGuiScale(newscale);
            this.width = m.getGuiScaledWidth();
            this.height = m.getGuiScaledHeight();
        }
        if (this.layout.autoScalingWidth != 0 && this.layout.autoScalingHeight != 0) {
            Window m = Minecraft.getInstance().getWindow();
            double guiWidth = (double)this.width * WindowHandler.getGuiScale();
            double guiHeight = (double)this.height * WindowHandler.getGuiScale();
            double percentX = guiWidth / (double)this.layout.autoScalingWidth * 100.0;
            double percentY = guiHeight / (double)this.layout.autoScalingHeight * 100.0;
            double newScaleX = percentX / 100.0 * WindowHandler.getGuiScale();
            double newScaleY = percentY / 100.0 * WindowHandler.getGuiScale();
            double newScale = Math.min(newScaleX, newScaleY);
            WindowHandler.setGuiScale(newScale);
            this.width = m.getGuiScaledWidth();
            this.height = m.getGuiScaledHeight();
        }
        this.getAllElements().forEach(element -> {
            if (!this.justOpened) {
                element.element.onBeforeResizeScreen();
            }
            element.element.onDestroyElement();
        });
        if (this.justOpened) {
            this.layout.menuBackgrounds.forEach(MenuBackground::onOpenScreen);
        }
        if (!this.justOpened) {
            this.layout.menuBackgrounds.forEach(MenuBackground::onBeforeResizeScreen);
        }
        this.constructElementInstances();
        if (!this.justOpened) {
            this.layout.menuBackgrounds.forEach(MenuBackground::onAfterResizeScreen);
        }
        this.layout.menuBackgrounds.forEach(MenuBackground::onAfterEnable);
        for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
            w.refresh();
        }
        if (FancyMenu.getOptions().enableBuddy.getValue().booleanValue()) {
            // empty if block
        }
        this.justOpened = false;
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public void tick() {
        if (FancyMenu.getOptions().enableBuddy.getValue().booleanValue()) {
            // empty if block
        }
        for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
            w.tick();
        }
        for (AbstractEditorElement e : this.getAllElements()) {
            e.element.tick();
        }
        this.layout.menuBackgrounds.forEach(MenuBackground::tick);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.activeElementContextMenu != null && !this.activeElementContextMenu.isOpen()) {
            this.activeElementContextMenu = null;
        }
        this.renderBackground(graphics, mouseX, mouseY, partial);
        this.renderElements(graphics, mouseX, mouseY, partial);
        this.renderMouseSelectionRectangle(graphics, mouseX, mouseY);
        this.anchorPointOverlay.render(graphics, mouseX, mouseY, partial);
        this.renderLayoutEditorWidgets(graphics, mouseX, mouseY, partial);
        if (FancyMenu.getOptions().enableBuddy.getValue().booleanValue()) {
            // empty if block
        }
        this.menuBar.render(graphics, mouseX, mouseY, partial);
        this.rightClickMenu.render(graphics, mouseX, mouseY, partial);
        if (this.activeElementContextMenu != null) {
            this.activeElementContextMenu.render(graphics, mouseX, mouseY, partial);
        }
    }

    protected void renderLayoutEditorWidgets(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
            if (!w.isVisible()) continue;
            w.render(graphics, mouseX, mouseY, partial);
        }
    }

    protected void renderMouseSelectionRectangle(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.isMouseSelection) {
            int startX = Math.min(this.mouseSelectionStartX, mouseX);
            int startY = Math.min(this.mouseSelectionStartY, mouseY);
            int endX = Math.max(this.mouseSelectionStartX, mouseX);
            int endY = Math.max(this.mouseSelectionStartY, mouseY);
            graphics.fill(startX, startY, endX, endY, RenderingUtils.replaceAlphaInColor(UIBase.getUIColorTheme().layout_editor_mouse_selection_rectangle_color.getColorInt(), 70));
            UIBase.renderBorder(graphics, startX, startY, endX, endY, 1, UIBase.getUIColorTheme().layout_editor_mouse_selection_rectangle_color.getColor(), true, true, true, true);
        }
    }

    protected void renderElements(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.layout.renderElementsBehindVanilla) {
            for (AbstractEditorElement abstractEditorElement : new ArrayList<AbstractEditorElement>(this.normalEditorElements)) {
                if (abstractEditorElement.isSelected()) continue;
                abstractEditorElement.render(graphics, mouseX, mouseY, partial);
            }
        }
        for (VanillaWidgetEditorElement vanillaWidgetEditorElement : new ArrayList<VanillaWidgetEditorElement>(this.vanillaWidgetEditorElements)) {
            if (vanillaWidgetEditorElement.isSelected() || vanillaWidgetEditorElement.isHidden()) continue;
            vanillaWidgetEditorElement.render(graphics, mouseX, mouseY, partial);
        }
        if (!this.layout.renderElementsBehindVanilla) {
            for (AbstractEditorElement abstractEditorElement : new ArrayList<AbstractEditorElement>(this.normalEditorElements)) {
                if (abstractEditorElement.isSelected()) continue;
                abstractEditorElement.render(graphics, mouseX, mouseY, partial);
            }
        }
        List<AbstractEditorElement> selected = this.getSelectedElements();
        for (AbstractEditorElement e : selected) {
            e.render(graphics, mouseX, mouseY, partial);
        }
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        graphics.fill(0, 0, this.width, this.height, UIBase.getUIColorTheme().screen_background_color_darker.getColorInt());
        this.layout.menuBackgrounds.forEach(menuBackground -> {
            menuBackground.keepBackgroundAspectRatio = this.layout.preserveBackgroundAspectRatio;
            menuBackground.opacity = 1.0f;
            menuBackground.render(graphics, mouseX, mouseY, partial);
        });
        if (!this.layout.menuBackgrounds.isEmpty()) {
            if (this.layout.applyVanillaBackgroundBlur) {
                Minecraft.getInstance().gameRenderer.processBlurEffect();
            }
            if (this.layout.showScreenBackgroundOverlayOnCustomBackground) {
                ScreenCustomizationLayer.renderBackgroundOverlay(graphics, 0, 0, this.width, this.height);
            }
        }
        this.renderScrollListHeaderFooterPreview(graphics, mouseX, mouseY, partial);
        LayoutEditorScreen.renderGrid(graphics, this.width, this.height);
    }

    protected void renderScrollListHeaderFooterPreview(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.layout.showScrollListHeaderFooterPreviewInEditor) {
            ResourceLocation loc;
            ITexture footerTexture;
            int x0 = 0;
            int x1 = this.width;
            int y0 = 48;
            int y1 = this.height - 64;
            ITexture headerTexture = this.layout.scrollListHeaderTexture != null ? (ITexture)this.layout.scrollListHeaderTexture.get() : null;
            ITexture iTexture = footerTexture = this.layout.scrollListFooterTexture != null ? (ITexture)this.layout.scrollListFooterTexture.get() : null;
            if (headerTexture != null && (loc = headerTexture.getResourceLocation()) != null) {
                if (this.layout.preserveScrollListHeaderFooterAspectRatio) {
                    int[] headerSize = headerTexture.getAspectRatio().getAspectRatioSizeByMinimumSize(this.width, y0);
                    int headerWidth = headerSize[0];
                    int headerHeight = headerSize[1];
                    int headerX = x0 + this.width / 2 - headerWidth / 2;
                    int headerY = y0 / 2 - headerHeight / 2;
                    graphics.enableScissor(x0, 0, x0 + this.width, y0);
                    graphics.blit(RenderPipelines.GUI_TEXTURED, loc, headerX, headerY, 0.0f, 0.0f, headerWidth, headerHeight, headerWidth, headerHeight);
                    graphics.disableScissor();
                } else if (this.layout.repeatScrollListHeaderTexture) {
                    RenderingUtils.blitRepeat(graphics, loc, x0, 0, this.width, y0, headerTexture.getWidth(), headerTexture.getHeight(), ARGB.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f));
                } else {
                    graphics.blit(RenderPipelines.GUI_TEXTURED, loc, x0, 0, 0.0f, 0.0f, this.width, y0, this.width, y0, ARGB.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f));
                }
            }
            if (footerTexture != null && (loc = footerTexture.getResourceLocation()) != null) {
                if (this.layout.preserveScrollListHeaderFooterAspectRatio) {
                    int footerOriginalHeight = this.height - y1;
                    int[] footerSize = footerTexture.getAspectRatio().getAspectRatioSizeByMinimumSize(this.width, footerOriginalHeight);
                    int footerWidth = footerSize[0];
                    int footerHeight = footerSize[1];
                    int footerX = x0 + this.width / 2 - footerWidth / 2;
                    int footerY = y1 + footerOriginalHeight / 2 - footerHeight / 2;
                    graphics.enableScissor(x0, y1, x0 + this.width, y1 + footerOriginalHeight);
                    graphics.blit(RenderPipelines.GUI_TEXTURED, loc, footerX, footerY, 0.0f, 0.0f, footerWidth, footerHeight, footerWidth, footerHeight);
                    graphics.disableScissor();
                } else if (this.layout.repeatScrollListFooterTexture) {
                    int footerHeight = this.height - y1;
                    RenderingUtils.blitRepeat(graphics, loc, x0, y1, this.width, footerHeight, footerTexture.getWidth(), footerTexture.getHeight(), ARGB.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f));
                } else {
                    int footerHeight = this.height - y1;
                    graphics.blit(RenderPipelines.GUI_TEXTURED, loc, x0, y1, 0.0f, 0.0f, this.width, footerHeight, this.width, footerHeight);
                }
            }
            graphics.blit(RenderPipelines.GUI_TEXTURED, Screen.HEADER_SEPARATOR, 0, y0 - 2, 0.0f, 0.0f, this.width, 2, 32, 2);
            graphics.blit(RenderPipelines.GUI_TEXTURED, Screen.FOOTER_SEPARATOR, 0, y1, 0.0f, 0.0f, this.width, 2, 32, 2);
        }
    }

    public static void renderGrid(@NotNull GuiGraphics graphics, int screenWidth, int screenHeight) {
        if (FancyMenu.getOptions().showLayoutEditorGrid.getValue().booleanValue()) {
            int maxX;
            float scale = UIBase.calculateFixedScale(1.0f);
            int scaledWidth = (int)((float)screenWidth / scale);
            int scaledHeight = (int)((float)screenHeight / scale);
            graphics.pose().pushMatrix();
            graphics.pose().scale(scale, scale);
            int gridSize = FancyMenu.getOptions().layoutEditorGridSize.getValue();
            int lineThickness = 1;
            graphics.fill(scaledWidth / 2 - 1, 0, scaledWidth / 2 + 1, scaledHeight, UIBase.getUIColorTheme().layout_editor_grid_color_center.getColorInt());
            for (int linesVerticalToLeftPosX = scaledWidth / 2 - gridSize - 1; linesVerticalToLeftPosX > 0; linesVerticalToLeftPosX -= gridSize) {
                int minY = 0;
                int maxY = scaledHeight;
                int maxX2 = linesVerticalToLeftPosX + lineThickness;
                graphics.fill(linesVerticalToLeftPosX, minY, maxX2, maxY, UIBase.getUIColorTheme().layout_editor_grid_color_normal.getColorInt());
            }
            for (int linesVerticalToRightPosX = scaledWidth / 2 + gridSize; linesVerticalToRightPosX < scaledWidth; linesVerticalToRightPosX += gridSize) {
                int minY = 0;
                int maxY = scaledHeight;
                maxX = linesVerticalToRightPosX + lineThickness;
                graphics.fill(linesVerticalToRightPosX, minY, maxX, maxY, UIBase.getUIColorTheme().layout_editor_grid_color_normal.getColorInt());
            }
            graphics.fill(0, scaledHeight / 2 - 1, scaledWidth, scaledHeight / 2 + 1, UIBase.getUIColorTheme().layout_editor_grid_color_center.getColorInt());
            for (int linesHorizontalToTopPosY = scaledHeight / 2 - gridSize - 1; linesHorizontalToTopPosY > 0; linesHorizontalToTopPosY -= gridSize) {
                int minX = 0;
                maxX = scaledWidth;
                int maxY = linesHorizontalToTopPosY + lineThickness;
                graphics.fill(minX, linesHorizontalToTopPosY, maxX, maxY, UIBase.getUIColorTheme().layout_editor_grid_color_normal.getColorInt());
            }
            for (int linesHorizontalToBottomPosY = scaledHeight / 2 + gridSize; linesHorizontalToBottomPosY < scaledHeight; linesHorizontalToBottomPosY += gridSize) {
                int minX = 0;
                int maxX3 = scaledWidth;
                int maxY = linesHorizontalToBottomPosY + lineThickness;
                graphics.fill(minX, linesHorizontalToBottomPosY, maxX3, maxY, UIBase.getUIColorTheme().layout_editor_grid_color_normal.getColorInt());
            }
            graphics.pose().popMatrix();
        }
    }

    protected void constructElementInstances() {
        Object editorElement;
        for (AbstractEditorElement e : this.getAllElements()) {
            e.resetElementStates();
        }
        this.normalEditorElements.clear();
        this.vanillaWidgetEditorElements.clear();
        Layout.OrderedElementCollection normalElements = new Layout.OrderedElementCollection();
        ArrayList vanillaWidgetElements = this.layoutTargetScreen != null ? new ArrayList() : null;
        this.cachedVanillaWidgetMetas.clear();
        if (this.layoutTargetScreen != null) {
            this.cachedVanillaWidgetMetas.addAll(ScreenWidgetDiscoverer.getWidgetsOfScreen(this.layoutTargetScreen, true));
        }
        for (WidgetMeta m : this.cachedVanillaWidgetMetas) {
            AbstractWidget abstractWidget = m.getWidget();
            if (!(abstractWidget instanceof CustomizableWidget)) continue;
            CustomizableWidget w = (CustomizableWidget)abstractWidget;
            w.resetWidgetCustomizationsFancyMenu();
        }
        this.constructElementInstances(this.layout.screenIdentifier, this.cachedVanillaWidgetMetas, this.layout, normalElements, vanillaWidgetElements);
        for (AbstractElement e : ListUtils.mergeLists(normalElements.backgroundElements, normalElements.foregroundElements)) {
            editorElement = e.builder.wrapIntoEditorElementInternal(e, this);
            if (editorElement == null) continue;
            this.normalEditorElements.add((AbstractEditorElement)editorElement);
        }
        if (vanillaWidgetElements != null) {
            for (AbstractElement e : vanillaWidgetElements) {
                editorElement = (VanillaWidgetEditorElement)VanillaWidgetElementBuilder.INSTANCE.wrapIntoEditorElementInternal(e, this);
                if (editorElement == null) continue;
                this.vanillaWidgetEditorElements.add((VanillaWidgetEditorElement)editorElement);
            }
        }
    }

    protected void serializeElementInstancesToLayoutInstance() {
        SerializedElement serialized;
        this.layout.serializedElements.clear();
        this.layout.serializedVanillaButtonElements.clear();
        this.layout.serializedDeepElements.clear();
        for (AbstractEditorElement abstractEditorElement : this.normalEditorElements) {
            serialized = abstractEditorElement.element.builder.serializeElementInternal(abstractEditorElement.element);
            if (serialized == null) continue;
            this.layout.serializedElements.add(serialized);
        }
        for (VanillaWidgetEditorElement vanillaWidgetEditorElement : this.vanillaWidgetEditorElements) {
            serialized = VanillaWidgetElementBuilder.INSTANCE.serializeElementInternal(vanillaWidgetEditorElement.element);
            if (serialized == null) continue;
            this.layout.serializedVanillaButtonElements.add(serialized);
        }
    }

    @NotNull
    public List<AbstractEditorElement> getAllElements() {
        ArrayList<AbstractEditorElement> elements = new ArrayList<AbstractEditorElement>();
        ArrayList<AbstractEditorElement> selected = new ArrayList<AbstractEditorElement>();
        ArrayList<AbstractEditorElement> elementsFinal = new ArrayList<AbstractEditorElement>();
        if (this.layout.renderElementsBehindVanilla) {
            elements.addAll(this.normalEditorElements);
        }
        elements.addAll(this.vanillaWidgetEditorElements);
        if (!this.layout.renderElementsBehindVanilla) {
            elements.addAll(this.normalEditorElements);
        }
        for (AbstractEditorElement e : elements) {
            if (!e.isSelected()) {
                elementsFinal.add(e);
                continue;
            }
            selected.add(e);
        }
        elementsFinal.addAll(selected);
        return elementsFinal;
    }

    @NotNull
    public List<AbstractEditorElement> getHoveredElements() {
        ArrayList<AbstractEditorElement> elements = new ArrayList<AbstractEditorElement>();
        for (AbstractEditorElement e : this.getAllElements()) {
            HideableElement h;
            boolean hidden;
            if (!e.isHovered() || e.element.layerHiddenInEditor || (hidden = e instanceof HideableElement && (h = (HideableElement)((Object)e)).isHidden())) continue;
            elements.add(e);
        }
        return elements;
    }

    @Nullable
    public AbstractEditorElement getTopHoveredElement() {
        List<AbstractEditorElement> hoveredElements = this.getHoveredElements();
        return !hoveredElements.isEmpty() ? hoveredElements.get(hoveredElements.size() - 1) : null;
    }

    @NotNull
    public List<AbstractEditorElement> getSelectedElements() {
        ArrayList<AbstractEditorElement> l = new ArrayList<AbstractEditorElement>();
        this.getAllElements().forEach(element -> {
            if (element.isSelected()) {
                l.add((AbstractEditorElement)element);
            }
        });
        return l;
    }

    @NotNull
    protected <E extends AbstractEditorElement> List<E> getSelectedElementsOfType(@NotNull Class<E> type) {
        ArrayList<AbstractEditorElement> l = new ArrayList<AbstractEditorElement>();
        for (AbstractEditorElement e : this.getSelectedElements()) {
            if (!type.isAssignableFrom(e.getClass())) continue;
            l.add(e);
        }
        return l;
    }

    @Nullable
    public AbstractEditorElement getElementByInstanceIdentifier(@NotNull String instanceIdentifier) {
        instanceIdentifier = instanceIdentifier.replace("vanillabtn:", "").replace("button_compatibility_id:", "");
        for (AbstractEditorElement e : this.getAllElements()) {
            if (!e.element.getInstanceIdentifier().equals(instanceIdentifier)) continue;
            return e;
        }
        return null;
    }

    public void selectAllElements() {
        for (AbstractEditorElement e : this.getAllElements()) {
            if (e.element.layerHiddenInEditor) continue;
            e.setSelected(true);
        }
    }

    public void deselectAllElements() {
        for (AbstractEditorElement e : this.getAllElements()) {
            e.setSelected(false);
        }
    }

    public boolean deleteElement(@NotNull AbstractEditorElement element) {
        if (element.settings.isDestroyable()) {
            if (!element.settings.shouldHideInsteadOfDestroy()) {
                this.normalEditorElements.remove(element);
                this.vanillaWidgetEditorElements.remove(element);
                for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
                    w.editorElementRemovedOrHidden(element);
                }
                return true;
            }
            if (element instanceof HideableElement) {
                HideableElement hideable = (HideableElement)((Object)element);
                hideable.setHidden(true);
                return true;
            }
        }
        return false;
    }

    protected boolean isElementOverlappingArea(@NotNull AbstractEditorElement element, int xStart, int yStart, int xEnd, int yEnd) {
        int elementStartX = element.getX();
        int elementStartY = element.getY();
        int elementEndX = element.getX() + element.getWidth();
        int elementEndY = element.getY() + element.getHeight();
        return xEnd > elementStartX && yEnd > elementStartY && yStart < elementEndY && xStart < elementEndX;
    }

    public boolean allSelectedElementsMovable() {
        for (AbstractEditorElement e : this.getSelectedElements()) {
            if (e.element.layerHiddenInEditor) {
                return false;
            }
            if (e.settings.isMovable()) continue;
            return false;
        }
        return true;
    }

    public boolean canMoveLayerUp(AbstractEditorElement element) {
        int index = this.normalEditorElements.indexOf(element);
        if (index == -1) {
            return false;
        }
        return index < this.normalEditorElements.size() - 1;
    }

    public boolean canMoveLayerDown(AbstractEditorElement element) {
        int index = this.normalEditorElements.indexOf(element);
        return index > 0;
    }

    @Nullable
    public AbstractEditorElement moveLayerUp(@NotNull AbstractEditorElement element) {
        AbstractEditorElement movedAbove = null;
        try {
            if (this.normalEditorElements.contains(element)) {
                ArrayList<AbstractEditorElement> newNormalEditorElements = new ArrayList<AbstractEditorElement>();
                int index = this.normalEditorElements.indexOf(element);
                int i = 0;
                if (index < this.normalEditorElements.size() - 1) {
                    for (AbstractEditorElement e : this.normalEditorElements) {
                        if (e != element) {
                            newNormalEditorElements.add(e);
                            if (i == index + 1) {
                                movedAbove = e;
                                newNormalEditorElements.add(element);
                            }
                        }
                        ++i;
                    }
                    this.normalEditorElements = newNormalEditorElements;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return movedAbove;
    }

    @Nullable
    public AbstractEditorElement moveLayerDown(AbstractEditorElement element) {
        AbstractEditorElement movedBehind = null;
        try {
            if (this.normalEditorElements.contains(element)) {
                ArrayList<AbstractEditorElement> newNormalEditorElements = new ArrayList<AbstractEditorElement>();
                int index = this.normalEditorElements.indexOf(element);
                int i = 0;
                if (index > 0) {
                    for (AbstractEditorElement e : this.normalEditorElements) {
                        if (e != element) {
                            if (i == index - 1) {
                                newNormalEditorElements.add(element);
                                movedBehind = e;
                            }
                            newNormalEditorElements.add(e);
                        }
                        ++i;
                    }
                    this.normalEditorElements = newNormalEditorElements;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return movedBehind;
    }

    public boolean moveLayerToPosition(AbstractEditorElement element, int targetIndex) {
        try {
            if (this.normalEditorElements.contains(element)) {
                int sourceIndex = this.normalEditorElements.indexOf(element);
                if (sourceIndex == targetIndex) {
                    return false;
                }
                ArrayList<AbstractEditorElement> newNormalEditorElements = new ArrayList<AbstractEditorElement>(this.normalEditorElements);
                newNormalEditorElements.remove(element);
                int adjustedTargetIndex = targetIndex;
                if (sourceIndex < targetIndex) {
                    --adjustedTargetIndex;
                }
                if (adjustedTargetIndex >= newNormalEditorElements.size()) {
                    newNormalEditorElements.add(element);
                } else if (adjustedTargetIndex < 0) {
                    newNormalEditorElements.add(0, element);
                } else {
                    newNormalEditorElements.add(adjustedTargetIndex, element);
                }
                this.normalEditorElements = newNormalEditorElements;
                boolean movedUp = sourceIndex > targetIndex;
                this.layoutEditorWidgets.forEach(widget -> widget.editorElementOrderChanged(element, movedUp));
                this.unsavedChanges = true;
                return true;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to move layer to position", (Throwable)ex);
        }
        return false;
    }

    public void copyElementsToClipboard(AbstractEditorElement ... elements) {
        if (elements != null && elements.length > 0) {
            COPIED_ELEMENTS_CLIPBOARD.clear();
            for (AbstractEditorElement e : elements) {
                SerializedElement serialized;
                if (e.element.layerHiddenInEditor || !e.settings.isCopyable() || (serialized = e.element.builder.serializeElementInternal(e.element)) == null) continue;
                serialized.putProperty("instance_identifier", ScreenCustomization.generateUniqueIdentifier());
                COPIED_ELEMENTS_CLIPBOARD.put(serialized, e.element.builder);
            }
        }
    }

    public void pasteElementsFromClipboard() {
        if (!COPIED_ELEMENTS_CLIPBOARD.isEmpty()) {
            this.deselectAllElements();
            for (Map.Entry<SerializedElement, ElementBuilder<?, ?>> m : COPIED_ELEMENTS_CLIPBOARD.entrySet()) {
                Object deserializedEditorElement;
                m.getKey().putProperty("instance_identifier", ScreenCustomization.generateUniqueIdentifier());
                Object deserialized = m.getValue().deserializeElementInternal(m.getKey());
                if (deserialized == null || (deserializedEditorElement = m.getValue().wrapIntoEditorElementInternal((AbstractElement)deserialized, this)) == null) continue;
                this.normalEditorElements.add((AbstractEditorElement)deserializedEditorElement);
                this.layoutEditorWidgets.forEach(widget -> widget.editorElementAdded((AbstractEditorElement)deserializedEditorElement));
                ((AbstractEditorElement)deserializedEditorElement).element.layerHiddenInEditor = false;
                ((AbstractEditorElement)deserializedEditorElement).setSelected(true);
            }
        }
    }

    public void saveLayout() {
        if (this.layout.layoutFile != null) {
            this.layout.updateLastEditedTime();
            this.serializeElementInstancesToLayoutInstance();
            if (!this.layout.saveToFileIfPossible()) {
                Minecraft.getInstance().setScreen((Screen)NotificationScreen.error(call -> Minecraft.getInstance().setScreen((Screen)this), LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.saving_failed.generic", new String[0])));
            } else {
                this.unsavedChanges = false;
                LayoutHandler.reloadLayouts();
            }
        } else {
            this.saveLayoutAs();
        }
    }

    public void saveLayoutAs() {
        Object fileNamePreset = "universal_layout";
        if (this.layoutTargetScreen != null) {
            fileNamePreset = ScreenIdentifierHandler.getIdentifierOfScreen(this.layoutTargetScreen) + "_layout";
        }
        fileNamePreset = ((String)fileNamePreset).toLowerCase();
        fileNamePreset = CharacterFilter.buildOnlyLowercaseFileNameFilter().filterForAllowedChars((String)fileNamePreset);
        fileNamePreset = FileUtils.generateAvailableFilename((String)LayoutHandler.LAYOUT_DIR.getAbsolutePath(), (String)fileNamePreset, (String)"txt");
        if (this.layout.layoutFile != null) {
            fileNamePreset = this.layout.layoutFile.getName();
        }
        SaveFileScreen s = (SaveFileScreen)SaveFileScreen.build(LayoutHandler.LAYOUT_DIR, (String)fileNamePreset, "txt", call -> {
            if (call != null) {
                try {
                    Layout old;
                    this.layout.updateLastEditedTime();
                    this.serializeElementInstancesToLayoutInstance();
                    this.layout.layoutFile = call.getAbsoluteFile();
                    if (this.layout.layoutFile.isFile() && (old = LayoutHandler.getLayout(this.layout.getLayoutName())) != null) {
                        old.delete(false);
                    }
                    if (!this.layout.saveToFileIfPossible()) {
                        Minecraft.getInstance().setScreen((Screen)NotificationScreen.error(call2 -> Minecraft.getInstance().setScreen((Screen)this), LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.saving_failed.generic", new String[0])));
                    } else {
                        this.unsavedChanges = false;
                        LayoutHandler.reloadLayouts();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Minecraft.getInstance().setScreen((Screen)NotificationScreen.error(call2 -> Minecraft.getInstance().setScreen((Screen)this), LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.saving_failed.generic", new String[0])));
                }
            }
            Minecraft.getInstance().setScreen((Screen)this);
        }).setVisibleDirectoryLevelsAboveRoot(2).setShowSubDirectories(false);
        FileTypeGroup fileTypeGroup = FileTypeGroup.of((FileType[])new TextFileType[]{FileTypes.TXT_TEXT});
        fileTypeGroup.setDisplayName((Component)Component.translatable((String)"fancymenu.file_types.groups.text"));
        s.setFileTypes(fileTypeGroup);
        Minecraft.getInstance().setScreen((Screen)s);
    }

    public void onUpdateSelectedElements() {
        List<AbstractEditorElement> selected = this.getSelectedElements();
        if (selected.size() > 1) {
            for (AbstractEditorElement e : selected) {
                e.setMultiSelected(true);
            }
        } else if (selected.size() == 1) {
            selected.get(0).setMultiSelected(false);
        }
    }

    public void openRightClickMenuAtMouse(int mouseX, int mouseY) {
        if (this.rightClickMenu != null) {
            this.rightClickMenuOpenPosX = mouseX;
            this.rightClickMenuOpenPosY = mouseY;
            this.rightClickMenu.openMenuAtMouse();
        }
    }

    public void closeRightClickMenu() {
        if (this.rightClickMenu != null) {
            if (this.rightClickMenu.isUserNavigatingInMenu()) {
                return;
            }
            this.rightClickMenuOpenPosX = -1000;
            this.rightClickMenuOpenPosY = -1000;
            this.rightClickMenu.closeMenu();
        }
    }

    public void openElementContextMenuAtMouseIfPossible() {
        this.closeActiveElementMenu();
        List<AbstractEditorElement> selectedElements = this.getSelectedElements();
        if (selectedElements.size() == 1) {
            this.activeElementContextMenu = selectedElements.get((int)0).rightClickMenu;
            ((IMixinScreen)((Object)this)).getChildrenFancyMenu().add(0, this.activeElementContextMenu);
            this.activeElementContextMenu.openMenuAtMouse();
        } else if (selectedElements.size() > 1) {
            List<ContextMenu> menus = ObjectUtils.getOfAll(ContextMenu.class, selectedElements, consumes -> consumes.rightClickMenu);
            this.activeElementContextMenu = ContextMenu.stackContextMenus(menus);
            ((IMixinScreen)((Object)this)).getChildrenFancyMenu().add(0, this.activeElementContextMenu);
            this.activeElementContextMenu.openMenuAtMouse();
        }
    }

    public void closeActiveElementMenu(boolean forceClose) {
        if (this.activeElementContextMenu != null) {
            if (!forceClose && this.activeElementContextMenu.isUserNavigatingInMenu()) {
                return;
            }
            this.activeElementContextMenu.closeMenu();
            this.removeWidget(this.activeElementContextMenu);
        }
        this.activeElementContextMenu = null;
    }

    public void closeActiveElementMenu() {
        this.closeActiveElementMenu(false);
    }

    public boolean isUserNavigatingInRightClickMenu() {
        return this.rightClickMenu != null && this.rightClickMenu.isUserNavigatingInMenu();
    }

    public boolean isUserNavigatingInElementMenu() {
        return this.activeElementContextMenu != null && this.activeElementContextMenu.isUserNavigatingInMenu();
    }

    public void saveWidgetSettings() {
        for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
            w.getBuilder().writeSettingsInternal(w);
        }
    }

    @NotNull
    public List<AbstractEditorElement> getCurrentlyDraggedElements() {
        return this.currentlyDraggedElements;
    }

    @Nullable
    protected List<AbstractEditorElement> getElementChildChainOfExcluding(@NotNull AbstractEditorElement element) {
        Objects.requireNonNull(element);
        ArrayList<AbstractEditorElement> chain = new ArrayList<AbstractEditorElement>();
        try {
            AbstractEditorElement e = element;
            while ((e = this.getChildElementOf(e)) != null) {
                if (e == element) {
                    throw new IllegalStateException("Child of origin element is its own child. This shouldn't be possible and comes from an invalid ELEMENT anchor point. You need to manually fix this.");
                }
                if (chain.contains(e)) {
                    throw new IllegalStateException("Chain already contains element! This shouldn't be possible and probably comes from an invalid ELEMENT anchor who's child is its parent or similar scenarios (sweet home Alabama). You need to manually fix this.");
                }
                chain.add(e);
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] There was an error while trying to get the element chain!", (Throwable)ex);
            return null;
        }
        return chain;
    }

    @Nullable
    protected AbstractEditorElement getChildElementOf(@NotNull AbstractEditorElement element) {
        for (AbstractEditorElement e : this.getAllElements()) {
            String parentOfE = e.element.getAnchorPointElementIdentifier();
            if (parentOfE == null || !parentOfE.equals(element.element.getInstanceIdentifier())) continue;
            return e;
        }
        return null;
    }

    protected void moveSelectedElementsByXYOffset(int offsetX, int offsetY) {
        List<AbstractEditorElement> selected = this.getSelectedElements();
        if (!selected.isEmpty() && this.allSelectedElementsMovable()) {
            this.history.saveSnapshot();
        }
        boolean multiSelect = selected.size() > 1;
        for (AbstractEditorElement e : selected) {
            if (this.allSelectedElementsMovable()) {
                if (multiSelect && e.isElementAnchorAndParentIsSelected()) continue;
                e.element.posOffsetX += offsetX;
                e.element.posOffsetY += offsetY;
                continue;
            }
            if (e.settings.isMovable()) continue;
            e.renderMovingNotAllowedTime = System.currentTimeMillis() + 800L;
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        boolean menuBarContextOpen;
        this.leftMouseDownPosX = (int)event.x();
        this.leftMouseDownPosY = (int)event.y();
        boolean bl = menuBarContextOpen = this.menuBar != null && this.menuBar.isEntryContextMenuOpen();
        if (super.mouseClicked(event, isDoubleClick)) {
            this.closeRightClickMenu();
            this.closeActiveElementMenu();
            return true;
        }
        if (menuBarContextOpen) {
            return true;
        }
        AbstractEditorElement topHoverElement = this.getTopHoveredElement();
        boolean topHoverGotSelected = false;
        if (!(topHoverElement == null || this.rightClickMenu.isUserNavigatingInMenu() || this.activeElementContextMenu != null && this.activeElementContextMenu.isUserNavigatingInMenu() || topHoverElement.isSelected())) {
            topHoverElement.setSelected(true);
            topHoverElement.recentlyLeftClickSelected = true;
            topHoverGotSelected = true;
        }
        boolean canStartMouseSelection = true;
        for (AbstractEditorElement e : this.getAllElements()) {
            e.mouseClicked(event, isDoubleClick);
            if (!e.isHovered() && !e.isGettingResized() && e.getHoveredResizeGrabber() == null) continue;
            canStartMouseSelection = false;
        }
        if (event.button() == 0 && canStartMouseSelection) {
            this.isMouseSelection = true;
            this.mouseSelectionStartX = (int)event.x();
            this.mouseSelectionStartY = (int)event.y();
        }
        if (!(this.rightClickMenu.isUserNavigatingInMenu() || this.activeElementContextMenu != null && this.activeElementContextMenu.isUserNavigatingInMenu() || event.hasControlDown() || event.button() != 0 && (event.button() != 1 || topHoverElement != null && !topHoverGotSelected))) {
            for (AbstractEditorElement e : this.getAllElements()) {
                if (e.isGettingResized() || topHoverElement != null && e == topHoverElement) continue;
                e.setSelected(false);
            }
        }
        this.closeActiveElementMenu();
        if (event.button() == 0 && !this.rightClickMenu.isUserNavigatingInMenu()) {
            this.closeRightClickMenu();
        }
        if (topHoverElement == null) {
            if (event.button() == 1) {
                this.openRightClickMenuAtMouse((int)event.x(), (int)event.y());
            }
        } else if (!topHoverElement.element.layerHiddenInEditor) {
            this.closeRightClickMenu();
            if (event.button() == 1) {
                this.openElementContextMenuAtMouseIfPossible();
            }
        }
        return false;
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        AbstractEditorElement topHoverElement;
        this.anchorPointOverlay.mouseReleased(event);
        boolean cachedMovingStarted = this.elementMovingStarted;
        this.elementMovingStarted = false;
        this.elementResizingStarted = false;
        this.currentlyDraggedElements.clear();
        boolean mouseWasInDraggingMode = this.mouseDraggingStarted;
        this.mouseDraggingStarted = false;
        boolean cachedMouseSelection = this.isMouseSelection;
        if (event.button() == 0) {
            this.isMouseSelection = false;
        }
        this.setDragging(false);
        for (GuiEventListener child : this.children()) {
            if (!child.mouseReleased(event)) continue;
            return true;
        }
        List<AbstractEditorElement> hoveredElements = this.getHoveredElements();
        AbstractEditorElement abstractEditorElement = topHoverElement = !hoveredElements.isEmpty() ? hoveredElements.get(hoveredElements.size() - 1) : null;
        if (!mouseWasInDraggingMode && !cachedMouseSelection && event.button() == 0 && topHoverElement != null && topHoverElement.isSelected() && !topHoverElement.recentlyMovedByDragging && !topHoverElement.recentlyLeftClickSelected && event.hasControlDown()) {
            topHoverElement.setSelected(false);
        }
        boolean elementRecentlyMovedByDragging = false;
        for (AbstractEditorElement e : this.getAllElements()) {
            if (e.recentlyMovedByDragging) {
                elementRecentlyMovedByDragging = true;
            }
            e.mouseReleased(event);
            e.recentlyLeftClickSelected = false;
        }
        if (cachedMovingStarted && this.preDragElementSnapshot != null) {
            this.history.saveSnapshot(this.preDragElementSnapshot);
        }
        this.preDragElementSnapshot = null;
        return false;
    }

    public boolean mouseDragged(MouseButtonEvent event, double $$3, double $$4) {
        boolean movingCrumpleZonePassed;
        if (super.mouseDragged(event, $$3, $$4)) {
            return true;
        }
        if (this.isMouseSelection) {
            for (AbstractEditorElement e : this.getAllElements()) {
                boolean b;
                if (e.element.layerHiddenInEditor || !(b = this.isElementOverlappingArea(e, Math.min(this.mouseSelectionStartX, (int)event.x()), Math.min(this.mouseSelectionStartY, (int)event.y()), Math.max(this.mouseSelectionStartX, (int)event.x()), Math.max(this.mouseSelectionStartY, (int)event.y()))) && event.hasControlDown()) continue;
                e.setSelected(b);
            }
        }
        int draggingDiffX = (int)(event.y() - (double)this.leftMouseDownPosX);
        int draggingDiffY = (int)(event.y() - (double)this.leftMouseDownPosY);
        if (draggingDiffX != 0 || draggingDiffY != 0) {
            this.mouseDraggingStarted = true;
        }
        List<AbstractEditorElement> allElements = this.getAllElements();
        if (!this.elementResizingStarted) {
            allElements.forEach(element -> element.updateResizingStartPos((int)event.x(), (int)event.y()));
        }
        this.elementResizingStarted = true;
        boolean bl = movingCrumpleZonePassed = Math.abs(draggingDiffX) >= 5 || Math.abs(draggingDiffY) >= 5;
        if (movingCrumpleZonePassed) {
            if (!this.elementMovingStarted) {
                if (this.preDragElementSnapshot == null) {
                    this.preDragElementSnapshot = this.history.createSnapshot();
                }
                allElements.forEach(element -> {
                    element.updateMovingStartPos((int)event.x(), (int)event.y());
                    element.movingCrumpleZonePassed = true;
                });
                if (this.allSelectedElementsMovable()) {
                    this.currentlyDraggedElements.addAll(this.getSelectedElements());
                }
            }
            this.elementMovingStarted = true;
        }
        for (AbstractEditorElement e : allElements) {
            if (e.mouseDragged(event, $$3, $$4)) break;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
        boolean handled = false;
        if (FancyMenu.getOptions().enableBuddy.getValue().booleanValue()) {
            // empty if block
        }
        if (!handled && super.mouseScrolled(mouseX, mouseY, scrollDeltaX, scrollDeltaY)) {
            return true;
        }
        return handled;
    }

    public boolean keyPressed(KeyEvent event) {
        this.anchorPointOverlay.keyPressed(event);
        if (super.keyPressed(event)) {
            return true;
        }
        for (AbstractEditorElement abstractEditorElement : this.getAllElements()) {
            if (abstractEditorElement.element.layerHiddenInEditor || !abstractEditorElement.keyPressed(event)) continue;
            return true;
        }
        String key = GLFW.glfwGetKeyName((int)event.key(), (int)event.scancode());
        if (key == null) {
            key = "";
        }
        if (event.key() == 263) {
            this.moveSelectedElementsByXYOffset(-1, 0);
            return true;
        }
        if (event.key() == 265) {
            this.moveSelectedElementsByXYOffset(0, -1);
            return true;
        }
        if (event.key() == 262) {
            this.moveSelectedElementsByXYOffset(1, 0);
            return true;
        }
        if (event.key() == 264) {
            this.moveSelectedElementsByXYOffset(0, 1);
            return true;
        }
        if (key.equals("a") && event.hasControlDown()) {
            this.selectAllElements();
        }
        if (key.equals("c") && event.hasControlDown()) {
            this.copyElementsToClipboard(this.getSelectedElements().toArray(new AbstractEditorElement[0]));
            return true;
        }
        if (key.equals("v") && event.hasControlDown()) {
            this.pasteElementsFromClipboard();
            return true;
        }
        if (key.equals("s") && event.hasControlDown()) {
            this.saveLayout();
            return true;
        }
        if (key.equals("z") && event.hasControlDown()) {
            this.history.stepBack();
            return true;
        }
        if (key.equals("y") && event.hasControlDown()) {
            this.history.stepForward();
            return true;
        }
        if (key.equals("g") && event.hasControlDown()) {
            try {
                FancyMenu.getOptions().showLayoutEditorGrid.setValue(FancyMenu.getOptions().showLayoutEditorGrid.getValue() == false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        if (event.key() == 261) {
            this.history.saveSnapshot();
            for (AbstractEditorElement e : this.getSelectedElements()) {
                if (e.element.layerHiddenInEditor) continue;
                e.deleteElement();
            }
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean keyReleased(KeyEvent event) {
        this.anchorPointOverlay.keyReleased(event);
        for (AbstractEditorElement abstractEditorElement : this.getAllElements()) {
            if (!abstractEditorElement.keyReleased(event)) continue;
            return true;
        }
        return super.keyReleased(event);
    }

    public void closeEditor() {
        this.saveWidgetSettings();
        this.buddyWidget.cleanup();
        this.getAllElements().forEach(element -> {
            element.element.onDestroyElement();
            element.element.onCloseScreen(null, null);
            element.element.onCloseScreen();
        });
        this.layout.menuBackgrounds.forEach(menuBackground -> menuBackground.onCloseScreen(null, null));
        this.layout.menuBackgrounds.forEach(MenuBackground::onCloseScreen);
        currentInstance = null;
        if (this.layoutTargetScreen != null) {
            if (!((IMixinScreen)this.layoutTargetScreen).get_initialized_FancyMenu()) {
                Minecraft.getInstance().setScreen(this.layoutTargetScreen);
            } else {
                Minecraft.getInstance().setScreen((Screen)new GenericMessageScreen((Component)Component.literal((String)"Closing editor..")));
                Minecraft.getInstance().screen = this.layoutTargetScreen;
                ScreenCustomization.reInitCurrentScreen();
            }
        } else {
            Minecraft.getInstance().setScreen(null);
        }
    }

    public LayoutEditorScreen setAsCurrentInstance() {
        currentInstance = this;
        return this;
    }

    @Nullable
    public static LayoutEditorScreen getCurrentInstance() {
        return currentInstance;
    }
}

