/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.platform.Services;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import de.keksuccino.konkrete.Konkrete;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class IsModLoadedRequirement
extends LoadingRequirement {
    public IsModLoadedRequirement() {
        super("fancymenu_loading_requirement_is_mod_loaded");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        List<String> l;
        if (value != null && !(l = this.parseStrings(value)).isEmpty()) {
            for (String s : l) {
                if (!(s.equalsIgnoreCase("optifine") ? !Konkrete.isOptifineLoaded : !Services.PLATFORM.isModLoaded(s))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected List<String> parseStrings(String value) {
        ArrayList<String> l = new ArrayList<String>();
        if (value != null) {
            if (value.contains(",")) {
                l.addAll(Arrays.asList(value.replace(" ", "").split(",")));
            } else {
                l.add(value.replace(" ", ""));
            }
        }
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.requirements.is_mod_loaded", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.is_mod_loaded.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return null;
    }

    @Override
    public String getValueDisplayName() {
        return "";
    }

    @Override
    public String getValuePreset() {
        return "optifine";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

    @Override
    public void editValue(@NotNull Screen parentScreen, @NotNull LoadingRequirementInstance requirementInstance) {
        IsModLoadedValueConfigScreen s = new IsModLoadedValueConfigScreen(Objects.requireNonNullElse(requirementInstance.value, ""), callback -> {
            if (callback != null) {
                requirementInstance.value = callback;
            }
            Minecraft.getInstance().setScreen(parentScreen);
        });
        Minecraft.getInstance().setScreen((Screen)s);
    }

    public static class IsModLoadedValueConfigScreen
    extends StringBuilderScreen {
        @NotNull
        protected String modId;
        protected CellScreen.TextInputCell modIdCell;
        protected EditBoxSuggestions modIdSuggestions;

        protected IsModLoadedValueConfigScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((Component)Component.translatable((String)"fancymenu.requirements.is_mod_loaded.value_name"), callback);
            this.modId = value;
        }

        @Override
        protected void initCells() {
            this.addSpacerCell(20);
            String id = this.getModIdString();
            this.addLabelCell((Component)Component.translatable((String)"fancymenu.requirements.is_mod_loaded.mod_id"));
            this.modIdCell = this.addTextInputCell(null, true, true).setText(id);
            this.modIdSuggestions = EditBoxSuggestions.createWithCustomSuggestions(this, this.modIdCell.editBox, EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, Services.PLATFORM.getLoadedModIds());
            UIBase.applyDefaultWidgetSkinTo(this.modIdSuggestions);
            this.modIdCell.editBox.setResponder(s -> this.modIdSuggestions.updateCommandInfo());
            this.addSpacerCell(20);
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            super.render(graphics, mouseX, mouseY, partial);
            this.modIdSuggestions.render(graphics, mouseX, mouseY);
        }

        @Override
        public boolean keyPressed(KeyEvent event) {
            if (this.modIdSuggestions.keyPressed(event)) {
                return true;
            }
            return super.keyPressed(event);
        }

        public boolean mouseScrolled(double $$0, double $$1, double scrollDeltaX, double scrollDeltaY) {
            if (this.modIdSuggestions.mouseScrolled(scrollDeltaY)) {
                return true;
            }
            return super.mouseScrolled($$0, $$1, scrollDeltaX, scrollDeltaY);
        }

        @Override
        public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
            if (this.modIdSuggestions.mouseClicked(event)) {
                return true;
            }
            return super.mouseClicked(event, isDoubleClick);
        }

        @Override
        @NotNull
        public String buildString() {
            return this.getModIdString();
        }

        @NotNull
        protected String getModIdString() {
            if (this.modIdCell != null) {
                return this.modIdCell.getText();
            }
            return this.modId;
        }
    }
}

