/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.customization.variables.VariableHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class IsVariableValueRequirement
extends LoadingRequirement {
    public IsVariableValueRequirement() {
        super("fancymenu_visibility_requirement_is_variable_value");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        if (value != null && value.contains(":")) {
            String name = value.split(":", 2)[0];
            String val = value.split(":", 2)[1];
            if (VariableHandler.variableExists(name)) {
                String storedVal = Objects.requireNonNull(VariableHandler.getVariable(name)).getValue();
                return val.equals(storedVal);
            }
        }
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.requirements.is_variable_value", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.is_variable_value.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return null;
    }

    @Override
    public String getValueDisplayName() {
        return "";
    }

    @Override
    public String getValuePreset() {
        return "<variable_name>:<value_to_check_for>";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

    @Override
    public void editValue(@NotNull Screen parentScreen, @NotNull LoadingRequirementInstance requirementInstance) {
        IsVariableValueConfigScreen s = new IsVariableValueConfigScreen(Objects.requireNonNullElse(requirementInstance.value, ""), callback -> {
            if (callback != null) {
                requirementInstance.value = callback;
            }
            Minecraft.getInstance().setScreen(parentScreen);
        });
        Minecraft.getInstance().setScreen((Screen)s);
    }

    public static class IsVariableValueConfigScreen
    extends StringBuilderScreen {
        @NotNull
        protected String variableName = "";
        @NotNull
        protected String variableValue = "";
        protected CellScreen.TextInputCell nameCell;
        protected CellScreen.TextInputCell valueCell;
        protected EditBoxSuggestions variableNameSuggestions;

        protected IsVariableValueConfigScreen(String value, @NotNull Consumer<String> callback) {
            super((Component)Component.translatable((String)"fancymenu.requirements.is_variable_value.value.desc"), callback);
            if (value == null) {
                value = "";
            }
            if (value.contains(":")) {
                this.variableName = value.split(":", 2)[0];
                this.variableValue = value.split(":", 2)[1];
            }
        }

        @Override
        protected void initCells() {
            this.addSpacerCell(20);
            String name = this.getVarNameString();
            this.addLabelCell((Component)Component.translatable((String)"fancymenu.requirements.is_variable_value.var_name"));
            this.nameCell = this.addTextInputCell(null, true, true).setText(name);
            this.addCellGroupEndSpacerCell();
            this.variableNameSuggestions = EditBoxSuggestions.createWithCustomSuggestions(this, this.nameCell.editBox, EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, VariableHandler.getVariableNames());
            UIBase.applyDefaultWidgetSkinTo(this.variableNameSuggestions);
            this.nameCell.editBox.setResponder(s -> this.variableNameSuggestions.updateCommandInfo());
            this.addCellGroupEndSpacerCell();
            String value = this.getVarValueString();
            this.addLabelCell((Component)Component.translatable((String)"fancymenu.requirements.is_variable_value.var_value"));
            this.valueCell = this.addTextInputCell(null, true, true).setText(value);
            this.addSpacerCell(20);
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            super.render(graphics, mouseX, mouseY, partial);
            this.variableNameSuggestions.render(graphics, mouseX, mouseY);
        }

        @Override
        public boolean keyPressed(KeyEvent event) {
            if (this.variableNameSuggestions.keyPressed(event)) {
                return true;
            }
            return super.keyPressed(event);
        }

        public boolean mouseScrolled(double $$0, double $$1, double scrollDeltaX, double scrollDeltaY) {
            if (this.variableNameSuggestions.mouseScrolled(scrollDeltaY)) {
                return true;
            }
            return super.mouseScrolled($$0, $$1, scrollDeltaX, scrollDeltaY);
        }

        @Override
        public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
            if (this.variableNameSuggestions.mouseClicked(event)) {
                return true;
            }
            return super.mouseClicked(event, isDoubleClick);
        }

        @Override
        @NotNull
        public String buildString() {
            return this.getVarNameString() + ":" + this.getVarValueString();
        }

        @NotNull
        protected String getVarNameString() {
            if (this.nameCell != null) {
                return this.nameCell.getText();
            }
            return this.variableName;
        }

        @NotNull
        protected String getVarValueString() {
            if (this.valueCell != null) {
                return this.valueCell.getText();
            }
            return this.variableValue;
        }
    }
}

