/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.panorama;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.fancymenu.util.resource.resources.texture.PngTexture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.texture.AbstractTexture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PanoramaCubeMapTexture
extends AbstractTexture {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int[] FACE_ORDER = new int[]{1, 3, 5, 4, 0, 2};
    @NotNull
    private final List<ResourceSupplier<ITexture>> textureSuppliers;
    @NotNull
    private final String name;
    private volatile boolean loaded = false;
    private volatile boolean loadFailed = false;

    public PanoramaCubeMapTexture(@NotNull String name, @NotNull List<ResourceSupplier<ITexture>> textureSuppliers) {
        this.name = Objects.requireNonNull(name);
        this.textureSuppliers = Objects.requireNonNull(textureSuppliers);
        if (textureSuppliers.size() != 6) {
            throw new IllegalArgumentException("Cube map must have exactly 6 texture suppliers, got " + textureSuppliers.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTextures() {
        if (this.loaded || this.loadFailed) {
            return;
        }
        try {
            ArrayList<ITexture> textures = new ArrayList<ITexture>(6);
            for (int i = 0; i < 6; ++i) {
                ITexture texture = this.textureSuppliers.get(i).get();
                if (texture == null) {
                    throw new IOException("Texture supplier " + i + " returned null");
                }
                texture.waitForReady(5000L);
                if (!texture.isReady()) {
                    throw new IOException("Texture " + i + " failed to become ready in time");
                }
                textures.add(texture);
            }
            int width = ((ITexture)textures.get(0)).getWidth();
            int height = ((ITexture)textures.get(0)).getHeight();
            for (int i = 1; i < 6; ++i) {
                if (((ITexture)textures.get(i)).getWidth() == width && ((ITexture)textures.get(i)).getHeight() == height) continue;
                throw new IOException("Image dimensions of cubemap '" + this.name + "' sides do not match: part 0 is " + width + "x" + height + ", but part " + i + " is " + ((ITexture)textures.get(i)).getWidth() + "x" + ((ITexture)textures.get(i)).getHeight());
            }
            try (NativeImage combinedImage = new NativeImage(width, height * 6, false);){
                for (int i = 0; i < 6; ++i) {
                    int faceIndex = FACE_ORDER[i];
                    ITexture texture = (ITexture)textures.get(faceIndex);
                    NativeImage faceImage = null;
                    if (texture instanceof PngTexture) {
                        PngTexture pngTexture = (PngTexture)texture;
                        faceImage = pngTexture.getNativeImage();
                    }
                    if (faceImage == null) {
                        throw new IOException("Could not get NativeImage from texture " + faceIndex);
                    }
                    faceImage.copyRect(combinedImage, 0, 0, 0, i * height, width, height, false, true);
                }
                this.doLoad(combinedImage, false, true);
            }
            this.loaded = true;
        }
        catch (Exception ex) {
            this.loadFailed = true;
            LOGGER.error("[FANCYMENU] Failed to load custom cube map texture: " + this.name, (Throwable)ex);
        }
    }

    protected void doLoad(NativeImage image, boolean blur, boolean clamp) {
        GpuDevice device = RenderSystem.getDevice();
        int width = image.getWidth();
        int height = image.getHeight() / 6;
        this.texture = device.createTexture(() -> "CustomCubeMap_" + this.name, 21, TextureFormat.RGBA8, width, height, 6, 1);
        this.textureView = device.createTextureView(this.texture);
        this.setFilter(blur, false);
        this.setClamp(clamp);
        for (int i = 0; i < 6; ++i) {
            device.createCommandEncoder().writeToTexture(this.texture, image, 0, i, 0, 0, width, height, 0, height * i);
        }
    }

    @NotNull
    public GpuTextureView getTextureView() {
        if (!this.loaded && !this.loadFailed) {
            this.loadTextures();
        }
        return super.getTextureView();
    }

    @NotNull
    public GpuTexture getTexture() {
        if (!this.loaded && !this.loadFailed) {
            this.loadTextures();
        }
        return super.getTexture();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isLoadFailed() {
        return this.loadFailed;
    }
}

