/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.advanced;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.text.ComponentParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientSideNbtDataGetPlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();

    public ClientSideNbtDataGetPlaceholder() {
        super("nbt_data_get");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String sourceType = dps.values.get("source_type");
        String nbtPath = dps.values.get("nbt_path");
        String scaleStr = dps.values.get("scale");
        String returnType = dps.values.get("return_type");
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return "";
        }
        if (sourceType == null || sourceType.isEmpty() || nbtPath == null || nbtPath.isEmpty()) {
            return "";
        }
        if (returnType == null || returnType.isEmpty()) {
            returnType = "value";
        }
        try {
            NbtPathArgument.NbtPath path = NbtPathArgument.NbtPath.of((String)nbtPath);
            CompoundTag sourceData = this.getSourceData(sourceType, dps);
            if (sourceData == null) {
                return "";
            }
            List tags = path.get((Tag)sourceData);
            if (tags.isEmpty()) {
                return "";
            }
            Tag tag = (Tag)tags.get(0);
            if ("string".equalsIgnoreCase(returnType)) {
                return tag.asString().orElse("");
            }
            if ("snbt".equalsIgnoreCase(returnType)) {
                return tag.toString();
            }
            if ("json".equalsIgnoreCase(returnType) && tag instanceof CompoundTag) {
                String json = ComponentParser.toJson(NbtUtils.toPrettyComponent((Tag)tag));
                if (json.startsWith("\"") && json.endsWith("\"")) {
                    return json.substring(1, json.length() - 1);
                }
                return json;
            }
            double scale = 1.0;
            if (scaleStr != null && !scaleStr.isEmpty()) {
                try {
                    scale = Double.parseDouble(scaleStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this.getTagValue(tag, scale);
        }
        catch (Exception e) {
            LOGGER.error("[FANCYMENU] Error in nbt_data_get placeholder", (Throwable)e);
            return "";
        }
    }

    @Nullable
    private CompoundTag getSourceData(String sourceType, DeserializedPlaceholderString dps) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return null;
        }
        switch (sourceType.toLowerCase(Locale.ROOT)) {
            case "entity": {
                return this.getEntityData(dps);
            }
            case "block": {
                return this.getBlockData(dps);
            }
        }
        return null;
    }

    @Nullable
    private CompoundTag getEntityData(DeserializedPlaceholderString dps) {
        String selector = dps.values.get("entity_selector");
        if (selector == null || selector.isEmpty()) {
            return null;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        ClientLevel level = Minecraft.getInstance().level;
        if (player == null || level == null) {
            return null;
        }
        Entity targetEntity = this.resolveEntitySelector(selector.trim(), player, level);
        if (targetEntity == null) {
            return null;
        }
        ProblemReporter.Collector collector = new ProblemReporter.Collector();
        TagValueOutput tagValueOutput = TagValueOutput.createWithContext((ProblemReporter)collector, (HolderLookup.Provider)targetEntity.registryAccess());
        targetEntity.saveWithoutId((ValueOutput)tagValueOutput);
        CompoundTag result = tagValueOutput.buildResult();
        if (!collector.isEmpty()) {
            LOGGER.warn("[FANCYMENU] Issues serializing entity NBT: {}", (Object)collector.getTreeReport());
        }
        return result;
    }

    @Nullable
    private CompoundTag getBlockData(DeserializedPlaceholderString dps) {
        String posStr = dps.values.get("block_pos");
        if (posStr == null || posStr.isEmpty()) {
            return null;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return null;
        }
        try {
            int z;
            int y;
            String[] parts = posStr.trim().split("\\s+");
            if (parts.length != 3) {
                return null;
            }
            int x = Integer.parseInt(parts[0]);
            BlockPos pos = new BlockPos(x, y = Integer.parseInt(parts[1]), z = Integer.parseInt(parts[2]));
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity != null) {
                return blockEntity.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.error("[FANCYMENU] Invalid block position: {}", (Object)posStr);
        }
        return null;
    }

    private String getTagValue(Tag tag, double scale) {
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            if (scale != 1.0) {
                return this.formatScaledNumeric(numericTag, scale);
            }
            return numericTag.asString().orElse("");
        }
        if (tag instanceof StringTag) {
            return tag.asString().orElse("");
        }
        return tag.toString();
    }

    private String formatScaledNumeric(NumericTag tag, double scale) {
        if (tag instanceof FloatTag) {
            float value = (float)(tag.asDouble().orElse(1.0) * scale);
            return Float.toString(value) + "f";
        }
        if (tag instanceof DoubleTag) {
            double value = tag.asDouble().orElse(1.0) * scale;
            return Double.toString(value) + "d";
        }
        long rounded = Math.round(tag.asDouble().orElse(1.0) * scale);
        if (tag instanceof ByteTag) {
            return Byte.toString((byte)rounded) + "b";
        }
        if (tag instanceof ShortTag) {
            return Short.toString((short)rounded) + "s";
        }
        if (tag instanceof IntTag) {
            return Integer.toString((int)rounded);
        }
        if (tag instanceof LongTag) {
            return Long.toString(rounded) + "L";
        }
        return Long.toString(rounded);
    }

    @Nullable
    private Entity resolveEntitySelector(String selector, LocalPlayer player, ClientLevel level) {
        SelectorTarget target;
        if (!selector.startsWith("@")) {
            return this.resolveByDirectReference(selector, level);
        }
        int bracketIndex = selector.indexOf(91);
        int closingIndex = selector.endsWith("]") ? selector.lastIndexOf(93) : -1;
        String base = bracketIndex == -1 ? selector : selector.substring(0, bracketIndex);
        String optionsRaw = "";
        if (bracketIndex != -1) {
            int end = closingIndex > bracketIndex ? closingIndex : selector.length();
            optionsRaw = selector.substring(bracketIndex + 1, end).trim();
        }
        if ((target = SelectorTarget.fromToken(base.trim())) == null) {
            return this.resolveByDirectReference(selector, level);
        }
        List<OptionValue> options = this.parseSelectorOptions(optionsRaw);
        double defaultX = player.getX();
        double defaultY = player.getY();
        double defaultZ = player.getZ();
        Double originX = null;
        Double originY = null;
        Double originZ = null;
        Double dx = null;
        Double dy = null;
        Double dz = null;
        MinMaxBounds.Doubles distance = MinMaxBounds.Doubles.ANY;
        SortOrder sort = target.defaultSort;
        int limit = target.defaultLimit;
        Filter<ResourceLocation> typeFilter = null;
        ArrayList<Filter<String>> nameFilters = new ArrayList<Filter<String>>();
        ArrayList<Filter<String>> tagFilters = new ArrayList<Filter<String>>();
        block32: for (OptionValue option : options) {
            String key = option.key();
            String value = option.value();
            switch (key) {
                case "type": {
                    if (value.isEmpty()) break;
                    boolean inverted = value.startsWith("!");
                    String raw = inverted ? value.substring(1) : value;
                    ResourceLocation typeId = this.parseResourceLocation(raw);
                    if (typeId == null) continue block32;
                    typeFilter = new Filter<ResourceLocation>(typeId, inverted);
                    break;
                }
                case "name": {
                    if (value.isEmpty()) break;
                    boolean inverted = value.startsWith("!");
                    String raw = inverted ? value.substring(1) : value;
                    if (raw.isEmpty()) continue block32;
                    nameFilters.add(new Filter<String>(raw, inverted));
                    break;
                }
                case "tag": {
                    if (value.isEmpty()) break;
                    boolean inverted = value.startsWith("!");
                    String raw = inverted ? value.substring(1) : value;
                    if (raw.isEmpty()) continue block32;
                    tagFilters.add(new Filter<String>(raw, inverted));
                    break;
                }
                case "limit": {
                    if (value.isEmpty()) break;
                    try {
                        int parsed = Integer.parseInt(value);
                        if (parsed <= 0) continue block32;
                        limit = parsed;
                    }
                    catch (NumberFormatException parsed) {}
                    break;
                }
                case "sort": {
                    if (value.isEmpty()) break;
                    SortOrder parsed = SortOrder.fromOption(value);
                    if (parsed == null) continue block32;
                    sort = parsed;
                    break;
                }
                case "distance": {
                    if (value.isEmpty()) break;
                    try {
                        distance = MinMaxBounds.Doubles.fromReader((StringReader)new StringReader(value));
                    }
                    catch (CommandSyntaxException ex) {
                        LOGGER.error("[FANCYMENU] Invalid distance option in selector '{}': {}", (Object)selector, (Object)ex.getMessage());
                    }
                    break;
                }
                case "x": {
                    originX = this.parseCoordinate(value, defaultX);
                    break;
                }
                case "y": {
                    originY = this.parseCoordinate(value, defaultY);
                    break;
                }
                case "z": {
                    originZ = this.parseCoordinate(value, defaultZ);
                    break;
                }
                case "dx": {
                    dx = this.parseDouble(value);
                    break;
                }
                case "dy": {
                    dy = this.parseDouble(value);
                    break;
                }
                case "dz": {
                    dz = this.parseDouble(value);
                    break;
                }
            }
        }
        if (target == SelectorTarget.SELF) {
            Vec3 origin = new Vec3(originX != null ? originX : defaultX, originY != null ? originY : defaultY, originZ != null ? originZ : defaultZ);
            AABB bounds = this.buildBounds(origin, dx, dy, dz);
            return this.entityMatchesFilters((Entity)player, typeFilter, nameFilters, tagFilters, distance, origin, bounds) ? player : null;
        }
        List<Entity> candidates = this.collectCandidates(target, level);
        if (candidates.isEmpty()) {
            return null;
        }
        Vec3 origin = new Vec3(originX != null ? originX : defaultX, originY != null ? originY : defaultY, originZ != null ? originZ : defaultZ);
        AABB bounds = this.buildBounds(origin, dx, dy, dz);
        @Nullable Filter<ResourceLocation> finalTypeFilter = typeFilter;
        MinMaxBounds.Doubles finalDistance = distance;
        candidates.removeIf(entity -> !this.entityMatchesFilters((Entity)entity, finalTypeFilter, (List<Filter<String>>)nameFilters, (List<Filter<String>>)tagFilters, finalDistance, origin, bounds));
        if (candidates.isEmpty()) {
            return null;
        }
        this.applySorting(candidates, sort, origin);
        if (limit < candidates.size()) {
            candidates = new ArrayList<Entity>(candidates.subList(0, limit));
        }
        return candidates.isEmpty() ? null : candidates.get(0);
    }

    @Nullable
    private Entity resolveByDirectReference(String selector, ClientLevel level) {
        String trimmed = selector.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        try {
            UUID uuid = UUID.fromString(trimmed);
            for (Entity entity : this.collectAllEntities(level)) {
                if (!uuid.equals(entity.getUUID())) continue;
                return entity;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        for (Entity entity : this.collectAllEntities(level)) {
            if (!entity.getName().getString().equals(trimmed)) continue;
            return entity;
        }
        return null;
    }

    private List<Entity> collectCandidates(SelectorTarget target, ClientLevel level) {
        List<Entity> all = this.collectAllEntities(level);
        if (target.includePlayers && target.includeNonPlayers) {
            return new ArrayList<Entity>(all);
        }
        ArrayList<Entity> filtered = new ArrayList<Entity>();
        for (Entity entity : all) {
            boolean isPlayer = entity instanceof Player;
            if ((!isPlayer || !target.includePlayers) && (isPlayer || !target.includeNonPlayers)) continue;
            filtered.add(entity);
        }
        return filtered;
    }

    private List<Entity> collectAllEntities(ClientLevel level) {
        HashSet<Integer> seenIds = new HashSet<Integer>();
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Entity entity : level.entitiesForRendering()) {
            if (entity == null || !seenIds.add(entity.getId())) continue;
            result.add(entity);
        }
        for (Player player : level.players()) {
            if (player == null || !seenIds.add(player.getId())) continue;
            result.add((Entity)player);
        }
        return result;
    }

    private void applySorting(List<Entity> entities, SortOrder sort, Vec3 origin) {
        switch (sort.ordinal()) {
            case 0: {
                entities.sort((a, b) -> Double.compare(a.distanceToSqr(origin), b.distanceToSqr(origin)));
                break;
            }
            case 1: {
                entities.sort((a, b) -> Double.compare(b.distanceToSqr(origin), a.distanceToSqr(origin)));
                break;
            }
            case 2: {
                for (int i = entities.size() - 1; i > 0; --i) {
                    int j = ThreadLocalRandom.current().nextInt(i + 1);
                    Collections.swap(entities, i, j);
                }
                break;
            }
        }
    }

    private boolean entityMatchesFilters(Entity entity, @Nullable Filter<ResourceLocation> typeFilter, List<Filter<String>> nameFilters, List<Filter<String>> tagFilters, MinMaxBounds.Doubles distance, Vec3 origin, @Nullable AABB bounds) {
        boolean matches;
        if (typeFilter != null) {
            Optional targetType = BuiltInRegistries.ENTITY_TYPE.getOptional(typeFilter.value());
            if (targetType.isPresent()) {
                boolean matches2;
                boolean bl = matches2 = entity.getType() == targetType.get();
                if (typeFilter.inverted() == matches2) {
                    return false;
                }
            } else if (!typeFilter.inverted()) {
                return false;
            }
        }
        if (!nameFilters.isEmpty()) {
            String name = entity.getName().getString();
            for (Filter<String> filter : nameFilters) {
                matches = name.equals(filter.value());
                if (filter.inverted() != matches) continue;
                return false;
            }
        }
        if (!tagFilters.isEmpty()) {
            Set tags = entity.getTags();
            for (Filter<String> filter : tagFilters) {
                matches = tags.contains(filter.value());
                if (filter.inverted() != matches) continue;
                return false;
            }
        }
        if (bounds != null && !bounds.intersects(entity.getBoundingBox())) {
            return false;
        }
        return distance == MinMaxBounds.Doubles.ANY || distance.matchesSqr(entity.distanceToSqr(origin));
    }

    @Nullable
    private AABB buildBounds(Vec3 origin, @Nullable Double dx, @Nullable Double dy, @Nullable Double dz) {
        if (dx == null && dy == null && dz == null) {
            return null;
        }
        double sizeX = dx != null ? dx : 0.0;
        double sizeY = dy != null ? dy : 0.0;
        double sizeZ = dz != null ? dz : 0.0;
        double minX = Math.min(origin.x(), origin.x() + sizeX);
        double minY = Math.min(origin.y(), origin.y() + sizeY);
        double minZ = Math.min(origin.z(), origin.z() + sizeZ);
        double maxX = Math.max(origin.x(), origin.x() + sizeX);
        double maxY = Math.max(origin.y(), origin.y() + sizeY);
        double maxZ = Math.max(origin.z(), origin.z() + sizeZ);
        return new AABB(minX, minY, minZ, maxX + 1.0, maxY + 1.0, maxZ + 1.0);
    }

    @Nullable
    private Double parseCoordinate(String raw, double reference) {
        if (raw == null || raw.isEmpty()) {
            return reference;
        }
        if (raw.charAt(0) == '~') {
            if (raw.length() == 1) {
                return reference;
            }
            Double offset = this.parseDouble(raw.substring(1));
            return offset == null ? null : Double.valueOf(reference + offset);
        }
        try {
            return Double.parseDouble(raw);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("[FANCYMENU] Invalid coordinate value: {}", (Object)raw);
            return null;
        }
    }

    @Nullable
    private Double parseDouble(String raw) {
        if (raw == null || raw.isEmpty()) {
            return null;
        }
        try {
            return Double.parseDouble(raw);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("[FANCYMENU] Invalid numeric selector option: {}", (Object)raw);
            return null;
        }
    }

    private ResourceLocation parseResourceLocation(String raw) {
        if (raw == null || raw.isEmpty()) {
            return null;
        }
        Object normalized = raw.contains(":") ? raw : "minecraft:" + raw;
        return ResourceLocation.tryParse((String)((String)normalized).toLowerCase(Locale.ROOT));
    }

    private List<OptionValue> parseSelectorOptions(String raw) {
        ArrayList<OptionValue> result = new ArrayList<OptionValue>();
        if (raw == null || raw.isEmpty()) {
            return result;
        }
        StringBuilder token = new StringBuilder();
        int depth = 0;
        boolean inQuotes = false;
        char quoteChar = '\u0000';
        for (int i = 0; i < raw.length(); ++i) {
            char c = raw.charAt(i);
            if (inQuotes) {
                if (c == quoteChar) {
                    inQuotes = false;
                    continue;
                }
                if (c == '\\' && i + 1 < raw.length()) {
                    token.append(raw.charAt(++i));
                    continue;
                }
                token.append(c);
                continue;
            }
            if (c == '\\' && i + 1 < raw.length()) {
                token.append(raw.charAt(++i));
                continue;
            }
            if (c == '\"' || c == '\'') {
                inQuotes = true;
                quoteChar = c;
                continue;
            }
            if (c == '{' || c == '[' || c == '(') {
                ++depth;
            } else if ((c == '}' || c == ']' || c == ')') && depth > 0) {
                --depth;
            }
            if (c == ',' && depth == 0) {
                this.appendOptionToken(token, result);
                token.setLength(0);
                continue;
            }
            token.append(c);
        }
        this.appendOptionToken(token, result);
        return result;
    }

    private void appendOptionToken(StringBuilder token, List<OptionValue> result) {
        String value;
        String key;
        if (token.isEmpty()) {
            return;
        }
        String entry = token.toString().trim();
        if (entry.isEmpty()) {
            return;
        }
        int index = entry.indexOf(61);
        if (index == -1) {
            key = entry.toLowerCase(Locale.ROOT);
            value = "";
        } else {
            key = entry.substring(0, index).trim().toLowerCase(Locale.ROOT);
            value = entry.substring(index + 1).trim();
        }
        result.add(new OptionValue(key, value));
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        return List.of("source_type", "entity_selector", "block_pos", "nbt_path", "scale", "return_type");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.placeholders.nbt_data_get.client", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.nbt_data_get.client.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.get((String)"fancymenu.requirements.categories.advanced", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("source_type", "entity");
        values.put("entity_selector", "@s");
        values.put("block_pos", "");
        values.put("nbt_path", "foodLevel");
        values.put("scale", "1.0");
        values.put("return_type", "value");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }

    private static enum SelectorTarget {
        SELF("@s", 1, SortOrder.ARBITRARY, true, true),
        NEAREST_PLAYER("@p", 1, SortOrder.NEAREST, true, false),
        ALL_PLAYERS("@a", Integer.MAX_VALUE, SortOrder.ARBITRARY, true, false),
        RANDOM_PLAYER("@r", 1, SortOrder.RANDOM, true, false),
        ALL_ENTITIES("@e", Integer.MAX_VALUE, SortOrder.ARBITRARY, true, true);

        private final String token;
        private final int defaultLimit;
        private final SortOrder defaultSort;
        private final boolean includePlayers;
        private final boolean includeNonPlayers;

        private SelectorTarget(String token, int defaultLimit, SortOrder defaultSort, boolean includePlayers, boolean includeNonPlayers) {
            this.token = token;
            this.defaultLimit = defaultLimit;
            this.defaultSort = defaultSort;
            this.includePlayers = includePlayers;
            this.includeNonPlayers = includeNonPlayers;
        }

        static SelectorTarget fromToken(String token) {
            for (SelectorTarget target : SelectorTarget.values()) {
                if (!target.token.equals(token)) continue;
                return target;
            }
            return null;
        }
    }

    private static enum SortOrder {
        NEAREST("nearest"),
        FURTHEST("furthest"),
        RANDOM("random"),
        ARBITRARY("arbitrary");

        private final String key;

        private SortOrder(String key) {
            this.key = key;
        }

        @Nullable
        static SortOrder fromOption(String value) {
            for (SortOrder order : SortOrder.values()) {
                if (!order.key.equalsIgnoreCase(value)) continue;
                return order;
            }
            return null;
        }
    }

    private record OptionValue(String key, String value) {
    }

    private record Filter<T>(T value, boolean inverted) {
    }
}

