/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.authlib.GameProfile;
import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public class MixinClientPacketListener {
    @Inject(method={"sendChat"}, at={@At(value="HEAD")})
    private void before_sendChat_FancyMenu(String message, CallbackInfo ci) {
        Listeners.ON_CHAT_MESSAGE_SENT.onChatMessageSent((Component)Component.literal((String)message));
    }

    @Inject(method={"handlePlayerInfoUpdate"}, at={@At(value="HEAD")})
    private void before_handlePlayerInfoUpdate_FancyMenu(ClientboundPlayerInfoUpdatePacket packet, CallbackInfo ci) {
        if (!packet.actions().contains(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER)) {
            return;
        }
        UUID localProfileId = Minecraft.getInstance().getUser().getProfileId();
        for (ClientboundPlayerInfoUpdatePacket.Entry entry : packet.newEntries()) {
            UUID profileId;
            GameProfile profile = entry.profile();
            if (profile == null || (profileId = profile.id()) == null || profileId.equals(localProfileId)) continue;
            Listeners.ON_OTHER_PLAYER_JOINED_WORLD.onOtherPlayerJoined(profile.name(), profileId);
        }
    }

    @Inject(method={"handlePlayerInfoRemove"}, at={@At(value="HEAD")})
    private void before_handlePlayerInfoRemove_FancyMenu(ClientboundPlayerInfoRemovePacket packet, CallbackInfo ci) {
        UUID localProfileId = Minecraft.getInstance().getUser().getProfileId();
        ClientPacketListener self = (ClientPacketListener)this;
        for (UUID profileId : packet.profileIds()) {
            if (profileId == null || profileId.equals(localProfileId)) continue;
            PlayerInfo playerInfo = self.getPlayerInfo(profileId);
            String playerName = playerInfo != null ? playerInfo.getProfile().name() : null;
            Listeners.ON_OTHER_PLAYER_LEFT_WORLD.onOtherPlayerLeft(playerName, profileId);
        }
    }

    @Inject(method={"handlePlayerCombatKill"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/network/PacketProcessor;)V", shift=At.Shift.AFTER)})
    private void after_handlePlayerCombatKillEnsureThread_FancyMenu(ClientboundPlayerCombatKillPacket packet, CallbackInfo ci) {
        Player player;
        block6: {
            block5: {
                Minecraft minecraft = Minecraft.getInstance();
                if (minecraft.level == null) {
                    return;
                }
                Entity entity = minecraft.level.getEntity(packet.playerId());
                if (!(entity instanceof Player)) break block5;
                player = (Player)entity;
                if (entity != minecraft.player) break block6;
            }
            return;
        }
        Vec3 deathPosition = player.position();
        String playerName = player.getGameProfile().name();
        if ((playerName == null || playerName.isBlank()) && player.getName() != null) {
            playerName = player.getName().getString();
        }
        Listeners.ON_OTHER_PLAYER_DIED.onOtherPlayerDied(playerName, player.getUUID(), deathPosition);
    }

    @Inject(method={"handlePlayerCombatKill"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setScreen(Lnet/minecraft/client/gui/screens/Screen;)V", shift=At.Shift.AFTER)})
    private void after_handlePlayerCombatKillSetScreen_FancyMenu(ClientboundPlayerCombatKillPacket packet, CallbackInfo ci) {
        int ticksSinceDeath;
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null) {
            return;
        }
        Long daysSurvived = null;
        StatsCounter stats = minecraft.player.getStats();
        if (stats != null && (ticksSinceDeath = stats.getValue(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_DEATH))) >= 0) {
            daysSurvived = ticksSinceDeath / 24000;
        }
        Vec3 deathPosition = minecraft.player.position();
        Listeners.ON_DEATH.onDeath(packet.message(), daysSurvived, deathPosition.x, deathPosition.y, deathPosition.z);
    }

    @WrapOperation(method={"handleTakeItemEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;shrink(I)V")})
    private void wrap_shrinkItem_FancyMenu(ItemStack stack, int amount, Operation<Void> operation, ClientboundTakeItemEntityPacket packet) {
        ResourceLocation itemLocation;
        boolean isLocalCollector;
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer == null) {
            operation.call(new Object[]{stack, amount});
            return;
        }
        ClientLevel level = minecraft.level;
        Entity potentialCollector = level != null ? level.getEntity(packet.getPlayerId()) : null;
        boolean bl = isLocalCollector = potentialCollector == localPlayer;
        if (!isLocalCollector && potentialCollector == null) {
            isLocalCollector = packet.getPlayerId() == localPlayer.getId();
        }
        String itemKey = null;
        if (!stack.isEmpty() && (itemLocation = BuiltInRegistries.ITEM.getKey((Object)stack.getItem())) != null) {
            itemKey = itemLocation.toString();
        }
        operation.call(new Object[]{stack, amount});
        if (!isLocalCollector || itemKey == null) {
            return;
        }
        Listeners.ON_ITEM_PICKED_UP.onItemPickedUp(itemKey);
    }
}

