/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mixin.mixins.common.client;

import de.keksuccino.fancymenu.util.rendering.ui.FancyMenuUiComponent;
import de.keksuccino.fancymenu.util.rendering.ui.screen.VanillaMouseClickHandlingScreen;
import java.util.List;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.MouseButtonEvent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ContainerEventHandler.class})
public interface MixinContainerEventHandler {
    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void head_mouseClicked_FancyMenu(MouseButtonEvent event, boolean isDoubleClick, CallbackInfoReturnable<Boolean> info) {
        if (this instanceof VanillaMouseClickHandlingScreen) {
            return;
        }
        for (GuiEventListener guiEventListener : this.children()) {
            if (!(guiEventListener instanceof FancyMenuUiComponent) || !guiEventListener.mouseClicked(event, isDoubleClick)) continue;
            if (guiEventListener.shouldTakeFocusAfterInteraction()) {
                this.setFocused(guiEventListener);
                if (event.button() == 0) {
                    this.setDragging(true);
                }
            }
            info.cancel();
            return;
        }
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")}, cancellable=true)
    private void head_mouseReleased_FancyMenu(MouseButtonEvent event, CallbackInfoReturnable<Boolean> info) {
        if (this instanceof VanillaMouseClickHandlingScreen) {
            return;
        }
        for (GuiEventListener guiEventListener : this.children()) {
            if (!(guiEventListener instanceof FancyMenuUiComponent)) continue;
            guiEventListener.mouseReleased(event);
        }
        if (this.getFocused() instanceof FancyMenuUiComponent) {
            if (event.button() == 0 && this.isDragging()) {
                this.setDragging(false);
            }
            info.cancel();
        }
    }

    @Shadow
    public List<? extends GuiEventListener> children();

    @Shadow
    @Nullable
    public GuiEventListener getFocused();

    @Shadow
    public void setFocused(GuiEventListener var1);

    @Shadow
    public boolean isDragging();

    @Shadow
    public void setDragging(boolean var1);
}

