/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mixin.mixins.common.client;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.WelcomeScreen;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiHandler;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import de.keksuccino.fancymenu.customization.listener.listeners.helpers.WorldSessionTracker;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.events.screen.CloseScreenEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenCompletedEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenStartingEvent;
import de.keksuccino.fancymenu.events.screen.OpenScreenEvent;
import de.keksuccino.fancymenu.events.screen.OpenScreenPostInitEvent;
import de.keksuccino.fancymenu.events.screen.ScreenTickEvent;
import de.keksuccino.fancymenu.events.ticking.ClientTickEvent;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.mcef.BrowserHandler;
import de.keksuccino.fancymenu.util.mcef.MCEFUtil;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.scrollnormalizer.ScrollScreenNormalizer;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.fancymenu.util.window.WindowHandler;
import java.net.SocketAddress;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.Connection;
import net.minecraft.server.WorldStem;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public class MixinMinecraft {
    @Unique
    private static final Logger LOGGER_FANCYMENU = LogManager.getLogger();
    @Unique
    private boolean lateClientInitDoneFancyMenu = false;
    @Unique
    private Screen lastScreen_FancyMenu = null;
    @Unique
    private static final String UNKNOWN_SERVER_IP_FANCYMENU = "ERROR";
    @Unique
    private boolean hasActiveServerConnection_FancyMenu;
    @Unique
    private boolean pendingServerJoinEvent_FancyMenu;
    @Unique
    @Nullable
    private String lastServerIp_FancyMenu;
    @Unique
    private boolean quitListenerFired_FancyMenu;
    @Shadow
    @Nullable
    public Screen screen;
    @Shadow
    @Nullable
    public ClientLevel level;
    @Shadow
    @Nullable
    public LocalPlayer player;

    @Inject(method={"stop"}, at={@At(value="HEAD")})
    private void before_stop_FancyMenu(CallbackInfo info) {
        if (!this.quitListenerFired_FancyMenu) {
            this.quitListenerFired_FancyMenu = true;
            Listeners.ON_QUIT_MINECRAFT.onQuitMinecraft();
        }
    }

    @Inject(method={"doWorldLoad(Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lnet/minecraft/server/packs/repository/PackRepository;Lnet/minecraft/server/WorldStem;Z)V"}, at={@At(value="HEAD")})
    private void before_doWorldLoad_FancyMenu(LevelStorageSource.LevelStorageAccess levelStorage, PackRepository packRepository, WorldStem worldStem, boolean newWorld, CallbackInfo info) {
        try {
            if (levelStorage != null && worldStem != null) {
                Path savePath = levelStorage.getLevelPath(LevelResource.ROOT).toAbsolutePath();
                String iconPath = levelStorage.getIconFile().map(path -> path.toAbsolutePath().toString()).orElse(null);
                String worldName = worldStem.worldData().getLevelName();
                WorldSessionTracker.prepareSession(worldName, savePath.toString(), iconPath, newWorld);
            } else {
                WorldSessionTracker.clearSession();
            }
        }
        catch (Exception ex) {
            LOGGER_FANCYMENU.error("[FANCYMENU] Failed to prepare world session data!", (Throwable)ex);
            WorldSessionTracker.clearSession();
        }
    }

    @Inject(method={"setOverlay"}, at={@At(value="HEAD")})
    private void beforeSetOverlayFancyMenu(Overlay overlay, CallbackInfo info) {
        if (!this.lateClientInitDoneFancyMenu) {
            this.lateClientInitDoneFancyMenu = true;
            FancyMenu.lateClientInit();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void beforeGameTickFancyMenu(CallbackInfo info) {
        if (this.pendingServerJoinEvent_FancyMenu && this.player != null) {
            this.fireServerJoined_FancyMenu();
        }
        if (MCEFUtil.isMCEFLoaded()) {
            BrowserHandler.tick();
        }
        for (Runnable r : MainThreadTaskExecutor.getAndClearQueue(MainThreadTaskExecutor.ExecuteTiming.PRE_CLIENT_TICK)) {
            try {
                r.run();
            }
            catch (Exception e) {
                LOGGER_FANCYMENU.error("[FANCYMENU] Error while executing PRE_CLIENT_TICK MainThread task!", (Throwable)e);
            }
        }
        EventHandler.INSTANCE.postEvent(new ClientTickEvent.Pre());
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void afterGameTickFancyMenu(CallbackInfo info) {
        EventHandler.INSTANCE.postEvent(new ClientTickEvent.Post());
        for (Runnable r : MainThreadTaskExecutor.getAndClearQueue(MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK)) {
            try {
                r.run();
            }
            catch (Exception e) {
                LOGGER_FANCYMENU.error("[FANCYMENU] Error while executing POST_CLIENT_TICK MainThread task!", (Throwable)e);
            }
        }
    }

    @Inject(method={"setLevel"}, at={@At(value="TAIL")})
    private void afterSetLevelFancyMenu(ClientLevel clientLevel, CallbackInfo ci) {
        String serverIp;
        Minecraft self = (Minecraft)this;
        if (clientLevel == null) {
            return;
        }
        if (self.isLocalServer()) {
            return;
        }
        if (this.hasActiveServerConnection_FancyMenu || this.pendingServerJoinEvent_FancyMenu) {
            return;
        }
        this.lastServerIp_FancyMenu = serverIp = this.fetchCurrentServerIp_FancyMenu();
        if (this.player != null) {
            this.fireServerJoined_FancyMenu();
        } else {
            this.pendingServerJoinEvent_FancyMenu = true;
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;tick()V")})
    private void beforeScreenTickFancyMenu(CallbackInfo info) {
        if (this.screen == null) {
            return;
        }
        EventHandler.INSTANCE.postEvent(new ScreenTickEvent.Pre(this.screen));
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;tick()V", shift=At.Shift.AFTER)})
    private void afterScreenTickFancyMenu(CallbackInfo info) {
        if (this.screen == null) {
            return;
        }
        EventHandler.INSTANCE.postEvent(new ScreenTickEvent.Post(this.screen));
    }

    @Inject(at={@At(value="HEAD")}, method={"createTitle"}, cancellable=true)
    private void changeWindowTitleFancyMenu(CallbackInfoReturnable<String> info) {
        String title = WindowHandler.getCustomWindowTitle();
        if (title != null) {
            info.setReturnValue((Object)title);
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="HEAD")}, cancellable=true)
    private void before_setScreen_FancyMenu(Screen screen, CallbackInfo info) {
        LayoutEditorScreen e;
        if (screen == null && this.level == null) {
            screen = new TitleScreen();
        } else if (screen == null && this.player != null && this.player.isDeadOrDying() && this.player.shouldShowDeathScreen()) {
            screen = new DeathScreen(null, this.level.getLevelData().isHardcore());
        }
        Screen finalScreen = screen;
        Screen screen2 = Minecraft.getInstance().screen;
        if (screen2 instanceof LayoutEditorScreen) {
            e = (LayoutEditorScreen)screen2;
            if (!(screen instanceof LayoutEditorScreen)) {
                e.layout.menuBackgrounds.forEach(menuBackground -> {
                    menuBackground.onCloseScreen(e, finalScreen);
                    menuBackground.onDisableOrRemove();
                });
                e.getAllElements().forEach(element -> {
                    element.element.onCloseScreen(e, finalScreen);
                    element.element.onDestroyElement();
                });
            }
        }
        if (screen instanceof LayoutEditorScreen) {
            e = (LayoutEditorScreen)screen;
            e.justOpened = true;
        }
        this.lastScreen_FancyMenu = this.screen;
        RenderingUtils.resetGuiScale();
        if (FancyMenu.getOptions().showWelcomeScreen.getValue().booleanValue() && screen instanceof TitleScreen) {
            info.cancel();
            Minecraft.getInstance().setScreen((Screen)new WelcomeScreen(screen));
            return;
        }
        Screen overrideWith = CustomGuiHandler.beforeSetScreen(screen);
        if (overrideWith != null) {
            info.cancel();
            Minecraft.getInstance().setScreen(overrideWith);
            return;
        }
        if (screen != null && screen != this.screen) {
            Screen cachedCurrent = this.screen;
            Listeners.ON_OPEN_SCREEN.onScreenOpened(screen);
            if (cachedCurrent != this.screen) {
                info.cancel();
            }
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="RETURN")})
    private void after_setScreen_FancyMenu(Screen screen, CallbackInfo info) {
        String newId;
        String lastId;
        boolean newScreenType = false;
        if (this.lastScreen_FancyMenu == null && this.screen != null) {
            newScreenType = true;
        } else if (this.lastScreen_FancyMenu != null && this.screen == null) {
            newScreenType = true;
        } else if (this.lastScreen_FancyMenu != null && this.screen != null && !(lastId = ScreenIdentifierHandler.getIdentifierOfScreen(this.lastScreen_FancyMenu)).equals(newId = ScreenIdentifierHandler.getIdentifierOfScreen(this.screen))) {
            newScreenType = true;
        }
        if (newScreenType) {
            ScreenCustomization.onSwitchingToNewScreenType(this.screen, this.lastScreen_FancyMenu);
        }
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;Z)V"}, at={@At(value="HEAD")})
    private void beforeDisconnectFancyMenu(Screen screen, boolean keepDownloadedResourcePacks, CallbackInfo info) {
        this.fireServerLeft_FancyMenu();
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;Z)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;level:Lnet/minecraft/client/multiplayer/ClientLevel;", opcode=181, ordinal=0, shift=At.Shift.BEFORE)})
    private void beforeLevelClearedWorldLeftFancyMenu(Screen screen, boolean keepDownloadedResourcePacks, CallbackInfo info) {
        WorldSessionTracker.handleWorldLeft((Minecraft)this);
    }

    @Inject(method={"clearClientLevel"}, at={@At(value="HEAD")})
    private void beforeClearClientLevelFancyMenu(Screen nextScreen, CallbackInfo info) {
        WorldSessionTracker.captureSnapshot((Minecraft)this);
        this.fireServerLeft_FancyMenu();
        WorldSessionTracker.handleWorldLeft((Minecraft)this);
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/KeyMapping;releaseAll()V", shift=At.Shift.AFTER)})
    private void beforeInitCurrentScreenFancyMenu(Screen screen, CallbackInfo info) {
        if (screen != null) {
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenStartingEvent(screen, InitOrResizeScreenEvent.InitializationPhase.INIT));
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Pre(screen, InitOrResizeScreenEvent.InitializationPhase.INIT));
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;updateTitle()V")})
    private void afterInitCurrentScreenFancyMenu(Screen screen, CallbackInfo info) {
        if (screen != null) {
            ScrollScreenNormalizer.normalizeScrollableScreen(screen);
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Post(screen, InitOrResizeScreenEvent.InitializationPhase.INIT));
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenCompletedEvent(screen, InitOrResizeScreenEvent.InitializationPhase.INIT));
            EventHandler.INSTANCE.postEvent(new OpenScreenPostInitEvent(screen));
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;removed()V")})
    private void beforeScreenRemovedFancyMenu(Screen screen, CallbackInfo info) {
        if (this.screen == null) {
            return;
        }
        EventHandler.INSTANCE.postEvent(new CloseScreenEvent(this.screen, screen));
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;removed()V", shift=At.Shift.AFTER)})
    private void afterScreenRemovedFancyMenu(Screen screen, CallbackInfo info) {
        if (this.lastScreen_FancyMenu != null) {
            Listeners.ON_CLOSE_SCREEN.onScreenClosed(this.lastScreen_FancyMenu);
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;added()V")})
    private void beforeScreenAddedFancyMenu(Screen screen, CallbackInfo info) {
        if (this.screen == null) {
            return;
        }
        EventHandler.INSTANCE.postEvent(new OpenScreenEvent(this.screen));
    }

    @Inject(method={"resizeDisplay"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/Window;setGuiScale(I)V", shift=At.Shift.AFTER)})
    private void beforeResizeCurrentScreenFancyMenu(CallbackInfo info) {
        if (this.screen != null) {
            RenderingUtils.resetGuiScale();
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenStartingEvent(this.screen, InitOrResizeScreenEvent.InitializationPhase.RESIZE));
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Pre(this.screen, InitOrResizeScreenEvent.InitializationPhase.RESIZE));
        }
    }

    @Inject(method={"resizeDisplay"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getMainRenderTarget()Lcom/mojang/blaze3d/pipeline/RenderTarget;")})
    private void afterResizeCurrentScreenFancyMenu(CallbackInfo info) {
        if (this.screen != null) {
            ScrollScreenNormalizer.normalizeScrollableScreen(this.screen);
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Post(this.screen, InitOrResizeScreenEvent.InitializationPhase.RESIZE));
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenCompletedEvent(this.screen, InitOrResizeScreenEvent.InitializationPhase.RESIZE));
        }
    }

    @Unique
    private void fireServerLeft_FancyMenu() {
        if (!this.hasActiveServerConnection_FancyMenu) {
            this.pendingServerJoinEvent_FancyMenu = false;
            this.lastServerIp_FancyMenu = null;
            return;
        }
        String serverIp = this.lastServerIp_FancyMenu != null && !this.lastServerIp_FancyMenu.isBlank() ? this.lastServerIp_FancyMenu : UNKNOWN_SERVER_IP_FANCYMENU;
        Listeners.ON_SERVER_LEFT.onServerLeft(serverIp);
        this.hasActiveServerConnection_FancyMenu = false;
        this.pendingServerJoinEvent_FancyMenu = false;
        this.lastServerIp_FancyMenu = null;
    }

    @Unique
    private void fireServerJoined_FancyMenu() {
        if (this.hasActiveServerConnection_FancyMenu) {
            return;
        }
        if (this.lastServerIp_FancyMenu == null || this.lastServerIp_FancyMenu.isBlank() || UNKNOWN_SERVER_IP_FANCYMENU.equals(this.lastServerIp_FancyMenu)) {
            this.lastServerIp_FancyMenu = this.fetchCurrentServerIp_FancyMenu();
        }
        String serverIp = this.lastServerIp_FancyMenu != null && !this.lastServerIp_FancyMenu.isBlank() ? this.lastServerIp_FancyMenu : UNKNOWN_SERVER_IP_FANCYMENU;
        this.pendingServerJoinEvent_FancyMenu = false;
        this.hasActiveServerConnection_FancyMenu = true;
        Listeners.ON_SERVER_JOINED.onServerJoined(serverIp);
    }

    @Unique
    private String fetchCurrentServerIp_FancyMenu() {
        String resolved;
        SocketAddress address;
        Connection connection;
        Minecraft self = (Minecraft)this;
        ServerData serverData = self.getCurrentServer();
        if (serverData != null && serverData.ip != null && !serverData.ip.isBlank()) {
            return serverData.ip;
        }
        ClientPacketListener listener = self.getConnection();
        if (listener != null && (connection = listener.getConnection()) != null && (address = connection.getRemoteAddress()) != null && (resolved = address.toString()) != null && !(resolved = resolved.trim()).isEmpty()) {
            if (resolved.startsWith("/")) {
                resolved = resolved.substring(1);
            }
            if (!resolved.isEmpty()) {
                return resolved;
            }
        }
        return UNKNOWN_SERVER_IP_FANCYMENU;
    }
}

