/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public class MixinMultiPlayerGameMode {
    @Unique
    @Nullable
    private String capturedItemUseKey_FancyMenu;
    @Unique
    @Nullable
    private String capturedUseItemKey_FancyMenu;

    @WrapOperation(method={"destroyBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;destroy(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V")})
    private void wrap_destroy_in_destroyBlock_FancyMenu(Block block, LevelAccessor level, BlockPos pos, BlockState state, Operation<Void> operation) {
        String usedItemKey = this.getMainHandItemKey_FancyMenu();
        operation.call(new Object[]{block, level, pos, state});
        if (level != null && level.isClientSide()) {
            Listeners.ON_BLOCK_BROKE.onBlockBroke(pos, state, usedItemKey);
        }
    }

    @Inject(method={"performUseItemOn"}, at={@At(value="HEAD")})
    private void before_performUseItemOn_captureItem_FancyMenu(LocalPlayer player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        this.capturedItemUseKey_FancyMenu = this.resolveItemKeyFromHand_FancyMenu((Player)player, hand);
    }

    @Inject(method={"performUseItemOn"}, at={@At(value="RETURN")})
    private void after_performUseItemOn_FancyMenu(LocalPlayer player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        InteractionResult result = (InteractionResult)cir.getReturnValue();
        if (result != null && result.consumesAction()) {
            String itemKey;
            Minecraft minecraft = Minecraft.getInstance();
            ClientLevel level = minecraft.level;
            BlockPos blockPos = hitResult.getBlockPos().immutable();
            BlockState state = null;
            String blockKey = "";
            String targetPosX = "-1";
            String targetPosY = "-1";
            String targetPosZ = "-1";
            if (level != null && level.isLoaded(blockPos)) {
                state = level.getBlockState(blockPos);
                blockKey = this.resolveBlockKey_FancyMenu(state);
                targetPosX = Integer.toString(blockPos.getX());
                targetPosY = Integer.toString(blockPos.getY());
                targetPosZ = Integer.toString(blockPos.getZ());
                Listeners.ON_INTERACTED_WITH_BLOCK.onBlockInteracted(blockPos, state);
            }
            if ((itemKey = this.capturedItemUseKey_FancyMenu) == null) {
                itemKey = this.resolveItemKeyFromHand_FancyMenu((Player)player, hand);
            }
            Listeners.ON_ITEM_USED.onItemUsed(itemKey, "block", "", blockKey, targetPosX, targetPosY, targetPosZ);
        }
        this.capturedItemUseKey_FancyMenu = null;
    }

    @WrapOperation(method={"performUseItemOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;useOn(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;")})
    private InteractionResult wrap_useOn_FancyMenu(ItemStack stack, UseOnContext context, Operation<InteractionResult> operation) {
        BlockState placedState;
        Level level;
        BlockItem blockItem = stack.getItem() instanceof BlockItem ? (BlockItem)stack.getItem() : null;
        BlockPos placePos = null;
        if (blockItem != null) {
            placePos = new BlockPlaceContext(context).getClickedPos();
        }
        InteractionResult result = (InteractionResult)operation.call(new Object[]{stack, context});
        if (blockItem != null && result != null && result.consumesAction() && (level = context.getLevel()) != null && level.isClientSide() && placePos != null && (placedState = level.getBlockState(placePos)).is(blockItem.getBlock())) {
            Listeners.ON_BLOCK_PLACED.onBlockPlaced(placePos, placedState);
        }
        return result;
    }

    @Inject(method={"useItem"}, at={@At(value="HEAD")})
    private void before_useItem_captureItem_FancyMenu(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        this.capturedUseItemKey_FancyMenu = player instanceof LocalPlayer ? this.resolveItemKeyFromHand_FancyMenu(player, hand) : null;
    }

    @Inject(method={"useItem"}, at={@At(value="RETURN")})
    private void after_useItem_FancyMenu(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        InteractionResult result = (InteractionResult)cir.getReturnValue();
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            if (result != null && result.consumesAction()) {
                String itemKey = this.capturedUseItemKey_FancyMenu;
                if (itemKey == null) {
                    itemKey = this.resolveItemKeyFromHand_FancyMenu(player, hand);
                }
                String usedOnType = "none";
                String entityKey = "";
                String targetPosX = "-1";
                String targetPosY = "-1";
                String targetPosZ = "-1";
                if (localPlayer.isUsingItem()) {
                    usedOnType = "self";
                    entityKey = this.resolveEntityKey_FancyMenu((Entity)localPlayer);
                    targetPosX = Double.toString(localPlayer.getX());
                    targetPosY = Double.toString(localPlayer.getY());
                    targetPosZ = Double.toString(localPlayer.getZ());
                }
                Listeners.ON_ITEM_USED.onItemUsed(itemKey, usedOnType, entityKey, "", targetPosX, targetPosY, targetPosZ);
            }
        }
        this.capturedUseItemKey_FancyMenu = null;
    }

    @WrapOperation(method={"interact"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;interactOn(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;")})
    private InteractionResult wrap_interactWithEntity_FancyMenu(Player player, Entity target, InteractionHand hand, Operation<InteractionResult> original) {
        String itemKey = this.resolveItemKeyFromHand_FancyMenu(player, hand);
        InteractionResult result = (InteractionResult)original.call(new Object[]{player, target, hand});
        if (itemKey == null) {
            itemKey = this.resolveItemKeyFromHand_FancyMenu(player, hand);
        }
        this.handleEntityInteractionResult_FancyMenu(player, target, result, itemKey);
        return result;
    }

    @WrapOperation(method={"interactAt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;interactAt(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;")})
    private InteractionResult wrap_interactAtWithEntity_FancyMenu(Entity target, Player player, Vec3 hitVec, InteractionHand hand, Operation<InteractionResult> original) {
        String itemKey = this.resolveItemKeyFromHand_FancyMenu(player, hand);
        InteractionResult result = (InteractionResult)original.call(new Object[]{target, player, hitVec, hand});
        if (itemKey == null) {
            itemKey = this.resolveItemKeyFromHand_FancyMenu(player, hand);
        }
        this.handleEntityInteractionResult_FancyMenu(player, target, result, itemKey);
        return result;
    }

    @Unique
    private void handleEntityInteractionResult_FancyMenu(Player player, Entity target, InteractionResult result, @Nullable String itemKey) {
        if (!(player instanceof LocalPlayer) || target == null) {
            return;
        }
        if (result == null || !result.consumesAction()) {
            return;
        }
        String entityKey = this.resolveEntityKey_FancyMenu(target);
        Listeners.ON_ITEM_USED.onItemUsed(itemKey, "entity", entityKey, "", Double.toString(target.getX()), Double.toString(target.getY()), Double.toString(target.getZ()));
        Listeners.ON_INTERACTED_WITH_ENTITY.onEntityInteracted(target);
    }

    @Unique
    private String getMainHandItemKey_FancyMenu() {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer == null) {
            return null;
        }
        return this.resolveItemKey_FancyMenu(localPlayer.getMainHandItem());
    }

    @Unique
    @Nullable
    private String resolveItemKeyFromHand_FancyMenu(@Nullable Player player, @Nullable InteractionHand hand) {
        if (player == null || hand == null) {
            return null;
        }
        return this.resolveItemKey_FancyMenu(player.getItemInHand(hand));
    }

    @Unique
    @Nullable
    private String resolveItemKey_FancyMenu(@Nullable ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        ResourceLocation itemLocation = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        return itemLocation != null ? itemLocation.toString() : null;
    }

    @Unique
    private String resolveBlockKey_FancyMenu(@Nullable BlockState state) {
        if (state == null) {
            return "";
        }
        ResourceLocation blockLocation = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        return blockLocation != null ? blockLocation.toString() : "";
    }

    @Unique
    private String resolveEntityKey_FancyMenu(@Nullable Entity entity) {
        if (entity == null) {
            return "";
        }
        ResourceLocation entityLocation = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        return entityLocation != null ? entityLocation.toString() : "";
    }
}

