/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util;

import de.keksuccino.fancymenu.util.input.MouseUtils;
import java.util.Objects;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaEvents {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int GLFW_NO_MODIFIERS = 0;
    @Nullable
    private static MouseButtonInfo latestVanillaMouseButtonInfo = null;
    private static long latestVanillaMouseButtonInfoCachingTime = -1L;

    @NotNull
    public static MouseButtonInfo getLatestVanillaMouseButtonInfoOrDummy() {
        long now = System.currentTimeMillis();
        if (latestVanillaMouseButtonInfoCachingTime != -1L && latestVanillaMouseButtonInfoCachingTime + 2000L < now) {
            LOGGER.warn("[FANCYMENU] Getting an possibly outdated latestVanillaMouseButtonInfo! Last caching time is more than 2 seconds in the past! This should be avoided.", (Throwable)new Exception("Outdated MouseButtonInfo in VanillaEvents!"));
        }
        if (latestVanillaMouseButtonInfo != null) {
            return latestVanillaMouseButtonInfo;
        }
        LOGGER.warn("[FANCYMENU] Getting latestVanillaMouseButtonInfo before caching it! This should be avoided.", (Throwable)new Exception("No MouseButtonInfo cached in VanillaEvents!"));
        return new MouseButtonInfo(0, -1);
    }

    public static void updateLatestVanillaMouseButtonInfo(@NotNull MouseButtonInfo info) {
        latestVanillaMouseButtonInfoCachingTime = System.currentTimeMillis();
        latestVanillaMouseButtonInfo = Objects.requireNonNull(info);
    }

    @NotNull
    public static MouseButtonEvent mouseButtonEvent(double mouseX, double mouseY, @NotNull MouseButtonInfo info) {
        return new MouseButtonEvent(mouseX, mouseY, info);
    }

    @NotNull
    public static MouseButtonEvent mouseButtonEvent(double mouseX, double mouseY, int button, int modifiers) {
        return VanillaEvents.mouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, modifiers));
    }

    @NotNull
    public static MouseButtonEvent mouseButtonEvent(double mouseX, double mouseY, int button) {
        MouseButtonInfo cached = VanillaEvents.getLatestVanillaMouseButtonInfoOrDummy();
        return VanillaEvents.mouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, cached.modifiers()));
    }

    @NotNull
    public static MouseButtonEvent mouseButtonEvent(int button) {
        MouseButtonInfo cached = VanillaEvents.getLatestVanillaMouseButtonInfoOrDummy();
        return VanillaEvents.mouseButtonEvent(MouseUtils.getScaledMouseX(), MouseUtils.getScaledMouseY(), new MouseButtonInfo(button, cached.modifiers()));
    }

    @NotNull
    public static MouseButtonEvent mouseButtonEvent(int button, int modifiers) {
        return VanillaEvents.mouseButtonEvent(MouseUtils.getScaledMouseX(), MouseUtils.getScaledMouseY(), new MouseButtonInfo(button, modifiers));
    }

    @NotNull
    public static MouseButtonEvent mouseButtonEvent(double mouseX, double mouseY) {
        return VanillaEvents.mouseButtonEvent(mouseX, mouseY, VanillaEvents.getLatestVanillaMouseButtonInfoOrDummy());
    }

    @NotNull
    public static MouseButtonEvent mouseButtonEvent() {
        return VanillaEvents.mouseButtonEvent(MouseUtils.getScaledMouseX(), MouseUtils.getScaledMouseY(), VanillaEvents.getLatestVanillaMouseButtonInfoOrDummy());
    }
}

