/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.enums;

import de.keksuccino.fancymenu.util.enums.NamedEnum;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public interface LocalizedEnum<E>
extends NamedEnum<E> {
    public static final Supplier<Style> SUCCESS_TEXT_STYLE = () -> Style.EMPTY.withColor(UIBase.getUIColorTheme().success_text_color.getColorInt());
    public static final Supplier<Style> WARNING_TEXT_STYLE = () -> Style.EMPTY.withColor(UIBase.getUIColorTheme().warning_text_color.getColorInt());
    public static final Supplier<Style> ERROR_TEXT_STYLE = () -> Style.EMPTY.withColor(UIBase.getUIColorTheme().error_text_color.getColorInt());

    @NotNull
    public String getLocalizationKeyBase();

    @NotNull
    default public String getValueLocalizationKey() {
        return this.getLocalizationKeyBase() + "." + this.getName();
    }

    @NotNull
    default public MutableComponent getValueComponent() {
        return Component.translatable((String)this.getValueLocalizationKey()).withStyle(this.getValueComponentStyle());
    }

    @NotNull
    default public Style getValueComponentStyle() {
        return Style.EMPTY;
    }
}

